/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.docker.core.internal.launch;

import com.ibm.ws.st.common.core.ext.internal.Activator;
import com.ibm.ws.st.common.core.ext.internal.UnsupportedServiceException;
import com.ibm.ws.st.common.core.ext.internal.servertype.AbstractServerBehaviourExtension;
import com.ibm.ws.st.common.core.ext.internal.setuphandlers.PlatformHandlerFactory;
import com.ibm.ws.st.common.core.ext.internal.util.BaseDockerContainer;
import com.ibm.ws.st.common.core.ext.internal.util.FileUtil;
import com.ibm.ws.st.core.internal.IPromptResponse;
import com.ibm.ws.st.core.internal.PromptAction;
import com.ibm.ws.st.core.internal.PromptHandler;
import com.ibm.ws.st.core.internal.PromptUtil;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerBehaviour;
import com.ibm.ws.st.core.internal.launch.WebSphereLaunchConfigurationDelegate;
import com.ibm.ws.st.docker.core.internal.Messages;
import com.ibm.ws.st.docker.core.internal.NewContainerPrompt;
import com.ibm.ws.st.docker.core.internal.Trace;
import com.ibm.ws.st.docker.core.internal.launch.LibertyDockerRunUtility;
import com.ibm.ws.st.docker.core.internal.launch.LibertyDockerServer;
import java.io.IOException;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;

public class LibertyDockerServerBehaviour
extends AbstractServerBehaviourExtension {
    public int count = 1;
    IPath appsOverridePath = null;
    private Map<IPath, IPath> pathMappingHash = null;
    Boolean directUserDirMount = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(ServerBehaviourDelegate behaviour, boolean force, IProgressMonitor monitor) {
        WebSphereServer server;
        if (Trace.ENABLED) {
            Trace.trace((byte)0, "Stopping the server");
        }
        if ((server = (WebSphereServer)behaviour.getServer().getAdapter(WebSphereServer.class)) != null) {
            Map serviceInfo = server.getServiceInfo();
            WebSphereServerBehaviour websphereBehaviour = null;
            try {
                if (serviceInfo != null) {
                    websphereBehaviour = server.getWebSphereServerBehaviour();
                    if (websphereBehaviour != null) {
                        websphereBehaviour.setServerAndModuleState(3);
                        LibertyDockerServer serverExt = (LibertyDockerServer)((Object)server.getAdapter(LibertyDockerServer.class));
                        BaseDockerContainer container = serverExt.getContainer(server);
                        websphereBehaviour.stopMonitorThread();
                        container.stop(monitor);
                    }
                } else if (Trace.ENABLED) {
                    Trace.trace((byte)1, "Could not load the service info");
                }
            }
            catch (Exception e) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)1, "Could not stop the server", e);
                }
            }
            finally {
                if (websphereBehaviour != null) {
                    websphereBehaviour.startMonitorThread();
                }
            }
        }
    }

    public IStatus canStop(ServerBehaviourDelegate behaviour) {
        WebSphereServerBehaviour websphereBehaviour = (WebSphereServerBehaviour)behaviour.getServer().loadAdapter(WebSphereServerBehaviour.class, (IProgressMonitor)new NullProgressMonitor());
        if (websphereBehaviour != null && !websphereBehaviour.getWebSphereServer().isLocalHost()) {
            if (Activator.getPlatformProvider((String)PlatformHandlerFactory.PlatformType.SSH_KEYLESS.name()) == null) {
                return new Status(4, "com.ibm.ws.st.core", Messages.E_RemoteServerActionsUnavailable);
            }
            if (!websphereBehaviour.getWebSphereServer().getIsRemoteServerStartEnabled()) {
                return new Status(4, "com.ibm.ws.st.core", Messages.E_RemoteServerActionsDisabled);
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus canRestart(ServerBehaviourDelegate behaviour) {
        WebSphereServerBehaviour websphereBehaviour = (WebSphereServerBehaviour)behaviour.getServer().loadAdapter(WebSphereServerBehaviour.class, (IProgressMonitor)new NullProgressMonitor());
        if (websphereBehaviour != null && !websphereBehaviour.getWebSphereServer().isLocalHost()) {
            if (Activator.getPlatformProvider((String)PlatformHandlerFactory.PlatformType.SSH_KEYLESS.name()) == null) {
                return new Status(4, "com.ibm.ws.st.core", Messages.E_RemoteServerActionsUnavailable);
            }
            if (!websphereBehaviour.getWebSphereServer().getIsRemoteServerStartEnabled()) {
                return new Status(4, "com.ibm.ws.st.core", Messages.E_RemoteServerActionsDisabled);
            }
        }
        return Status.OK_STATUS;
    }

    public boolean canCleanOnStart() {
        return false;
    }

    public Boolean isLooseConfigEnabled(ServerBehaviourDelegate behaviour) {
        WebSphereServerBehaviour websphereBehaviour = (WebSphereServerBehaviour)behaviour.getServer().loadAdapter(WebSphereServerBehaviour.class, (IProgressMonitor)new NullProgressMonitor());
        if (websphereBehaviour != null && websphereBehaviour.getWebSphereServer().isLocalHost()) {
            return new Boolean(true);
        }
        return new Boolean(false);
    }

    public IPath getAppsOverride(ServerBehaviourDelegate behaviour) {
        if (this.appsOverridePath != null) {
            return this.appsOverridePath;
        }
        WebSphereServer server = (WebSphereServer)behaviour.getServer().getAdapter(WebSphereServer.class);
        if (server != null) {
            LibertyDockerServer serverExt = (LibertyDockerServer)((Object)server.getAdapter(LibertyDockerServer.class));
            IPath serverAppsPath = server.getServerInfo().getServerAppsPath();
            IPath path = server.getServerInfo().getUserDirectory().getPath();
            IPath makeRelativeTo = serverAppsPath.makeRelativeTo(path);
            IPath appsFolder = null;
            String sourceMount = null;
            if (serverExt != null) {
                block9: {
                    Map serviceInfo = server.getServiceInfo();
                    String libertyUsrPath = LibertyDockerRunUtility.getLibertyUsrPath(serviceInfo);
                    try {
                        BaseDockerContainer container = serverExt.getContainer(server);
                        if (container != null && (sourceMount = container.getMountSourceForDestination(libertyUsrPath)) != null) {
                            appsFolder = new Path(sourceMount).append(makeRelativeTo);
                            appsFolder = BaseDockerContainer.getContainerToLocalPath((IPath)appsFolder);
                        }
                    }
                    catch (UnsupportedServiceException e) {
                        if (Trace.ENABLED) {
                            Trace.trace((byte)1, "Could not get Docker container", e);
                        }
                    }
                    catch (Exception e) {
                        if (!Trace.ENABLED) break block9;
                        Trace.trace((byte)1, "Failed to get the Docker container mount source for: " + libertyUsrPath, e);
                    }
                }
                if (appsFolder != null) {
                    this.appsOverridePath = appsFolder;
                    return appsFolder;
                }
            }
        }
        return super.getAppsOverride(behaviour);
    }

    public IPath getMappedPath(IPath path, ServerBehaviourDelegate behaviour) {
        Map<IPath, IPath> pathHash;
        if (this.isLooseConfigEnabled(behaviour).booleanValue() && (pathHash = this.getPathMappingHash(behaviour)) != null) {
            IPath fullPath = FileUtil.getCanonicalPath((IPath)path);
            for (Map.Entry<IPath, IPath> entry : pathHash.entrySet()) {
                IPath basePath = FileUtil.getCanonicalPath((IPath)entry.getKey());
                if (!basePath.isPrefixOf(fullPath)) continue;
                IPath relPath = fullPath.makeRelativeTo(basePath);
                IPath mappedPath = entry.getValue();
                if (relPath != null && !relPath.isEmpty()) {
                    mappedPath = mappedPath.append(relPath);
                }
                if (Trace.ENABLED) {
                    Trace.trace((byte)0, "The " + path + " path was mapped to: " + mappedPath);
                }
                return mappedPath;
            }
        }
        return super.getMappedPath(path, behaviour);
    }

    public synchronized Map<IPath, IPath> getPathMappingHash(ServerBehaviourDelegate behaviour) {
        if (this.pathMappingHash == null) {
            BaseDockerContainer container = this.getContainer(behaviour);
            if (container != null) {
                try {
                    this.pathMappingHash = container.getMountedVolumeHash();
                }
                catch (Exception e) {
                    Trace.logError("Failed to get the volumes for the " + container.getContainerName() + " container.", e);
                }
            } else {
                Trace.logError("Failed to get the container for the " + behaviour.getServer().getName() + " server.", null);
            }
        }
        return this.pathMappingHash;
    }

    private BaseDockerContainer getContainer(ServerBehaviourDelegate behaviour) {
        block3: {
            LibertyDockerServer serverExt;
            WebSphereServer server = (WebSphereServer)behaviour.getServer().getAdapter(WebSphereServer.class);
            if (server != null && (serverExt = (LibertyDockerServer)((Object)server.getAdapter(LibertyDockerServer.class))) != null) {
                try {
                    BaseDockerContainer container = serverExt.getContainer(server);
                    return container;
                }
                catch (UnsupportedServiceException e) {
                    if (!Trace.ENABLED) break block3;
                    Trace.trace((byte)1, "Could not get the Docker container for the " + behaviour.getServer().getName() + " server.", e);
                }
            }
        }
        return null;
    }

    private void doHandleLooseConfigChange(ServerBehaviourDelegate behaviour, boolean isLooseConfig) {
        final WebSphereServer websphereServer = (WebSphereServer)behaviour.getServer().getAdapter(WebSphereServer.class);
        if (websphereServer == null) {
            return;
        }
        final ISchedulingRule publishRule = MultiRule.combine((ISchedulingRule[])new ISchedulingRule[]{ResourcesPlugin.getWorkspace().getRoot(), websphereServer.getServer(), websphereServer.getWebSphereRuntime().getProject()});
        Job job = new Job(isLooseConfig ? Messages.dockerEnablingLooseConfigSettingJob : Messages.dockerDisablingLooseConfigSettingJob){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Job.getJobManager().beginRule(publishRule, monitor);
                    LibertyDockerServer serverExt = (LibertyDockerServer)((Object)websphereServer.getAdapter(LibertyDockerServer.class));
                    if (serverExt != null) {
                        Map serviceInfo = websphereServer.getServiceInfo();
                        String containerName = serverExt.getContainerName(websphereServer);
                        serviceInfo.put("dockerContainer", containerName);
                        String currentMode = serverExt.getCurrentMode(websphereServer);
                        websphereServer.getWebSphereServerBehaviour().restart(currentMode);
                    }
                    websphereServer.getWebSphereServerBehaviour().waitForServerStart(websphereServer.getServer(), monitor);
                    LibertyDockerServerBehaviour.this.resetCachedInfo();
                    websphereServer.getWebSphereServerBehaviour().publish(1, monitor);
                }
                catch (Exception e) {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)1, "Could not switch loose config modes.  Restart server failed.", e);
                    }
                    if (e instanceof CoreException) {
                        IStatus iStatus = ((CoreException)((Object)e)).getStatus();
                        return iStatus;
                    }
                    Status status = new Status(4, "com.ibm.ws.st.core", Messages.dockerCreateNewContainerError, (Throwable)e);
                    return status;
                }
                finally {
                    Job.getJobManager().endRule(publishRule);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return "com.ibm.ws.st.core.internalLaunchJobFamily".equals(family);
            }
        };
        job.setProperty(WebSphereLaunchConfigurationDelegate.INTERNAL_LAUNCH_SERVER_PROPERTY, (Object)behaviour.getServer());
        job.setRule(publishRule);
        job.schedule();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IStatus preSaveLooseConfigChange(ServerBehaviourDelegate behaviour, boolean isLooseConfig) {
        WebSphereServer server = (WebSphereServer)behaviour.getServer().getAdapter(WebSphereServer.class);
        if (server == null) return Status.OK_STATUS;
        LibertyDockerServer serverExt = (LibertyDockerServer)((Object)server.getAdapter(LibertyDockerServer.class));
        BaseDockerContainer container = null;
        if (serverExt == null) return Status.OK_STATUS;
        try {
            container = serverExt.getContainer(server);
            if (container == null) return Status.OK_STATUS;
            String msg = isLooseConfig ? Messages.dockerLooseConfigChangePromptEnableDetails : Messages.dockerLooseConfigChangePromptDisableDetails;
            NewContainerPrompt prompt = new NewContainerPrompt(msg);
            prompt.getActionHandler().prePromptAction(null, null, (IProgressMonitor)new NullProgressMonitor());
            PromptHandler promptHandler = com.ibm.ws.st.core.internal.Activator.getPromptHandler();
            if (promptHandler != null && !PromptUtil.isSuppressDialog()) {
                IPromptResponse response = promptHandler.getResponse(Messages.dockerLooseConfigChangePromptTitle, new PromptHandler.AbstractPrompt[]{prompt}, 257);
                if (response == null || response.getSelectedAction(prompt.getIssues()[0]) != PromptAction.YES) return Status.CANCEL_STATUS;
                this.doHandleLooseConfigChange(behaviour, isLooseConfig);
                return Status.OK_STATUS;
            } else {
                this.doHandleLooseConfigChange(behaviour, isLooseConfig);
            }
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            return Status.CANCEL_STATUS;
        }
    }

    public IStatus restartServer(final ServerBehaviourDelegate behaviour, String jobMessage, final IProgressMonitor progressMonitor) {
        final WebSphereServer websphereServer = (WebSphereServer)behaviour.getServer().getAdapter(WebSphereServer.class);
        if (websphereServer == null) {
            return Status.CANCEL_STATUS;
        }
        Job job = new Job(jobMessage){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Job.getJobManager().beginRule((ISchedulingRule)behaviour.getServer(), monitor);
                    LibertyDockerServer serverExt = (LibertyDockerServer)((Object)websphereServer.getAdapter(LibertyDockerServer.class));
                    if (serverExt != null) {
                        Map serviceInfo = websphereServer.getServiceInfo();
                        String containerName = serverExt.getContainerName(websphereServer);
                        serviceInfo.put("dockerContainer", containerName);
                        String currentMode = serverExt.getCurrentMode(websphereServer);
                        websphereServer.getWebSphereServerBehaviour().restart(currentMode, progressMonitor);
                    }
                    websphereServer.getWebSphereServerBehaviour().waitForServerStart(websphereServer.getServer(), monitor);
                    LibertyDockerServerBehaviour.this.resetCachedInfo();
                }
                catch (Exception e) {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)1, "Failed to restart the " + behaviour.getServer().getName() + " server.", e);
                    }
                    if (e instanceof CoreException) {
                        IStatus iStatus = ((CoreException)((Object)e)).getStatus();
                        return iStatus;
                    }
                    Status status = new Status(4, "com.ibm.ws.st.core", Messages.dockerCreateNewContainerError, (Throwable)e);
                    return status;
                }
                finally {
                    Job.getJobManager().endRule((ISchedulingRule)behaviour.getServer());
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return "com.ibm.ws.st.core.internalLaunchJobFamily".equals(family);
            }
        };
        job.setProperty(WebSphereLaunchConfigurationDelegate.INTERNAL_LAUNCH_SERVER_PROPERTY, (Object)behaviour.getServer());
        job.schedule();
        try {
            job.join();
            IStatus result = job.getResult();
            return result;
        }
        catch (InterruptedException e) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "The restart job for the " + behaviour.getServer().getName() + " server was interrupted.", e);
            }
            return Status.CANCEL_STATUS;
        }
    }

    public boolean doUpdateRemoteAppFiles(ServerBehaviourDelegate behaviour, boolean isLooseConfig) {
        return !isLooseConfig;
    }

    public void removeRemoteAppFiles(ServerBehaviourDelegate behaviour, IPath path, boolean isLooseConfig, IProgressMonitor monitor) {
        block5: {
            WebSphereServer server = (WebSphereServer)behaviour.getServer().getAdapter(WebSphereServer.class);
            if (server != null) {
                LibertyDockerServer serverExt = (LibertyDockerServer)((Object)server.getAdapter(LibertyDockerServer.class));
                BaseDockerContainer container = null;
                if (serverExt != null) {
                    try {
                        container = serverExt.getContainer(server);
                        if (container != null) {
                            Map serviceInfo = server.getServiceInfo();
                            String serverConfigPath = (String)serviceInfo.get("libertyServerConfigPath");
                            Path scPath = new Path(serverConfigPath);
                            IPath fileToRemove = scPath.append("apps").append(path.lastSegment());
                            container.deleteFile(fileToRemove.toString());
                        }
                    }
                    catch (Exception e) {
                        if (!Trace.ENABLED) break block5;
                        Trace.trace((byte)1, "Could not get delete the file from the Docker container", e);
                    }
                }
            }
        }
    }

    public boolean isLocalUserDir(ServerBehaviourDelegate behaviour) {
        WebSphereServer server = (WebSphereServer)behaviour.getServer().getAdapter(WebSphereServer.class);
        return server != null && server.isLooseConfigEnabled() && this.isDirectUserDirMount(behaviour);
    }

    private boolean isDirectUserDirMount(ServerBehaviourDelegate behaviour) {
        boolean result;
        block10: {
            if (this.directUserDirMount != null) {
                return this.directUserDirMount;
            }
            result = false;
            WebSphereServer server = (WebSphereServer)behaviour.getServer().getAdapter(WebSphereServer.class);
            if (server != null) {
                LibertyDockerServer serverExt = (LibertyDockerServer)((Object)server.getAdapter(LibertyDockerServer.class));
                IPath userDirPath = server.getServerInfo().getUserDirectory().getPath();
                String sourceMount = null;
                if (serverExt != null) {
                    try {
                        Map serviceInfo;
                        BaseDockerContainer container = serverExt.getContainer(server);
                        if (container != null && (sourceMount = container.getMountSourceForDestination(LibertyDockerRunUtility.getLibertyUsrPath(serviceInfo = server.getServiceInfo()))) != null) {
                            IPath sourcePath = BaseDockerContainer.getContainerToLocalPath((IPath)new Path(sourceMount));
                            this.directUserDirMount = userDirPath.toFile().getCanonicalPath().equals(sourcePath.toFile().getCanonicalPath()) ? Boolean.TRUE : Boolean.FALSE;
                            result = this.directUserDirMount;
                        }
                    }
                    catch (UnsupportedServiceException e) {
                        if (Trace.ENABLED) {
                            Trace.trace((byte)1, "Could not get Docker container", e);
                        }
                    }
                    catch (IOException e) {
                        if (Trace.ENABLED) {
                            Trace.trace((byte)1, "Comparison of the user directory to the mount source failed.", e);
                        }
                    }
                    catch (Exception e) {
                        if (!Trace.ENABLED) break block10;
                        Trace.trace((byte)1, "Failed to determine if Docker container has a direct user directory mount.", e);
                    }
                }
            }
        }
        return result;
    }

    protected void resetCachedInfo() {
        this.appsOverridePath = null;
        this.pathMappingHash = null;
        this.directUserDirMount = null;
    }
}

