/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.docker.core.internal;

import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.ws.st.common.core.ext.internal.UnsupportedServiceException;
import com.ibm.ws.st.common.core.ext.internal.setuphandlers.IPlatformHandler;
import com.ibm.ws.st.common.core.ext.internal.util.AbstractDockerMachine;
import com.ibm.ws.st.common.core.ext.internal.util.BaseDockerContainer;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.core.internal.config.DOMUtils;
import com.ibm.ws.st.core.internal.jmx.JMXConnection;
import com.ibm.ws.st.core.internal.launch.IUtilityExecutionDelegate;
import com.ibm.ws.st.docker.core.internal.Messages;
import com.ibm.ws.st.docker.core.internal.launch.LibertyDockerServer;
import java.io.IOException;
import java.net.ConnectException;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LibertyLocalDockerUtilityExecutionDelegate
implements IUtilityExecutionDelegate {
    private IProgressMonitor monitor2;
    private WebSphereServer wsServer;
    private Map<String, String> serviceInfo;
    private LibertyDockerServer serverExt;
    private String configPath;
    private IPath remoteUserDir;
    BaseDockerContainer container;
    private final int amountOfWork = 5;
    protected final long TIMEOUT = 600000L + AbstractDockerMachine.DEFAULT_TIMEOUT;

    public void initialize(IServer server, IProgressMonitor monitor) {
        if (Trace.ENABLED) {
            Trace.trace((byte)0, (String)"Start to execute.");
        }
        this.monitor2 = monitor;
        if (this.monitor2 == null) {
            this.monitor2 = new NullProgressMonitor();
        }
        this.monitor2.beginTask(NLS.bind((String)Messages.L_ExecutingCommands, (Object)server.getName()), 5);
        this.monitor2.subTask(NLS.bind((String)Messages.L_ExecutingCommands, (Object)server.getName()));
        this.wsServer = (WebSphereServer)server.loadAdapter(WebSphereServer.class, this.monitor2);
        this.serviceInfo = this.wsServer.getServiceInfo();
        this.serverExt = (LibertyDockerServer)((Object)this.wsServer.getAdapter(LibertyDockerServer.class));
        if (this.serviceInfo == null || this.serverExt == null) {
            // empty if block
        }
        this.configPath = this.serviceInfo.get("libertyServerConfigPath");
        if (this.configPath != null) {
            this.remoteUserDir = new Path(this.configPath).removeTrailingSeparator();
            try {
                this.container = this.serverExt.getContainer(this.wsServer);
            }
            catch (UnsupportedServiceException e) {
                Trace.logError((String)"Failed to initialize docker container", (Throwable)e);
            }
        }
        this.monitor2.worked(1);
    }

    public String getDockerRemoteOutputDir() throws Exception {
        JMXConnection jmx = this.wsServer.createJMXConnection();
        CompositeData metadata = (CompositeData)jmx.getMetadata("${server.output.dir}", "a");
        String remoteOutputDir = (String)metadata.get("fileName");
        remoteOutputDir = remoteOutputDir.replace("\\", "/");
        return remoteOutputDir;
    }

    public IPlatformHandler.ExecutionOutput execute(WebSphereServer server, String launchMode, ILaunch launch, String execCmd, String jobName, long timeout, IProgressMonitor monitor, boolean run) throws CoreException {
        int returnCode;
        IProgressMonitor monitor2 = monitor;
        if (monitor2 == null) {
            monitor2 = new NullProgressMonitor();
        }
        if (server == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, (String)"Could not find server");
            }
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", com.ibm.ws.st.core.internal.Messages.errorPromptServerNotFound));
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)0, (String)("Beginning job: " + jobName));
        }
        monitor2.beginTask(NLS.bind((String)jobName, (Object)server.getServerName()), -1);
        final IPlatformHandler.ExecutionOutput[] fJobResult = new IPlatformHandler.ExecutionOutput[1];
        LibertyDockerServer serverExt = (LibertyDockerServer)((Object)server.getAdapter(LibertyDockerServer.class));
        Map serviceInfo = server.getServiceInfo();
        if (serverExt == null || serviceInfo == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, (String)"Could not find server");
            }
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", com.ibm.ws.st.core.internal.Messages.errorDockerInfo));
        }
        String installPath = (String)serviceInfo.get("LibertyRuntimeInstallPath");
        if (this.container == null || installPath == null) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", com.ibm.ws.st.core.internal.Messages.errorDockerInfo));
        }
        Path pInstallpath = new Path(installPath);
        installPath = pInstallpath.removeTrailingSeparator().toString();
        String binPath = installPath + "/bin/";
        final String fCommand = binPath + execCmd;
        final long fTimeout = timeout;
        final ConnectException[] connectException = new ConnectException[1];
        Job job = new Job(jobName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)0, (String)("Executing docker command: " + fCommand));
                    }
                    fJobResult[0] = LibertyLocalDockerUtilityExecutionDelegate.this.container.dockerExec(fCommand, true, fTimeout);
                }
                catch (ConnectException e) {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)1, (String)"Error executing docker command", (Throwable)e);
                    }
                    connectException[0] = e;
                }
                return Status.OK_STATUS;
            }
        };
        long startTime = System.currentTimeMillis();
        final Runner running = new Runner();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                running.setDone(true);
            }
        });
        job.schedule();
        while (!running.isDone && !monitor2.isCanceled() && System.currentTimeMillis() - startTime < timeout) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (fJobResult[0] == null && connectException[0] != null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, (String)"ProcessResult is null");
            }
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", com.ibm.ws.st.core.internal.Messages.errorDockerInfo, (Throwable)connectException[0]));
        }
        if (monitor2.isCanceled()) {
            return null;
        }
        monitor2.done();
        int n = returnCode = fJobResult[0] == null ? -1 : fJobResult[0].getReturnCode();
        if (returnCode == 0) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, (String)("Successfully completed command: " + fCommand));
            }
            return fJobResult[0];
        }
        Trace.logError((String)("Execution failed for the command: " + execCmd + ", with output: " + fJobResult[0].getOutput() + ", and error" + fJobResult[0].getError()), null);
        String msg = fJobResult[0] != null && fJobResult[0].getError() != null && !fJobResult[0].getError().isEmpty() ? NLS.bind((String)com.ibm.ws.st.core.internal.Messages.W_RemoteServer_CommandReturnCodeWithError, (Object[])new String[]{execCmd, Integer.toString(returnCode), fJobResult[0].getError()}) : NLS.bind((String)com.ibm.ws.st.core.internal.Messages.W_RemoteServer_CommandReturnCode, (Object[])new String[]{execCmd, Integer.toString(returnCode)});
        throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", msg));
    }

    public static IPlatformHandler.ExecutionOutput copyOut(WebSphereServer wsServer, String sourcePath, String destinationPath, String jobName, long timeout, IProgressMonitor monitor) throws CoreException, UnsupportedServiceException {
        IProgressMonitor monitor2 = monitor;
        if (monitor2 == null) {
            monitor2 = new NullProgressMonitor();
        }
        if (wsServer == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, (String)"Could not find server");
            }
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", com.ibm.ws.st.core.internal.Messages.errorPromptServerNotFound));
        }
        monitor2.beginTask(NLS.bind((String)jobName, (Object)wsServer.getServerName()), -1);
        LibertyDockerServer serverExt = (LibertyDockerServer)((Object)wsServer.getAdapter(LibertyDockerServer.class));
        Map serviceInfo = wsServer.getServiceInfo();
        if (serverExt == null || serviceInfo == null) {
            Trace.logError((String)"The server information could not be retrieved", null);
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", com.ibm.ws.st.core.internal.Messages.errorDockerInfo));
        }
        final BaseDockerContainer container = serverExt.getContainer(wsServer);
        if (container == null) {
            Trace.logError((String)("A container could not be created for server: " + wsServer.getServerName()), null);
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", com.ibm.ws.st.core.internal.Messages.errorDockerInfo));
        }
        final long fTimeout = timeout;
        final String fSourcePath = sourcePath;
        final String fDestinationPath = destinationPath;
        final IPlatformHandler.ExecutionOutput[] jobResult = new IPlatformHandler.ExecutionOutput[1];
        Job job = new Job(jobName){

            protected IStatus run(IProgressMonitor monitor) {
                block2: {
                    try {
                        jobResult[0] = container.copyOut(fSourcePath, fDestinationPath, fTimeout);
                    }
                    catch (Exception e) {
                        if (!Trace.ENABLED) break block2;
                        Trace.trace((byte)1, (String)"Error executing docker command", (Throwable)e);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        long startTime = System.currentTimeMillis();
        final Runner running = new Runner();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                running.setDone(true);
            }
        });
        job.schedule();
        while (!running.isDone && !monitor2.isCanceled() && System.currentTimeMillis() - startTime < timeout) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (monitor2.isCanceled()) {
            return null;
        }
        monitor2.done();
        return jobResult[0];
    }

    public static String getZipFromOutput(String installPath, String zipName, String output) {
        String result = null;
        int start = output.indexOf(installPath);
        int end = output.indexOf(zipName);
        int len = zipName.length();
        if (start < end && len > 0) {
            result = output.substring(start, end + len);
        }
        return result;
    }

    public String getServerSecurityUtilityFilePath() {
        return "securityUtility ";
    }

    public String getServerScriptFilePath() {
        return "server ";
    }

    public String getServerUtilityFilePath(String command) {
        return command + " ";
    }

    public boolean fileExists(String remoteFilePath) throws Exception {
        return this.container.fileExists(remoteFilePath);
    }

    public void renameFile(String remoteOldFileName, String newName) throws Exception {
        this.container.renameFile(remoteOldFileName, newName);
    }

    public void deleteFile(String remoteFilePath, boolean recursiveDelete, boolean force) throws Exception {
        this.container.deleteFile(remoteFilePath);
    }

    public void modifyConfigFile(String includeFileName) throws Exception {
        ConfigurationFile serverConfig = this.wsServer.getServerInfo().getConfigRoot();
        boolean includeExists = false;
        if (serverConfig.hasElement("keyStore")) {
            serverConfig.removeElement("keyStore");
        }
        for (ConfigurationFile config : serverConfig.getAllIncludedFiles()) {
            if (!config.getPath().lastSegment().equals(includeFileName)) continue;
            includeExists = true;
            break;
        }
        if (!includeExists) {
            serverConfig.addInclude(false, includeFileName);
            try {
                serverConfig.save(null);
            }
            catch (IOException e) {
                Trace.logError((String)"Error occured while executing join collective command for remote server", (Throwable)e);
            }
        }
        try {
            this.container.copyIn(this.getLocalUserDir().append("server.xml").toOSString(), this.remoteUserDir.append("server.xml").toString());
        }
        catch (ConnectException e) {
            Trace.logError((String)"Could not sync local server.xml with server.xml on docker", (Throwable)e);
        }
    }

    public void uploadFile(String localFile, String destinationFile) throws Exception {
        this.container.copyIn(localFile, destinationFile);
    }

    public void downloadFile(IPath remoteFile, String destFile, IProgressMonitor monitor) throws CoreException {
        try {
            LibertyLocalDockerUtilityExecutionDelegate.copyOut(this.wsServer, this.getOSString(remoteFile.toString()), destFile, "ToDo", this.TIMEOUT, monitor);
        }
        catch (UnsupportedServiceException e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", e.getMessage()));
        }
    }

    public boolean matchPasswordField(IPath filePath, String expectedPassword) {
        boolean passwordsMatch = true;
        try {
            String actualPassword;
            Element elem;
            Element keyStoreElem;
            ConfigurationFile file = new ConfigurationFile(filePath.toFile().toURI(), this.wsServer.getUserDirectory(), this.wsServer.getServerInfo());
            Document doc = file.getDocument();
            if (doc != null && (keyStoreElem = DOMUtils.getFirstChildElement((Node)(elem = doc.getDocumentElement()), (String)"keyStore")) != null && !(actualPassword = PasswordUtil.decode((String)keyStoreElem.getAttribute("password"))).equals(expectedPassword)) {
                file.setAttribute("keyStore", "password", expectedPassword);
                file.save(null);
                passwordsMatch = false;
            }
        }
        catch (Exception e) {
            Trace.logError((String)("Unable to fetch the keystore password in file: " + filePath), (Throwable)e);
        }
        return passwordsMatch;
    }

    public IPath getLocalUserDir() {
        return this.wsServer.getServerInfo().getUserDirectory().getProject().getLocation().append("servers").append(this.wsServer.getServerName());
    }

    public IPath getRemoteOutputDir() throws Exception {
        JMXConnection jmx = this.wsServer.createJMXConnection();
        CompositeData metadata = (CompositeData)jmx.getMetadata("${server.output.dir}", "a");
        String remoteOutputDir = (String)metadata.get("fileName");
        remoteOutputDir = remoteOutputDir.replace("\\", "/");
        return new Path(remoteOutputDir);
    }

    public IPath getRemoteUserDir() {
        return this.remoteUserDir;
    }

    public boolean isDockerExecutionDelegate() {
        return true;
    }

    public boolean isExecutionSuccessful(IPlatformHandler.ExecutionOutput pr, String expectedSysOut) throws CoreException {
        if (pr == null || pr.getReturnCode() != 0) {
            return false;
        }
        return pr.getReturnCode() != 0 || pr.getOutput().contains(expectedSysOut);
    }

    public void startExecution() throws CoreException {
    }

    public void endExecution() {
    }

    public String getOSString(String path) {
        String osPath = path;
        osPath = path.replace("\\", "/");
        return osPath;
    }

    public static class Runner {
        protected boolean isDone = false;

        public boolean getIsDone() {
            return this.isDone;
        }

        public void setDone(boolean value) {
            this.isDone = value;
        }
    }
}

