/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.wizard;

import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.config.ConfigUtils;
import com.ibm.ws.st.core.internal.repository.IProduct;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.download.AddonUtil;
import com.ibm.ws.st.ui.internal.download.LocalProduct;
import com.ibm.ws.st.ui.internal.wizard.AbstractWebSphereServerComposite;
import com.ibm.ws.st.ui.internal.wizard.NewServerNameComposite;
import java.net.URI;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.w3c.dom.Document;

public class WebSphereDefaultServerComposite
extends AbstractWebSphereServerComposite {
    NewServerNameComposite nameComp;
    IRuntime runtime;
    private TaskModel taskModel = null;

    protected WebSphereDefaultServerComposite(Composite parent, IWizardHandle wizard, TaskModel taskModel) {
        super(parent, wizard);
        this.taskModel = taskModel;
        wizard.setDescription(Messages.wizServerDescription);
        wizard.setImageDescriptor(Activator.getImageDescriptor("wizServer"));
        this.createControl();
    }

    @Override
    protected void createControl() {
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        this.nameComp = new NewServerNameComposite(this, this.wizard, true);
        this.nameComp.setRuntime(this.runtime, null, null);
        Composite subComp = new Composite((Composite)this, 0);
        subComp.setLayout((Layout)new GridLayout());
        subComp.setLayoutData((Object)new GridData(1808));
        this.createConfigControl(subComp);
    }

    protected void setRuntime(IRuntime runtime, String archive) {
        this.runtime = runtime;
        this.nameComp.setRuntime(runtime, null, archive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performFinish(IProgressMonitor monitor) throws CoreException {
        IRuntime runtime = (IRuntime)this.taskModel.getObject("runtime");
        IRuntimeWorkingCopy runtimeWC = runtime.isWorkingCopy() ? (IRuntimeWorkingCopy)runtime : null;
        try {
            this.nameComp.createServer(monitor);
            this.server.setServerName(this.nameComp.getServerName());
            this.server.setUserDir(this.nameComp.getUserDir());
            this.removeGeneratedMetaData(runtime);
            if (runtimeWC != null && runtimeWC.getOriginal() == null) {
                List selectedList = (List)this.taskModel.getObject("selectedDownloaders");
                List result = (List)this.taskModel.getObject("installResult");
                LinkedHashMap<IProduct, IStatus> installResult = new LinkedHashMap<IProduct, IStatus>(selectedList.size());
                Iterator productItr = selectedList.iterator();
                Iterator statusItr = result.iterator();
                while (productItr.hasNext() && statusItr.hasNext()) {
                    installResult.put((IProduct)productItr.next(), (IStatus)statusItr.next());
                }
                AddonUtil.showResult(null, installResult);
            }
        }
        finally {
            if (runtimeWC != null && runtimeWC.getOriginal() == null) {
                monitor.done();
            }
        }
    }

    @Override
    protected void init() {
        IProduct core;
        Map map;
        IServerWorkingCopy wc = (IServerWorkingCopy)this.taskModel.getObject("server");
        this.runtime = (IRuntime)this.taskModel.getObject("runtime");
        String archiveSource = (String)this.taskModel.getObject("archive_source");
        if (archiveSource == null && (map = (Map)this.taskModel.getObject("addonMap")) != null && (core = (IProduct)map.get("coreManager")) instanceof LocalProduct) {
            archiveSource = core.getSource().getLocation();
        }
        this.setRuntime(this.runtime, archiveSource);
        this.serverWC = wc;
        this.server = (WebSphereServer)wc.loadAdapter(WebSphereServer.class, null);
        if (this.runtime == null) {
            return;
        }
        IPath templatePath = this.runtime.getLocation();
        if (templatePath == null) {
            return;
        }
        if (!(templatePath = templatePath.append("templates/servers/defaultServer/server.xml")).toFile().exists()) {
            this.setConfigControlVisible(false);
            return;
        }
        this.setConfigControlVisible(true);
        WebSphereRuntime wsRuntime = (WebSphereRuntime)this.runtime.loadAdapter(WebSphereRuntime.class, null);
        boolean metadataDirExistsBefore = wsRuntime == null ? false : wsRuntime.metadataDirectoryExists();
        Document document = XMLDocUtil.getXMLDoc(templatePath.toFile().toURI());
        if (document != null) {
            this.treeViewer.setInput((Object)document.getDocumentElement());
            if (!metadataDirExistsBefore && wsRuntime != null && wsRuntime.metadataDirectoryExists()) {
                this.addMetaDataRuntimeId(this.runtime);
            }
        } else if (Trace.ENABLED) {
            Trace.trace((byte)1, (String)"Default server template document is null. The default features will not be shown in the Server Creation wizard.");
        }
    }

    @Override
    public void validate() {
        if (this.nameComp != null) {
            this.nameComp.validate();
        }
    }

    @Override
    public boolean isComplete() {
        return this.nameComp == null || this.nameComp.isValid();
    }

    private static class XMLDocUtil
    extends ConfigUtils {
        private XMLDocUtil() {
        }

        static Document getXMLDoc(URI uri) {
            return XMLDocUtil.getDOMFromModel((URI)uri);
        }
    }
}

