/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.wizard;

import com.ibm.ws.st.common.core.ext.internal.AbstractServerSetup;
import com.ibm.ws.st.core.internal.FileUtil;
import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.config.ConfigUtils;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.core.internal.jmx.JMXConnection;
import com.ibm.ws.st.core.internal.jmx.JMXConnectionException;
import com.ibm.ws.st.core.internal.remote.RemoteUtils;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.wizard.AbstractWebSphereServerComposite;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.w3c.dom.Document;

public abstract class AbstractRemoteServerComposite
extends AbstractWebSphereServerComposite {
    protected ArrayList<IPath> downloadedFiles = new ArrayList(2);
    protected String serverConfigDir = "";
    protected String remoteUserPath = null;
    protected String userDir = null;
    protected String serverName = "defaultServer";

    protected AbstractRemoteServerComposite(Composite parent, IWizardHandle wizard) {
        super(parent, wizard);
    }

    protected abstract String getUserId();

    protected abstract String getUserPassword();

    protected abstract String getHost();

    protected abstract String getPort();

    protected ArrayList<Integer> remoteSecurityValidation(final AbstractServerSetup serverSetup) {
        final ArrayList<Integer> result = new ArrayList<Integer>();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.taskValidateSecurity, (int)100);
                String user = AbstractRemoteServerComposite.this.getUserId();
                String password = AbstractRemoteServerComposite.this.getUserPassword();
                int validation = serverSetup.validateRemoteSecurity(user, password, (IProgressMonitor)mon.newChild(100));
                result.add(validation);
            }
        };
        try {
            this.wizard.run(true, true, runnable);
        }
        catch (Exception e) {
            Trace.logError("Error validating the user security", e);
        }
        return result;
    }

    protected void remoteSecurityUpdate(final AbstractServerSetup serverSetup, final int code) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                IProgressMonitor mon = monitor;
                if (mon == null) {
                    mon = new NullProgressMonitor();
                }
                mon.beginTask(Messages.taskUpdateSecurity, 110);
                mon.worked(10);
                String user = AbstractRemoteServerComposite.this.getUserId();
                String password = AbstractRemoteServerComposite.this.getUserPassword();
                serverSetup.updateRemoteSecurity(user, password, code, mon);
            }
        };
        try {
            this.wizard.run(true, true, runnable);
        }
        catch (Exception e) {
            Trace.logError("Error validating the user security", e);
        }
    }

    protected MultiStatus remoteConfigSetup(final AbstractServerSetup serverSetup) {
        final String user = this.getUserId();
        final String passw = this.getUserPassword();
        final String host = this.getHost();
        final String port = this.getPort();
        final MultiStatus multiStatus = new MultiStatus("com.ibm.ws.st.ui", 0, com.ibm.ws.st.core.internal.Messages.remoteDownloadingServerConfigFile, null);
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                JMXConnection jmxConnection;
                Status downloadStatus;
                SubMonitor mon;
                block21: {
                    mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.taskPreparingServer, (int)150);
                    downloadStatus = new Status(0, "com.ibm.ws.st.ui", com.ibm.ws.st.core.internal.Messages.remoteDownloadingServerConfigFile);
                    AbstractRemoteServerComposite.this.discardTemporaryFiles();
                    if (mon.isCanceled()) {
                        multiStatus.add(Status.CANCEL_STATUS);
                        return;
                    }
                    mon.worked(10);
                    if (serverSetup != null) {
                        try {
                            serverSetup.setup((IProgressMonitor)mon.newChild(80));
                        }
                        catch (Exception e) {
                            Trace.logError("Setting up the server for remote administration failed.", e);
                            multiStatus.add((IStatus)new Status(4, "com.ibm.ws.st.ui", Messages.errorRemoteServerSetup, (Throwable)e));
                        }
                    }
                    if (mon.isCanceled()) {
                        multiStatus.add(Status.CANCEL_STATUS);
                        return;
                    }
                    mon.setWorkRemaining(60);
                    mon.setTaskName(Messages.taskConnecting);
                    jmxConnection = null;
                    try {
                        jmxConnection = AbstractRemoteServerComposite.this.connect(user, passw, host, port);
                    }
                    catch (JMXConnectionException e) {
                        multiStatus.add((IStatus)new Status(4, "com.ibm.ws.st.ui", com.ibm.ws.st.core.internal.Messages.remoteJMXConnectionFailure));
                        AbstractRemoteServerComposite.this.serverConfigDir = null;
                        if (!Trace.ENABLED) break block21;
                        Trace.trace((byte)0, "Failed to establish JMX connection with server", e);
                    }
                }
                if (mon.isCanceled()) {
                    multiStatus.add(Status.CANCEL_STATUS);
                    return;
                }
                mon.worked(20);
                if (AbstractRemoteServerComposite.this.serverWC == null) {
                    Trace.logError("Remote server creation failed. Server working copy is not initialized.", null);
                    downloadStatus = new Status(4, "com.ibm.ws.st.ui", Messages.wizRemoteServerDownloadFailed);
                }
                if (jmxConnection != null) {
                    mon.setTaskName(Messages.wizRemoteDownloadingServerConfigFile);
                    try {
                        AbstractRemoteServerComposite.this.serverConfigDir = RemoteUtils.getServerConfigDir((JMXConnection)jmxConnection);
                        AbstractRemoteServerComposite.this.serverName = RemoteUtils.getServerName((String)AbstractRemoteServerComposite.this.serverConfigDir);
                        IStatus serverValidation = AbstractRemoteServerComposite.this.validateServerName();
                        if (!serverValidation.isOK()) {
                            downloadStatus = serverValidation;
                            return;
                        }
                        AbstractRemoteServerComposite.this.serverWC.setAttribute("remoteStart_LibertyConfigPath", AbstractRemoteServerComposite.this.serverConfigDir);
                        String wlpInstallDir = RemoteUtils.getWLPInstallDir((JMXConnection)jmxConnection);
                        AbstractRemoteServerComposite.this.serverWC.setAttribute("remoteStart_LibertyRuntimePath", wlpInstallDir);
                        String osName = (String)jmxConnection.getMBeanAttribute("java.lang:type=OperatingSystem", "Name");
                        boolean isWindows = osName.toLowerCase().contains("windows");
                        if (isWindows) {
                            AbstractRemoteServerComposite.this.serverWC.setAttribute("remoteStart_Platform", 0);
                        } else {
                            AbstractRemoteServerComposite.this.serverWC.setAttribute("remoteStart_Platform", 2);
                        }
                        AbstractRemoteServerComposite.this.remoteUserPath = RemoteUtils.getUserDir((JMXConnection)jmxConnection);
                        AbstractRemoteServerComposite.this.userDir = AbstractRemoteServerComposite.this.server.getWebSphereRuntime().getRemoteUsrMetadataPath().toOSString().replace("\\", "/");
                        IPath userMetaDataPath = AbstractRemoteServerComposite.this.server.getWebSphereRuntime().getRemoteUsrMetadataPath();
                        if (mon.isCanceled()) {
                            multiStatus.add(Status.CANCEL_STATUS);
                            return;
                        }
                        mon.worked(10);
                        downloadStatus = RemoteUtils.downloadServerFiles((JMXConnection)jmxConnection, (IPath)userMetaDataPath, (String)AbstractRemoteServerComposite.this.serverName, AbstractRemoteServerComposite.this.downloadedFiles, (String)AbstractRemoteServerComposite.this.remoteUserPath, (String)AbstractRemoteServerComposite.this.userDir);
                        if (mon.isCanceled()) {
                            multiStatus.add(Status.CANCEL_STATUS);
                            return;
                        }
                        mon.worked(20);
                    }
                    catch (Exception e) {
                        Trace.logError(com.ibm.ws.st.core.internal.Messages.remoteServerDownloadFailed, e);
                        downloadStatus = new Status(4, "com.ibm.ws.st.ui", com.ibm.ws.st.core.internal.Messages.remoteServerDownloadFailed, (Throwable)e);
                    }
                }
                multiStatus.add((IStatus)downloadStatus);
                mon.setWorkRemaining(10);
                if (AbstractRemoteServerComposite.this.downloadedFiles.size() > 0 && downloadStatus != null && downloadStatus.isOK()) {
                    try {
                        File file = AbstractRemoteServerComposite.this.downloadedFiles.get(0).toFile();
                        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
                        ConfigurationFile.documentLoad((InputStream)in);
                    }
                    catch (Exception e) {
                        Trace.logError("The server configuration validation failed", e);
                        multiStatus.add((IStatus)new Status(4, "com.ibm.ws.st.ui", Messages.errorRemoteServerConfigInvalid, (Throwable)e));
                    }
                }
                if (mon.isCanceled()) {
                    multiStatus.add(Status.CANCEL_STATUS);
                    return;
                }
                mon.worked(10);
                mon.done();
            }
        };
        try {
            this.wizard.run(true, true, runnable);
        }
        catch (Exception e1) {
            Trace.logError("An unexpected exception occured while setting up the remote server", e1);
            multiStatus.add((IStatus)new Status(4, "com.ibm.ws.st.ui", Messages.errorRemoteServerSetup, (Throwable)e1));
        }
        return multiStatus;
    }

    protected UserDirectory createUserDir(String userDirName, IProgressMonitor monitor) throws CoreException {
        UserDirectory userDir = null;
        try {
            this.server.setServerName(this.serverName);
            userDir = RemoteUtils.createUserDir((WebSphereServer)this.server, (String)this.remoteUserPath, (String)userDirName, (IProgressMonitor)monitor);
            WebSphereRuntime wsRuntime = this.server.getWebSphereRuntime();
            if (userDir != null) {
                RemoteUtils.moveDownloadedFilesToUserDir((UserDirectory)userDir, this.downloadedFiles, (WebSphereRuntime)wsRuntime, (String)this.serverName);
                this.server.setUserDir(userDir);
                wsRuntime.updateServerCache(true);
            }
            this.removeGeneratedMetaData(wsRuntime.getRuntime());
        }
        catch (CoreException e) {
            try {
                if (userDir != null) {
                    userDir.getProject().delete(true, true, monitor);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        return userDir;
    }

    protected JMXConnection connect(String user, String password, String host, String port) throws JMXConnectionException {
        if (this.server == null) {
            return null;
        }
        JMXConnection jmxConnection = null;
        jmxConnection = new JMXConnection(host, port, user, password);
        jmxConnection.connect(5000L, 500L);
        return jmxConnection;
    }

    protected Document getServerConfigDocument() {
        Document document = null;
        try {
            if (this.downloadedFiles.size() > 0) {
                document = ConfigUtils.getDOMFromFile((File)this.downloadedFiles.get(0).toFile());
            }
        }
        catch (Throwable t) {
            Trace.logError("Error loading config tree", t);
        }
        return document;
    }

    protected void discardTemporaryFiles() {
        block4: {
            for (IPath file : this.downloadedFiles) {
                file.toFile().delete();
            }
            this.downloadedFiles.clear();
            IPath usrDir = RemoteUtils.getMetadataPath((WebSphereRuntime)this.server.getWebSphereRuntime(), (String)this.serverName);
            if (usrDir != null && usrDir.toFile().exists()) {
                try {
                    FileUtil.deleteDirectory((String)usrDir.toOSString(), (boolean)true);
                }
                catch (IOException e) {
                    if (!Trace.ENABLED) break block4;
                    Trace.logError("Failed to clean up remote server temp files", e);
                }
            }
        }
    }

    protected IStatus validateServerName() {
        if (this.server == null) {
            return new Status(4, "com.ibm.ws.st.ui", Messages.errorNoServers);
        }
        if (this.serverName == null) {
            return new Status(4, "com.ibm.ws.st.ui", Messages.errorNoServers);
        }
        return new Status(0, "com.ibm.ws.st.ui", "");
    }
}

