/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.plugin;

import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import java.util.ArrayList;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;

public class ServerUtil {
    public static IServer[] getServers() {
        IServer[] servers = ServerCore.getServers();
        ArrayList<IServer> list = new ArrayList<IServer>(3);
        for (IServer server : servers) {
            IServerType st = server.getServerType();
            if (st == null || !st.getId().startsWith("com.ibm.ws.st.server")) continue;
            list.add(server);
        }
        return list.toArray(new IServer[list.size()]);
    }

    public static IRuntime[] getRuntimes() {
        IRuntime[] runtimes = ServerCore.getRuntimes();
        ArrayList<IRuntime> list = new ArrayList<IRuntime>(3);
        for (IRuntime runtime : runtimes) {
            if (!WebSphereUtil.isWebSphereRuntime((IRuntime)runtime)) continue;
            list.add(runtime);
        }
        return list.toArray(new IRuntime[list.size()]);
    }

    public static IServer[] getServers(IRuntime runtime) {
        IServer[] servers = ServerCore.getServers();
        if (runtime == null || servers == null) {
            return null;
        }
        ArrayList<IServer> list = new ArrayList<IServer>();
        for (IServer server : servers) {
            if (!runtime.equals(server.getRuntime())) continue;
            list.add(server);
        }
        return list.toArray(new IServer[list.size()]);
    }

    public static void deleteServers(final IServer[] servers, boolean isWaitRequired) throws CoreException {
        final ServerActivity activity = new ServerActivity(Messages.taskDeletingServers);
        Job job = new Job(Messages.taskDeletingServers){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus status = Status.OK_STATUS;
                try {
                    for (IServer server : servers) {
                        server.delete();
                        if (!monitor.isCanceled()) continue;
                        status = Status.CANCEL_STATUS;
                        break;
                    }
                }
                catch (Exception e) {
                    Trace.logError("Error while deleting servers", e);
                    status = new Status(4, "com.ibm.ws.st.ui", 0, e.getMessage(), (Throwable)e);
                }
                activity.setIsDone(true);
                return status;
            }
        };
        int size = servers.length;
        ISchedulingRule[] rules = new ISchedulingRule[size + 1];
        for (int i = 0; i < size; ++i) {
            rules[i] = servers[i];
        }
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        rules[size] = ruleFactory.createRule((IResource)ResourcesPlugin.getWorkspace().getRoot());
        job.setRule(MultiRule.combine((ISchedulingRule[])rules));
        job.setPriority(40);
        job.schedule();
        if (isWaitRequired) {
            try {
                ServerUtil.waitForActivity(activity, 500, 10.0f);
            }
            catch (TimeoutException e) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.ui", e.getMessage()));
            }
        }
    }

    public static void stopServers(IServer[] servers) throws CoreException {
        final ServerActivity activity = new ServerActivity("");
        for (IServer server : servers) {
            activity.setName(NLS.bind((String)Messages.taskStoppingServer, (Object)server.getName()));
            activity.setIsDone(false);
            server.stop(false, new IServer.IOperationListener(){

                public void done(IStatus status) {
                    if (status.getCode() == 4) {
                        Trace.logError("Error encountered while stopping the server..", status.getException());
                    }
                    activity.setIsDone(true);
                }
            });
            try {
                ServerUtil.waitForActivity(activity, 500, server.getStopTimeout());
            }
            catch (TimeoutException e) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.ui", e.getMessage()));
            }
        }
    }

    private static void waitForActivity(ServerActivity activity, int pollingDelay, float timeout) throws TimeoutException {
        int iter = (int)(timeout * 1000.0f / (float)pollingDelay);
        for (int i = 0; i < iter; ++i) {
            try {
                Thread.sleep(pollingDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!activity.isDone()) continue;
            return;
        }
        throw new TimeoutException(NLS.bind((String)Messages.taskTimeoutError, (Object)activity.getName()));
    }

    private static class ServerActivity {
        private String name;
        private boolean isDone = false;

        protected ServerActivity(String name) {
            this.name = name;
        }

        protected void setName(String name) {
            this.name = name;
        }

        protected void setIsDone(boolean isDone) {
            this.isDone = isDone;
        }

        protected String getName() {
            return this.name;
        }

        protected boolean isDone() {
            return this.isDone;
        }
    }
}

