/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.plugin;

import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.ui.internal.Trace;
import java.util.Set;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;

public class RuntimeResourcePropertyTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IResource resource;
        if ("runtimeResource".equals(property)) {
            IResource resource2 = (IResource)Platform.getAdapterManager().getAdapter(receiver, IResource.class);
            if (resource2 != null) {
                IProject project = resource2.getProject();
                if (project == null) {
                    return false;
                }
                for (WebSphereRuntime runtime : WebSphereUtil.getWebSphereRuntimes()) {
                    for (UserDirectory userDir : runtime.getUserDirectories()) {
                        IProject userDirProject = userDir.getProject();
                        if (project != userDirProject) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        if ("runtimeTarget".equals(property) && (resource = (IResource)Platform.getAdapterManager().getAdapter(receiver, IResource.class)) != null) {
            IProject project = resource.getProject();
            if (project == null) {
                return false;
            }
            try {
                IServer[] servers;
                for (IServer server : servers = ServerCore.getServers()) {
                    IModule[] modules;
                    if (!WebSphereUtil.isWebSphereRuntime((org.eclipse.wst.server.core.IRuntime)server.getRuntime())) continue;
                    for (IModule m : modules = server.getModules()) {
                        if (!project.equals(m.getProject())) continue;
                        return true;
                    }
                }
            }
            catch (Exception e) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)1, "Error checking server-project association", e);
                }
                return true;
            }
            try {
                IFacetedProject fp = ProjectFacetsManager.create((IProject)project);
                if (fp == null) {
                    return false;
                }
                Set runtimes = fp.getTargetedRuntimes();
                for (IRuntime rt : runtimes) {
                    org.eclipse.wst.server.core.IRuntime runtime = FacetUtil.getRuntime((IRuntime)rt);
                    if (!WebSphereUtil.isWebSphereRuntime((org.eclipse.wst.server.core.IRuntime)runtime)) continue;
                    return true;
                }
            }
            catch (Exception e) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)1, "Error checking project runtime target", e);
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

