/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.download;

import com.ibm.ws.st.ui.internal.Messages;
import java.net.PasswordAuthentication;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PasswordDialog
extends MessageDialog {
    protected String userName = "";
    protected String password = "";

    public PasswordDialog(Shell parentShell, String dialogMessage, PasswordAuthentication authentication) {
        super(parentShell, Messages.loginPasswordDialogTitle, null, dialogMessage, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        if (authentication != null) {
            if (authentication.getUserName() != null) {
                this.userName = authentication.getUserName();
            }
            if (authentication.getPassword() != null) {
                this.password = new String(authentication.getPassword());
            }
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.loginPasswordDialogTitle);
    }

    public void create() {
        super.create();
        this.enableOKButton(false);
    }

    public Control createCustomArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label userLabel = new Label(composite, 0);
        userLabel.setText(Messages.user);
        userLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        final Text userText = new Text(composite, 2048);
        userText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        userText.setText(this.userName);
        Label passwordLabel = new Label(composite, 0);
        passwordLabel.setText(Messages.password);
        passwordLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        final Text passwordText = new Text(composite, 2048);
        passwordText.setEchoChar('*');
        passwordText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        passwordText.setText(this.password);
        userText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                PasswordDialog.this.userName = userText.getText();
                PasswordDialog.this.enableOKButton(PasswordDialog.this.isComplete());
            }
        });
        passwordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                PasswordDialog.this.password = passwordText.getText();
                PasswordDialog.this.enableOKButton(PasswordDialog.this.isComplete());
            }
        });
        return composite;
    }

    protected void enableOKButton(boolean value) {
        this.getButton(0).setEnabled(value);
    }

    protected boolean isComplete() {
        return !this.userName.isEmpty() && !this.password.isEmpty();
    }

    public String getUser() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }
}

