/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.download;

import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.repository.IProduct;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.download.AddonUtil;
import com.ibm.ws.st.ui.internal.download.AddonsWizardFragment;
import com.ibm.ws.st.ui.internal.download.DownloadHelper;
import com.ibm.ws.st.ui.internal.download.LicenseWizardFragment;
import com.ibm.ws.st.ui.internal.download.SiteHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class ExtendRuntimeWizardContainer
extends WizardFragment {
    private List<WizardFragment> cachedList;

    protected void createChildFragments(List<WizardFragment> list) {
        if (this.cachedList == null) {
            this.cachedList = new ArrayList<WizardFragment>();
            this.cachedList.add(new AddonsWizardFragment());
            this.cachedList.add(new LicenseWizardFragment());
        }
        list.addAll(this.cachedList);
    }

    public void performFinish(IProgressMonitor monitor) {
        String propsURL;
        Map map = (Map)this.getTaskModel().getObject("addonMap");
        if (map == null) {
            return;
        }
        List selectedList = (List)map.get("selectedDownloaders");
        if (selectedList.isEmpty()) {
            return;
        }
        IRuntime runtime = (IRuntime)this.getTaskModel().getObject("runtime");
        WebSphereRuntime wsRuntime = (WebSphereRuntime)runtime.loadAdapter(WebSphereRuntime.class, null);
        int totalTicks = 100;
        int metadataTicks = wsRuntime != null && AddonUtil.isRefreshMetadataRequired(selectedList) ? 20 : 0;
        monitor.beginTask(Messages.jobInstallingRuntime, totalTicks);
        List authList = (List)map.get("productAuthentication");
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("runtimeLocation", new Path((String)map.get("folder")));
        settings.put("vmInstall", wsRuntime == null ? JavaRuntime.getDefaultVMInstall() : wsRuntime.getVMInstall());
        if (SiteHelper.isProxyNeeded() && (propsURL = SiteHelper.getRepoPropertiesURL()) != null) {
            settings.put("repoPropsLocation", propsURL);
        }
        Map<IProduct, IStatus> result = DownloadHelper.install(selectedList, authList, settings, (IProgressMonitor)new SubProgressMonitor(monitor, totalTicks - metadataTicks));
        if (wsRuntime != null && result.containsValue(Status.OK_STATUS)) {
            if (metadataTicks > 0) {
                AddonUtil.refreshMetadata(wsRuntime, (IProgressMonitor)new SubProgressMonitor(monitor, metadataTicks));
            }
            wsRuntime.refresh();
            wsRuntime.fireMetadataRefreshEvent();
        }
        AddonUtil.showResult(null, result);
        monitor.done();
    }
}

