/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.download;

import com.ibm.ws.st.core.internal.FileUtil;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.config.FeatureList;
import com.ibm.ws.st.core.internal.repository.AbstractInstaller;
import com.ibm.ws.st.core.internal.repository.FeatureInstaller;
import com.ibm.ws.st.core.internal.repository.IProduct;
import com.ibm.ws.st.core.internal.repository.IRemoteSource;
import com.ibm.ws.st.core.internal.repository.IRuntimeInfo;
import com.ibm.ws.st.core.internal.repository.License;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.download.ConfigSnippetInstaller;
import com.ibm.ws.st.ui.internal.download.ExtractorInstaller;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.PasswordAuthentication;
import java.net.SocketException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntime;

public class DownloadHelper {
    private static final int BUFFER_SIZE = 8192;
    private static ExtractorInstaller defaultInstaller = new ExtractorInstaller();
    private static FeatureInstaller featureInstaller = new FeatureInstaller();
    private static ConfigSnippetInstaller configSnippetInstaller = new ConfigSnippetInstaller();
    private static final String[] SHARED_FOLDERS = new String[]{"usr/shared/apps", "usr/shared/config", "usr/shared/resources"};
    private static final NumberFormat numberFormat = NumberFormat.getIntegerInstance();
    protected static final Pattern RUNTIME_FILE_NAME_PATTERN;

    static AbstractInstaller getInstaller(IProduct product) {
        if (product.getType() == IProduct.Type.FEATURE) {
            return featureInstaller;
        }
        if (product.getType() == IProduct.Type.CONFIG_SNIPPET) {
            return configSnippetInstaller;
        }
        return defaultInstaller;
    }

    public static String getSize(long size) {
        return DownloadHelper.getSize(size, numberFormat);
    }

    public static String getSize(long size, NumberFormat f) {
        float s = (float)size / 1024.0f;
        if (s < 1024.0f) {
            return f.format(s) + " KB";
        }
        return f.format(s / 1024.0f) + " MB";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<IProduct, IStatus> install(List<IProduct> installList, List<PasswordAuthentication> authList, Map<String, Object> settings, IProgressMonitor monitor2) {
        IProgressMonitor monitor = monitor2;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        LinkedHashMap<IProduct, IStatus> result = new LinkedHashMap<IProduct, IStatus>();
        try {
            monitor.beginTask(Messages.jobInstallingRuntime, 50 * installList.size());
            for (int i = 0; i < installList.size(); ++i) {
                IProduct p = installList.get(i);
                AbstractInstaller installer = DownloadHelper.getInstaller(p);
                IStatus status = installer.install(p, authList == null ? null : authList.get(i), settings, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                result.put(p, status);
            }
        }
        finally {
            monitor.done();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void unzip(List<File> files, IPath path, IProgressMonitor monitor2) throws CoreException {
        IProgressMonitor monitor = monitor2;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        long totalSize = 0L;
        for (File file : files) {
            totalSize += (long)((int)(file.length() / 10240L));
        }
        monitor.beginTask(Messages.jobInstallingRuntime, (int)totalSize);
        try {
            for (File file : files) {
                try {
                    long length = file.length();
                    DownloadHelper.unzip(file, path, length, (IProgressMonitor)new SubProgressMonitor(monitor, (int)(length / 10240L)), null);
                }
                catch (Exception e) {
                    if (monitor.isCanceled()) {
                        monitor.done();
                        return;
                    }
                    try {
                        Trace.logError("Error unzipping file: " + file.getName(), e);
                        throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.ui", 0, NLS.bind((String)Messages.errorInstallingRuntimeEnvironment, (Object)(path.toOSString() + "\n\n")) + e.getLocalizedMessage(), (Throwable)e));
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return;
                    }
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    public static void download(IProduct product, File temp, IProgressMonitor monitor) throws IOException {
        byte[] BUFFER = new byte[8192];
        FileOutputStream out = null;
        int currentWorked = 0;
        int processedSize = 0;
        try {
            InputStream in = ((IRemoteSource)product.getSource()).getInputStream();
            if (in == null) {
                throw new IOException(NLS.bind((String)Messages.errorInvalidInputStream, (Object)product.getName()));
            }
            long archiveSize = product.getSize();
            String msg = NLS.bind((String)Messages.taskDownloading, (Object[])new Object[]{"{0}", DownloadHelper.getSize(archiveSize)});
            monitor.beginTask(NLS.bind((String)msg, (Object)"0"), 1000);
            out = new FileOutputStream(temp);
            int r = in.read(BUFFER);
            while (r >= 0) {
                out.write(BUFFER, 0, r);
                int newWorked = (int)(1000.0f * (float)(processedSize += r) / (float)archiveSize);
                if (newWorked - currentWorked > 3) {
                    String displayName = product.getName() == null ? "" : product.getName() + " ";
                    monitor.subTask(displayName + NLS.bind((String)msg, (Object)DownloadHelper.getSize(processedSize)));
                    int deltaWork = newWorked - currentWorked;
                    currentWorked += deltaWork;
                    monitor.worked(deltaWork);
                }
                if (monitor.isCanceled()) {
                    break;
                }
                r = in.read(BUFFER);
            }
        }
        catch (IOException e) {
            Trace.logError("Failed to download runtime installation files", e);
            throw new IOException(Messages.errorDownloadingInstallFiles + "\n\n" + e.getLocalizedMessage(), e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void unzip(File srcFile, IPath path, long totalSize, final IProgressMonitor monitor, String fileDisplayName) throws IOException {
        try {
            String fileNameToDisplay = fileDisplayName == null ? srcFile.getName() : fileDisplayName;
            String extractorClass = DownloadHelper.getExtractorClassName(srcFile);
            if (extractorClass == null) {
                DownloadHelper.legacyUnzip(srcFile, path, totalSize, monitor);
            } else {
                Map<String, Object> extractor = DownloadHelper.createExtractor(srcFile, extractorClass);
                extractor.put("license.accept", Boolean.TRUE);
                extractor.put("install.dir", path.toFile());
                int size = (Integer)extractor.get("install.monitor.size");
                String msg = NLS.bind((String)Messages.taskUncompressing, (Object[])new Object[]{"{0}", DownloadHelper.getSize(totalSize)});
                monitor.beginTask(NLS.bind((String)msg, (Object)"0"), size);
                monitor.subTask(fileNameToDisplay);
                extractor.put("install.monitor", new ArrayList<Object>(){

                    @Override
                    public boolean add(Object e) {
                        monitor.worked(1);
                        return !monitor.isCanceled();
                    }
                });
                int rc2 = (Integer)extractor.get("install.code");
                if (rc2 != 0) {
                    msg = (String)extractor.get("install.error.message");
                    throw new IOException(msg);
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    static String getExtractorClassName(File srcFile) throws IOException {
        JarFile jarFile = new JarFile(srcFile);
        Manifest man = jarFile.getManifest();
        String extractorClass = null;
        if (man != null) {
            extractorClass = man.getMainAttributes().getValue("Map-Based-Self-Extractor");
        }
        jarFile.close();
        return extractorClass;
    }

    private static Map<String, Object> createExtractor(File srcFile, String extractorClass) throws IOException {
        try {
            URLClassLoader loader = new URLClassLoader(new URL[]{srcFile.toURI().toURL()}, null);
            Class<?> clazz = loader.loadClass(extractorClass);
            Map extractor = (Map)clazz.newInstance();
            Integer result = extractor.put("install.version", 1);
            if (result == null) {
                throw new IOException(Messages.unsupportedInstaller);
            }
            int rc = (Integer)extractor.get("installer.init.code");
            if (rc == 0) {
                return extractor;
            }
            throw new IOException((String)extractor.get("installer.init.error.message"));
        }
        catch (Exception e) {
            throw new IOException(Messages.unexpectedInstallerError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void legacyUnzip(File srcFile, IPath path, long totalSize, IProgressMonitor monitor) throws IOException {
        byte[] BUFFER = new byte[8192];
        FileInputStream in = null;
        ZipInputStream zin = null;
        int currentWorked = 0;
        int processedSize = 0;
        try {
            File binFolder;
            File[] scripts;
            String msg = NLS.bind((String)Messages.taskUncompressing, (Object[])new Object[]{"{0}", DownloadHelper.getSize(totalSize)});
            monitor.beginTask(NLS.bind((String)msg, (Object)"0"), 1000);
            if (!path.toFile().exists() && !path.toFile().mkdirs()) {
                throw new IOException("Could not create folder: " + path);
            }
            in = new FileInputStream(srcFile);
            BufferedInputStream bin = new BufferedInputStream(in);
            zin = new ZipInputStream(bin);
            ZipEntry entry = zin.getNextEntry();
            while (entry != null) {
                int newWorked;
                String name = entry.getName();
                int index = name.indexOf("/");
                if (index >= 0) {
                    name = name.substring(index + 1);
                }
                if (entry.isDirectory()) {
                    if (!path.append(name).toFile().exists() && !path.append(name).toFile().mkdirs()) {
                        throw new IOException("Could not create folder: " + path.append(name));
                    }
                } else {
                    FileOutputStream fout = null;
                    try {
                        File f = path.append(name).toFile();
                        File parent = f.getParentFile();
                        if (!parent.exists() && !parent.mkdirs()) {
                            throw new IOException("Could not create folder: " + path.append(name));
                        }
                        fout = new FileOutputStream(f);
                        int r = zin.read(BUFFER);
                        while (r >= 0) {
                            fout.write(BUFFER, 0, r);
                            r = zin.read(BUFFER);
                        }
                    }
                    finally {
                        block40: {
                            try {
                                if (fout != null) {
                                    fout.close();
                                }
                            }
                            catch (IOException e) {
                                if (!Trace.ENABLED) break block40;
                                Trace.trace((byte)1, "Trouble closing output stream", e);
                            }
                        }
                    }
                }
                if ((newWorked = (int)(1000.0f * (float)(processedSize = (int)((long)processedSize + entry.getCompressedSize())) / (float)totalSize)) - currentWorked > 3) {
                    monitor.subTask(srcFile.getName() + " " + NLS.bind((String)msg, (Object)DownloadHelper.getSize(processedSize)));
                    int deltaWork = newWorked - currentWorked;
                    currentWorked += deltaWork;
                    monitor.worked(deltaWork);
                }
                zin.closeEntry();
                entry = zin.getNextEntry();
                if (!monitor.isCanceled()) continue;
                return;
            }
            if (srcFile.getName().endsWith(".jar")) {
                File f = path.toFile();
                for (int i = 0; i < SHARED_FOLDERS.length; ++i) {
                    File sharedFile = new File(f, SHARED_FOLDERS[i]);
                    if (sharedFile.exists() || sharedFile.mkdirs()) continue;
                    throw new IOException("Could not create folder: " + sharedFile.getAbsolutePath());
                }
            }
            if ((scripts = (binFolder = path.append("bin").toFile()).listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return !name.contains(".");
                }
            })) != null && scripts.length > 0) {
                for (File s : scripts) {
                    s.setExecutable(true);
                }
            }
        }
        finally {
            block43: {
                block42: {
                    try {
                        if (zin != null) {
                            zin.close();
                        }
                    }
                    catch (IOException e) {
                        if (!Trace.ENABLED) break block42;
                        Trace.trace((byte)1, "Trouble closing zip input stream", e);
                    }
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    if (!Trace.ENABLED) break block43;
                    Trace.trace((byte)1, "Trouble closing input stream", e);
                }
            }
            monitor.done();
        }
    }

    public static List<File> getArchives() {
        List<File> folders = DownloadHelper.getFolders();
        ArrayList<File> buildsFound = new ArrayList<File>();
        for (File folderToSearch : folders) {
            File[] files = folderToSearch.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return RUNTIME_FILE_NAME_PATTERN.matcher(name).find();
                }
            });
            if (files == null) continue;
            buildsFound.addAll(Arrays.asList(files));
        }
        if (buildsFound.size() > 1) {
            Collections.sort(buildsFound, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    return o2.getName().compareTo(o1.getName());
                }
            });
        }
        return buildsFound;
    }

    private static List<File> getFolders() {
        ArrayList<File> folders = new ArrayList<File>();
        String osName = System.getProperty("os.name");
        String userHome = System.getProperty("user.home");
        folders.add(new File(userHome));
        if (osName != null) {
            if ((osName = osName.trim().toLowerCase()).contains("win")) {
                folders.add(new File(userHome, "Desktop"));
                folders.add(new File(userHome, "My Documents/Downloads"));
            } else if (osName.contains("mac")) {
                folders.add(new File(userHome, "Desktop"));
                folders.add(new File(userHome, "Downloads"));
            } else {
                folders.add(new File(userHome, "tmp"));
                folders.add(new File(System.getProperty("java.io.tmpdir")));
            }
        }
        return folders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static License getLicense(File archiveFile) throws IOException {
        String s;
        String extractorClass = DownloadHelper.getExtractorClassName(archiveFile);
        if (extractorClass == null) {
            String licenseText = DownloadHelper.getLegacyLicense(archiveFile);
            if (licenseText == null) {
                return null;
            }
            return new License(null, licenseText);
        }
        Map<String, Object> extractor = DownloadHelper.createExtractor(archiveFile, extractorClass);
        Reader r = (Reader)extractor.get("license.agreement");
        if (r == null) {
            return null;
        }
        String licenseName = (String)extractor.get("license.name");
        StringBuilder license = new StringBuilder();
        license.append("<HTML>\n<HEAD>\n<META HTTP-EQUIV=\"content-type\" CONTENT=\"text/html; charset=UTF-8\"/>\n<TITLE>Software License</TITLE>\n</HEAD>\n<BODY>\n");
        BufferedReader in = null;
        try {
            in = new BufferedReader(r);
            s = in.readLine();
            while (s != null) {
                license.append(s + "<br>\n");
                s = in.readLine();
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            r.close();
        }
        license.append("<br>\n");
        r = (Reader)extractor.get("license.info");
        if (r != null) {
            in = null;
            try {
                in = new BufferedReader(r);
                s = in.readLine();
                while (s != null) {
                    license.append(s + "<br>\n");
                    s = in.readLine();
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
                r.close();
            }
        }
        license.append("</BODY>\n</HTML>");
        return new License(licenseName, license.toString());
    }

    private static String getLegacyLicense(File archiveFile) throws IOException {
        BufferedReader in = null;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(archiveFile);
            Locale locale = Locale.getDefault();
            String[] filesToFind = new String[]{"LA_" + locale, "LA_" + locale.getLanguage(), "LA_" + Locale.ENGLISH.getLanguage()};
            for (int i = 0; i < filesToFind.length; ++i) {
                ZipEntry entry = zipFile.getEntry("wlp/lafiles/" + filesToFind[i]);
                if (entry == null) continue;
                in = new BufferedReader(new InputStreamReader(zipFile.getInputStream(entry), "UTF-16"));
                String s = in.readLine();
                StringBuilder license = new StringBuilder();
                while (s != null) {
                    license.append(s + "\r\n");
                    s = in.readLine();
                }
                String string = license.toString();
                return string;
            }
            String string = null;
            return string;
        }
        catch (IOException e) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Could not get license", e);
            }
            throw e;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static boolean isSSLWorking() {
        try {
            SSLSocketFactory.getDefault().createSocket();
        }
        catch (SocketException e) {
            if (e.getCause() instanceof ClassNotFoundException) {
                return false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public static String validateTargetRuntimeLocation(String folder) {
        if (folder == null || folder.trim().isEmpty()) {
            return "";
        }
        Path path = new Path(folder);
        if (!path.toFile().isAbsolute()) {
            return Messages.errorInvalidFolder;
        }
        if (path.toFile().exists()) {
            if (path.toFile().isFile()) {
                return Messages.errorInvalidFolder;
            }
            String[] s = path.toFile().list();
            if (s != null && s.length > 0) {
                return Messages.errorFolderNotEmpty;
            }
        }
        if (path.hasTrailingSeparator()) {
            return com.ibm.ws.st.core.internal.Messages.errorInstallDirTrailingSlash;
        }
        return null;
    }

    static String readFully(InputStream in, String encoding) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, encoding));
        StringBuilder builder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            builder.append(line);
            builder.append('\r');
            builder.append('\n');
        }
        reader.close();
        in.close();
        return builder.toString();
    }

    public static IRuntimeInfo getRuntimeCore(final IRuntime runtime) {
        final WebSphereRuntime wsRuntime = (WebSphereRuntime)runtime.loadAdapter(WebSphereRuntime.class, null);
        final ArrayList<IRuntimeInfo.IProduct> productList = new ArrayList<IRuntimeInfo.IProduct>();
        if (wsRuntime != null) {
            List paths = wsRuntime.getRuntimePropertiesPaths();
            for (IPath path : paths) {
                Properties prop = new Properties();
                FileUtil.loadProperties((Properties)prop, (IPath)path);
                productList.add(DownloadHelper.createProduct(prop));
            }
        }
        if (productList.isEmpty()) {
            Properties prop = new Properties();
            productList.add(DownloadHelper.createProduct(prop));
        }
        return new IRuntimeInfo(){

            public List<IRuntimeInfo.IProduct> getProducts() {
                return productList;
            }

            public String getVersion() {
                return ((IRuntimeInfo.IProduct)productList.get(0)).getProductVersion();
            }

            public String getPrimaryProductId() {
                return ((IRuntimeInfo.IProduct)productList.get(0)).getProductId();
            }

            public List<String> getInstalledFeatures() {
                if (wsRuntime == null) {
                    return null;
                }
                return FeatureList.getSymbolicNameFeatures((boolean)false, (WebSphereRuntime)wsRuntime);
            }

            public IPath getLocation() {
                return runtime.getLocation();
            }

            public boolean isOnPremiseSupported() {
                if (wsRuntime == null) {
                    return false;
                }
                return wsRuntime.isOnPremiseSupported();
            }
        };
    }

    private static IRuntimeInfo.IProduct createProduct(final Properties prop) {
        return new IRuntimeInfo.IProduct(){

            public String getProductId() {
                return prop.getProperty("com.ibm.websphere.productId");
            }

            public String getProductVersion() {
                return prop.getProperty("com.ibm.websphere.productVersion");
            }

            public String getProductEdition() {
                return prop.getProperty("com.ibm.websphere.productEdition");
            }

            public String getProductInstallType() {
                return prop.getProperty("com.ibm.websphere.productInstallType");
            }

            public String getProductLicenseType() {
                return prop.getProperty("com.ibm.websphere.productLicenseType");
            }
        };
    }

    static {
        numberFormat.setMinimumFractionDigits(1);
        numberFormat.setMaximumFractionDigits(1);
        RUNTIME_FILE_NAME_PATTERN = Pattern.compile("wlp-developers-\\d+\\.\\d\\.\\w+\\.\\w+\\.jar");
    }
}

