/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.download;

import com.ibm.ws.st.core.internal.repository.IProduct;
import com.ibm.ws.st.core.internal.repository.ISite;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.download.AbstractDownloadComposite;
import com.ibm.ws.st.ui.internal.download.AddonsComposite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ConfigSnippetComposite
extends AddonsComposite {
    public ConfigSnippetComposite(Composite parent, Map<String, Object> map, AbstractDownloadComposite.IContainer container, AbstractDownloadComposite.IMessageHandler handler) {
        super(parent, map, container, handler);
        container.setDescription(Messages.wizInstallConfigSnippetDescription);
    }

    @Override
    protected void createControl() {
        super.createControl();
        this.addArchive.setEnabled(false);
    }

    @Override
    protected void initializeTypeFilterList() {
        this.typeFilterList.add(IProduct.Type.CONFIG_SNIPPET);
        this.typeFilterMenuList.add(IProduct.Type.CONFIG_SNIPPET);
    }

    @Override
    protected void handleDrop(String[] files, Text filterText) {
    }

    @Override
    public void exit() {
        List selectedAddOn = (List)this.map.get("selectedAddOns");
        if (selectedAddOn != null && !selectedAddOn.isEmpty()) {
            ArrayList<IProduct> configList = new ArrayList<IProduct>();
            for (IProduct p : selectedAddOn) {
                if (p.getType() != IProduct.Type.CONFIG_SNIPPET) continue;
                configList.add(p);
            }
            List<IProduct> requireList = this.getRequiredFeatures(configList);
            if (!requireList.isEmpty()) {
                ArrayList<IProduct> addList = new ArrayList<IProduct>(requireList.size());
                for (IProduct p : requireList) {
                    if (selectedAddOn.contains(p)) continue;
                    addList.add(p);
                }
                if (!addList.isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    for (IProduct p : addList) {
                        sb.append("    - ").append(p.getName()).append("\n");
                    }
                    if (MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.wizInstallAddonTitle, (String)NLS.bind((String)Messages.wizInstallMissingFeatures, (Object)sb.toString()))) {
                        selectedAddOn.addAll(addList);
                    }
                }
            }
        }
        super.exit();
    }

    @Override
    protected boolean isCoreRuntimeExpected() {
        return false;
    }

    private List<IProduct> getRequiredFeatures(List<IProduct> productList) {
        if (productList == null || productList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IProduct> requireList = new ArrayList<IProduct>();
        for (IProduct product : productList) {
            List featureList = product.getRequireFeature();
            if (featureList == null || featureList.isEmpty()) continue;
            for (String f : featureList) {
                for (IProduct p : this.allApplicableAddOnList) {
                    if (p.getType() != IProduct.Type.FEATURE || !f.equals(p.getProvideFeature().get(0)) || this.isInstalled(p)) continue;
                    requireList.add(p);
                }
            }
        }
        return requireList;
    }

    @Override
    protected List<IProduct> getApplicableAddOns(ISite site) {
        return site.getConfigSnippetProducts((IProgressMonitor)new NullProgressMonitor());
    }
}

