/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.config;

import com.ibm.ws.st.core.internal.config.ConfigVars;
import com.ibm.ws.st.core.internal.config.ConfigVarsUtils;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.config.HoverHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.SearchPattern;

public class ReferenceSelectionDialog
extends TitleAreaDialog {
    protected final Set<String> ids;
    protected final Set<String> vars;
    protected final ConfigVars configVars;
    protected final boolean multi;
    protected Set<String> newRefs;
    protected SearchPattern pattern = new SearchPattern(35);
    protected Tree refTree;
    protected TreeItem idTreeRoot;
    protected TreeItem varTreeRoot;

    public ReferenceSelectionDialog(Shell parent, Set<String> ids, Set<String> vars, ConfigVars configVars, boolean multi) {
        super(parent);
        this.ids = ids;
        this.vars = vars;
        this.configVars = configVars;
        this.multi = multi;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.referenceSelectionTitle);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.multi ? Messages.referenceSelectionMultiLabel : Messages.referenceSelectionSingleLabel);
        this.setTitleImage(Activator.getImage("wizServer"));
        this.setMessage(this.multi ? Messages.referenceSelectionMultiMessage : Messages.referenceSelectionSingleMessage);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 11;
        layout.marginWidth = 9;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 7;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        final Text filterText = new Text(composite, 2048);
        data = new GridData(4, 4, true, false);
        filterText.setLayoutData((Object)data);
        filterText.setMessage(Messages.filterMessage);
        int selection = this.multi ? 2 : 4;
        this.refTree = new Tree(composite, 0x800 | selection | 0x200 | 0x100);
        data = new GridData(4, 4, true, true);
        data.heightHint = 240;
        this.refTree.setLayoutData((Object)data);
        Color gray = composite.getShell().getDisplay().getSystemColor(16);
        this.idTreeRoot = new TreeItem(this.refTree, 0);
        this.idTreeRoot.setText(Messages.referenceSelectionAvailableIds);
        this.idTreeRoot.setForeground(gray);
        this.idTreeRoot.setImage(Activator.getImage("factoryRef"));
        this.varTreeRoot = new TreeItem(this.refTree, 0);
        this.varTreeRoot.setText(Messages.referenceSelectionAvailableVars);
        this.varTreeRoot.setForeground(gray);
        this.varTreeRoot.setImage(Activator.getImage("variableRef"));
        this.createItems(this.ids, this.vars, this.configVars, "");
        HoverHelper.addHoverHelp(this.refTree);
        filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String text = filterText.getText();
                if (text == null) {
                    text = "";
                }
                ReferenceSelectionDialog.this.createItems(ReferenceSelectionDialog.this.ids, ReferenceSelectionDialog.this.vars, ReferenceSelectionDialog.this.configVars, text);
                ReferenceSelectionDialog.this.enableOKButton();
            }
        });
        this.refTree.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ReferenceSelectionDialog.this.enableOKButton();
            }
        });
        this.refTree.addListener(14, new Listener(){

            public void handleEvent(Event e) {
                ReferenceSelectionDialog.this.okPressed();
                ReferenceSelectionDialog.this.close();
            }
        });
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.enableOKButton();
        return control;
    }

    public void create() {
        super.create();
        this.refTree.setFocus();
    }

    protected void okPressed() {
        TreeItem[] items = this.refTree.getSelection();
        this.newRefs = new HashSet<String>(items.length);
        for (TreeItem item : items) {
            TreeItem parent = item.getParentItem();
            if (parent == this.idTreeRoot) {
                this.newRefs.add(item.getText());
                continue;
            }
            if (parent != this.varTreeRoot) continue;
            this.newRefs.add(ConfigVarsUtils.getVarRef((String)item.getText()));
        }
        super.okPressed();
    }

    protected void enableOKButton() {
        boolean enable = false;
        if (this.refTree != null && this.refTree.getSelectionCount() > 0) {
            TreeItem[] items;
            enable = true;
            for (TreeItem item : items = this.refTree.getSelection()) {
                TreeItem parent = item.getParentItem();
                if (parent != null) continue;
                enable = false;
                break;
            }
        }
        this.getButton(0).setEnabled(enable);
    }

    protected void createItems(Set<String> ids, Set<String> vars, ConfigVars configVars, String filter) {
        this.pattern.setPattern(filter);
        ArrayList<String> idList = new ArrayList<String>(ids.size());
        idList.addAll(ids);
        Collections.sort(idList);
        this.idTreeRoot.removeAll();
        for (String id : idList) {
            if (!this.pattern.matches(id)) continue;
            TreeItem item = new TreeItem(this.idTreeRoot, 0);
            item.setText(id);
            item.setImage(Activator.getImage("factoryRef"));
        }
        this.idTreeRoot.setExpanded(true);
        ArrayList<String> varList = new ArrayList<String>(vars.size());
        varList.addAll(vars);
        Collections.sort(varList);
        this.varTreeRoot.removeAll();
        for (String var : varList) {
            if (!this.pattern.matches(var)) continue;
            TreeItem item = new TreeItem(this.varTreeRoot, 0);
            item.setText(var);
            item.setImage(Activator.getImage("variableRef"));
            String value = configVars.getValue(var);
            if (value == null || value.isEmpty()) continue;
            item.setData("hoverData", (Object)NLS.bind((String)Messages.variableValue, (Object[])new String[]{var, "\"" + value + "\""}));
        }
        this.varTreeRoot.setExpanded(true);
    }

    public Set<String> getRefs() {
        return this.newRefs;
    }

    public String getRef() {
        if (!this.newRefs.isEmpty()) {
            Iterator<String> it = this.newRefs.iterator();
            return it.next();
        }
        return null;
    }
}

