/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.config;

import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.config.AbstractChainableDialog;
import com.ibm.ws.st.ui.internal.config.FilesetCreateDialog;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LibraryCreateDialog
extends AbstractChainableDialog {
    protected boolean isOK = false;
    protected String id = null;
    protected String filesetRef = null;
    protected List<Element> filesetElements = null;
    protected Text idText = null;

    public LibraryCreateDialog(Shell parent, Document doc, URI docURI, UserDirectory userDir, String[] tags, String[] labels) {
        super(parent, doc, docURI, userDir, tags, labels);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.libraryCreateTitle);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (buttonId == 0) {
            this.isOK = true;
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.libraryCreateLabel);
        this.setTitleImage(Activator.getImage("wizServer"));
        this.setMessage(Messages.libraryCreateMessage);
        final Composite composite = this.createTopLevelComposite(parent);
        this.createBreadcrumb(composite);
        Label label = new Label(composite, 0);
        label.setText(Messages.chainableConfigId);
        GridData data = new GridData(1, 2, false, false);
        label.setLayoutData((Object)data);
        this.idText = new Text(composite, 2048);
        data = new GridData(4, 4, true, false);
        data.horizontalSpan = 2;
        this.idText.setLayoutData((Object)data);
        this.idText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String idStr = LibraryCreateDialog.this.idText.getText();
                if (idStr != null && !idStr.isEmpty()) {
                    LibraryCreateDialog.this.id = idStr;
                    if (LibraryCreateDialog.this.filesetRef != null) {
                        LibraryCreateDialog.this.enableOKButton(true);
                    }
                } else {
                    LibraryCreateDialog.this.enableOKButton(false);
                }
            }
        });
        label = new Label(composite, 0);
        label.setText(Messages.libraryCreateFilesetRef);
        data = new GridData(1, 2, false, false);
        label.setLayoutData((Object)data);
        final Combo filesetCombo = new Combo(composite, 0);
        filesetCombo.setItems(this.getIds("fileset"));
        data = new GridData(4, 4, true, false);
        filesetCombo.setLayoutData((Object)data);
        filesetCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String filesetStr = filesetCombo.getText();
                if (filesetStr != null && !filesetStr.isEmpty()) {
                    LibraryCreateDialog.this.filesetRef = filesetStr;
                    if (LibraryCreateDialog.this.id != null) {
                        LibraryCreateDialog.this.enableOKButton(true);
                    }
                } else {
                    LibraryCreateDialog.this.filesetRef = null;
                    LibraryCreateDialog.this.enableOKButton(false);
                }
            }
        });
        Button filesetCreateButton = new Button(composite, 8);
        filesetCreateButton.setText(Messages.newButtonAcc);
        data = new GridData(2, 2, false, false);
        filesetCreateButton.setLayoutData((Object)data);
        filesetCreateButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                String[] newTags = AbstractChainableDialog.arrayAppend(LibraryCreateDialog.this.tags, "fileset");
                String[] newLabels = AbstractChainableDialog.arrayAppend(LibraryCreateDialog.this.labels, AbstractChainableDialog.getLabel(LibraryCreateDialog.this.doc, newTags, LibraryCreateDialog.this.docURI, "fileset"));
                FilesetCreateDialog filesetDialog = new FilesetCreateDialog(composite.getShell(), LibraryCreateDialog.this.doc, LibraryCreateDialog.this.docURI, LibraryCreateDialog.this.userDir, newTags, newLabels);
                filesetDialog.setParentLocation(LibraryCreateDialog.this.getShell().getBounds());
                filesetDialog.open();
                if (filesetDialog.isOK()) {
                    LibraryCreateDialog.this.filesetElements = filesetDialog.getElements();
                    LibraryCreateDialog.this.filesetRef = LibraryCreateDialog.this.getRefString(filesetDialog.getIds());
                    filesetCombo.setText(LibraryCreateDialog.this.filesetRef);
                }
            }
        });
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.enableOKButton(false);
        return control;
    }

    public void create() {
        super.create();
        this.idText.setFocus();
    }

    protected void enableOKButton(boolean value) {
        this.getButton(0).setEnabled(value);
    }

    public boolean isOK() {
        return this.isOK;
    }

    @Override
    public String[] getIds() {
        if (this.isOK) {
            return new String[]{this.id};
        }
        return new String[0];
    }

    @Override
    public List<Element> getElements() {
        if (this.isOK) {
            ArrayList<Element> list = new ArrayList<Element>(1);
            Element elem = this.doc.createElement("library");
            elem.setAttribute("id", this.id);
            elem.setAttribute("filesetRef", this.filesetRef);
            list.add(elem);
            if (this.filesetElements != null) {
                list.addAll(this.filesetElements);
            }
            return list;
        }
        return Collections.emptyList();
    }
}

