/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.config;

import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.core.internal.config.DOMUtils;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.xwt.dde.customization.ICustomSuggestedValuesObject;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JDBCDriverSuggestedValues
implements ICustomSuggestedValuesObject {
    public List<String> getSuggestedValues(String value, Node itemNode, Element closestAncestor, IResource resource) {
        String[] ids;
        URI docURI;
        Document doc;
        ArrayList<String> list;
        block8: {
            list = new ArrayList<String>();
            doc = closestAncestor.getOwnerDocument();
            docURI = null;
            if (resource != null) {
                docURI = resource.getLocation().toFile().toURI();
            } else {
                String uriStr;
                DOMImplementation domImpl = doc.getImplementation();
                if (domImpl.hasFeature("Core", "3.0") && (uriStr = doc.getDocumentURI()) != null) {
                    try {
                        docURI = new URI(uriStr);
                    }
                    catch (URISyntaxException e) {
                        if (!Trace.ENABLED) break block8;
                        Trace.trace((byte)1, "Failed to creat URI from string: " + uriStr, e);
                    }
                }
            }
        }
        WebSphereServerInfo serverInfo = null;
        UserDirectory userDir = null;
        if (docURI != null) {
            WebSphereServerInfo[] servers;
            for (WebSphereServerInfo webSphereServerInfo : servers = WebSphereUtil.getWebSphereServerInfos()) {
                ConfigurationFile configFile = webSphereServerInfo.getConfigurationFileFromURI(docURI);
                if (configFile == null) continue;
                serverInfo = configFile.getWebSphereServer();
                userDir = configFile.getUserDirectory();
                break;
            }
        }
        for (String string : ids = DOMUtils.getIds((Document)doc, (URI)docURI, serverInfo, userDir, (String)"jdbcDriver")) {
            list.add(string);
        }
        return list;
    }
}

