/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.config;

import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.config.AbstractBrowseDialog;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.w3c.dom.Document;

public class IncludeDialog
extends AbstractBrowseDialog {
    protected String relPath;

    public IncludeDialog(Shell parent, Document document, IEditorInput editorInput) {
        super(parent, document, editorInput);
        this.setBaseURI(this.documentURI);
    }

    public void setBaseURI(URI uri) {
        if (uri != null) {
            String path = uri.getPath();
            int index = path.lastIndexOf(47);
            this.relPath = path.substring(0, index);
            File file = new File(this.relPath);
            if (file.exists()) {
                try {
                    this.relPath = file.getCanonicalPath();
                }
                catch (IOException e) {
                    Trace.logError("Failed to get canonical path for: " + file.toString(), e);
                }
            }
        }
    }

    @Override
    protected String getDialogTitle() {
        return Messages.includeDialogTitle;
    }

    @Override
    protected String getDialogLabel() {
        return Messages.includeDialogLabel;
    }

    @Override
    protected String getDialogMessage() {
        return Messages.includeDialogMessage;
    }

    @Override
    protected AbstractBrowseDialog.VariableEntry[] initVariables() {
        ArrayList<AbstractBrowseDialog.VariableEntry> list = new ArrayList<AbstractBrowseDialog.VariableEntry>();
        if (this.relPath != null) {
            list.add(new AbstractBrowseDialog.VariableEntry(Messages.relativePath, this.relPath, null, Activator.getImage("relativePath")));
        }
        if (this.userDir != null) {
            list.add(new AbstractBrowseDialog.VariableEntry(NLS.bind((String)Messages.sharedConfigPath, (Object)"shared.config.dir"), this.userDir.getSharedConfigPath().toOSString(), SHAREDCONFIGVAR, Activator.getImage("configFolder")));
        }
        this.addConfigVars(list, "shared.config.dir", false);
        return list.toArray(new AbstractBrowseDialog.VariableEntry[list.size()]);
    }

    @Override
    protected String getEntryLabel() {
        return Messages.includeDialogEntryLabel;
    }
}

