/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.config;

import com.ibm.ws.st.core.internal.config.ConfigUtils;
import com.ibm.ws.st.core.internal.config.ConfigVars;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.config.BaseCustomObject;
import com.ibm.ws.st.ui.internal.config.ConfigVarComputer;
import com.ibm.ws.st.ui.internal.config.FileSelectorDialog;
import com.ibm.ws.st.ui.internal.config.TextModifiers;
import java.io.File;
import java.util.EventListener;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public abstract class FileSelectorCustomObject
extends BaseCustomObject {
    protected static final String JAR_FILTER = "*.jar";

    public void createCustomControl(final Element input, final String itemName, Composite composite, IEditorPart editorPart, EventListener listener) {
        final Shell shell = composite.getShell();
        final ConfigVarComputer configVarComputer = this.getConfigVarComputer(input, itemName, editorPart);
        String attrType = null;
        String defaultValue = null;
        CMAttributeDeclaration attrDecl = this.getAttrDecl(input, itemName);
        if (attrDecl != null) {
            attrType = ConfigUtils.getTypeName((CMNode)attrDecl);
            defaultValue = attrDecl.getDefaultValue();
        }
        Attr attr = input.getAttributeNode(itemName);
        String value = defaultValue;
        if (attr != null) {
            value = attr.getNodeValue();
        }
        TabbedPropertySheetWidgetFactory widgetFactory = new TabbedPropertySheetWidgetFactory();
        this.setLabelVerticalAlign(composite, 2);
        final Text textControl = widgetFactory.createText(composite, "");
        if (value != null && !value.isEmpty()) {
            textControl.setText(value);
            textControl.setToolTipText(value);
        }
        TextModifiers.addVariableContentProposalProvider(textControl, configVarComputer, attrType);
        TextModifiers.addVariableHyperlink(textControl, configVarComputer);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        data.horizontalIndent = 2;
        textControl.setLayoutData((Object)data);
        textControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String text = textControl.getText();
                Attr attr = input.getAttributeNode(itemName);
                if (text == null || text.isEmpty()) {
                    if (attr != null) {
                        input.removeAttributeNode(attr);
                    }
                } else {
                    input.setAttribute(itemName, text);
                }
                textControl.setToolTipText(text);
            }
        });
        Button browseButton = widgetFactory.createButton(composite, Messages.editorBrowse, 8);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = false;
        browseButton.setLayoutData((Object)data);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String path = FileSelectorCustomObject.this.getPath(input, configVarComputer.getConfigVars());
                if (path == null || path.isEmpty()) {
                    MessageDialog.openError((Shell)shell, (String)Messages.title, (String)Messages.filesetNoDirSpecified);
                    return;
                }
                File file = new File(path);
                if (!file.exists()) {
                    MessageDialog.openError((Shell)shell, (String)Messages.title, (String)NLS.bind((String)Messages.filesetDirNotFound, (Object)path));
                    return;
                }
                FileSelectorDialog dialog = new FileSelectorDialog(shell, path, FileSelectorCustomObject.this.getTitle(), FileSelectorCustomObject.this.getLabel(), FileSelectorCustomObject.this.getMessage());
                dialog.setInitialFilter(FileSelectorCustomObject.this.getDefaultFilter());
                if (dialog.open() == 0) {
                    textControl.setText(dialog.getFileList());
                }
            }
        });
        textControl.setEnabled(!this.getReadOnly());
        browseButton.setEnabled(!this.getReadOnly());
    }

    protected String resolvePath(String path, String base) {
        File file;
        String result = path;
        if (path != null && !(file = new File(path)).isAbsolute() && base != null) {
            Path ipath = new Path(base);
            ipath.append(path);
            result = ipath.toOSString();
        }
        return result;
    }

    protected abstract String getPath(Element var1, ConfigVars var2);

    protected abstract String getTitle();

    protected abstract String getLabel();

    protected abstract String getMessage();

    protected abstract String getDefaultFilter();
}

