/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.actions;

import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.actions.AddOnRuntimeAction;
import com.ibm.ws.st.ui.internal.actions.DeleteAction;
import com.ibm.ws.st.ui.internal.actions.EditRuntimeAction;
import com.ibm.ws.st.ui.internal.actions.NewConfigDropinAction;
import com.ibm.ws.st.ui.internal.actions.NewExtendedConfigAction;
import com.ibm.ws.st.ui.internal.actions.NewQuickServerAction;
import com.ibm.ws.st.ui.internal.actions.NewRuntimeAction;
import com.ibm.ws.st.ui.internal.actions.NewServerAction;
import com.ibm.ws.st.ui.internal.actions.NewWebSphereServerAction;
import com.ibm.ws.st.ui.internal.actions.OpenConfigFileAction;
import com.ibm.ws.st.ui.internal.actions.PropertiesAction;
import com.ibm.ws.st.ui.internal.actions.RefreshAction;
import com.ibm.ws.st.ui.internal.actions.RefreshConfigFileAction;
import com.ibm.ws.st.ui.internal.actions.ShowInExplorerAction;
import com.ibm.ws.st.ui.internal.actions.ShowInFilesystemAction;
import com.ibm.ws.st.ui.internal.actions.ShowInServersAction;
import com.ibm.ws.st.ui.internal.download.SiteHelper;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

public class RuntimeExplorerViewActionProvider
extends CommonActionProvider {
    protected OpenConfigFileAction openAction;
    protected ShowInExplorerAction showInExplorerAction;
    protected ShowInFilesystemAction showInFilesystemAction;
    protected RefreshConfigFileAction refreshConfigAction;
    protected RefreshAction refreshAction;
    protected DeleteAction deleteAction;
    protected NewRuntimeAction newRuntimeAction;
    protected EditRuntimeAction editRuntimeAction;
    protected NewServerAction newServerAction;
    protected NewWebSphereServerAction newWebSphereServerAction;
    protected NewQuickServerAction newQuickServerAction;
    protected ShowInServersAction showInServersAction;
    protected PropertiesAction propertiesAction;
    protected NewExtendedConfigAction[] createConfigActions = new NewExtendedConfigAction[2];
    protected NewConfigDropinAction[] newConfigDropinActions = new NewConfigDropinAction[2];
    protected NewExtendedConfigAction[] newJVMOptionsActions = new NewExtendedConfigAction[4];
    protected AddOnRuntimeAction addOnRuntimeAction;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        StructuredViewer selProvider = aSite.getStructuredViewer();
        Shell shell = aSite.getViewSite().getShell();
        StructuredViewer viewer = aSite.getStructuredViewer();
        this.openAction = new OpenConfigFileAction((ISelectionProvider)selProvider);
        this.showInExplorerAction = new ShowInExplorerAction((ISelectionProvider)selProvider);
        this.showInFilesystemAction = new ShowInFilesystemAction((ISelectionProvider)selProvider);
        this.refreshConfigAction = new RefreshConfigFileAction((ISelectionProvider)selProvider);
        this.refreshAction = new RefreshAction((ISelectionProvider)selProvider, viewer);
        this.deleteAction = new DeleteAction(shell, (ISelectionProvider)selProvider);
        this.newRuntimeAction = new NewRuntimeAction(shell);
        this.editRuntimeAction = new EditRuntimeAction(shell, (ISelectionProvider)selProvider, viewer);
        this.newServerAction = new NewServerAction((ISelectionProvider)selProvider, shell);
        this.newWebSphereServerAction = new NewWebSphereServerAction((ISelectionProvider)selProvider, shell);
        this.newQuickServerAction = new NewQuickServerAction((ISelectionProvider)selProvider);
        this.showInServersAction = new ShowInServersAction((ISelectionProvider)selProvider);
        this.propertiesAction = new PropertiesAction((ISelectionProvider)selProvider, shell);
        this.createConfigActions[0] = new NewExtendedConfigAction("bootstrap.properties", (ISelectionProvider)selProvider, viewer);
        this.createConfigActions[1] = new NewExtendedConfigAction("server.env", (ISelectionProvider)selProvider, viewer);
        this.newConfigDropinActions[0] = new NewConfigDropinAction(NewConfigDropinAction.DropinType.DEFAULTS, (ISelectionProvider)selProvider, viewer);
        this.newConfigDropinActions[1] = new NewConfigDropinAction(NewConfigDropinAction.DropinType.OVERRIDES, (ISelectionProvider)selProvider, viewer);
        this.newJVMOptionsActions[0] = new NewExtendedConfigAction("jvm.options", (ISelectionProvider)selProvider, viewer, "${server.config.dir}");
        this.newJVMOptionsActions[1] = new NewExtendedConfigAction("jvm.options", (ISelectionProvider)selProvider, viewer, "${wlp.install.dir}/usr/shared");
        this.newJVMOptionsActions[2] = new NewExtendedConfigAction("jvm.options", (ISelectionProvider)selProvider, viewer, "${server.config.dir}/configDropins/defaults");
        this.newJVMOptionsActions[3] = new NewExtendedConfigAction("jvm.options", (ISelectionProvider)selProvider, viewer, "${server.config.dir}/configDropins/overrides");
        this.addOnRuntimeAction = new AddOnRuntimeAction(shell, (ISelectionProvider)selProvider);
    }

    public void fillContextMenu(IMenuManager menu) {
        MenuManager newMenu = new MenuManager(Messages.actionNew, "new");
        newMenu.add((IAction)this.newRuntimeAction);
        if (this.newServerAction.isEnabled()) {
            newMenu.add((IAction)this.newServerAction);
        }
        if (this.newWebSphereServerAction.isEnabled()) {
            newMenu.add((IAction)this.newWebSphereServerAction);
        }
        if (this.newQuickServerAction.isEnabled()) {
            newMenu.add((IAction)this.newQuickServerAction);
        }
        MenuManager configMenu = new MenuManager(Messages.menuNewExtendedConfig, Activator.getImageDescriptor("bootstrap.properties"), "extendedConfig");
        for (int i = 0; i < this.createConfigActions.length; ++i) {
            configMenu.add((IAction)this.createConfigActions[i]);
        }
        MenuManager subConfigMenu = new MenuManager("jvm.options", Activator.getImageDescriptor("bootstrap.properties"), "jvm.options");
        for (int i = 0; i < this.newJVMOptionsActions.length; ++i) {
            subConfigMenu.add((IAction)this.newJVMOptionsActions[i]);
        }
        configMenu.add((IContributionItem)subConfigMenu);
        newMenu.add((IContributionItem)configMenu);
        MenuManager configDropinsMenu = new MenuManager(Messages.menuNewConfigDropin, Activator.getImageDescriptor("configFile"), "configDropins");
        for (int i = 0; i < this.newConfigDropinActions.length; ++i) {
            if (!this.newConfigDropinActions[i].isApplicable()) continue;
            configDropinsMenu.add((IAction)this.newConfigDropinActions[i]);
        }
        newMenu.add((IContributionItem)configDropinsMenu);
        menu.appendToGroup("group.new", (IContributionItem)newMenu);
        if (this.openAction.isEnabled()) {
            menu.appendToGroup("group.open", (IAction)this.openAction);
        }
        if (this.editRuntimeAction.isEnabled()) {
            menu.appendToGroup("group.edit", (IAction)this.editRuntimeAction);
        }
        if (this.showInServersAction.isEnabled() || this.showInFilesystemAction.isEnabled()) {
            String text = Messages.actionShowIn;
            IWorkbench workbench = PlatformUI.getWorkbench();
            IBindingService bindingService = (IBindingService)workbench.getAdapter(IBindingService.class);
            TriggerSequence[] activeBindings = bindingService.getActiveBindingsFor("org.eclipse.ui.navigate.showInQuickMenu");
            if (activeBindings.length > 0) {
                text = text + "\t" + activeBindings[0].format();
            }
            MenuManager showInMenu = new MenuManager(text, "org.eclipse.ui.navigate.showInQuickMenu");
            if (this.showInServersAction.isEnabled()) {
                showInMenu.add((IAction)this.showInServersAction);
            }
            showInMenu.add((IAction)this.showInExplorerAction);
            showInMenu.add((IAction)this.showInFilesystemAction);
            menu.appendToGroup("group.show", (IContributionItem)showInMenu);
        }
        if (this.deleteAction.isEnabled()) {
            menu.appendToGroup("group.edit", (IAction)this.deleteAction);
        }
        if (this.refreshConfigAction.isEnabled()) {
            menu.appendToGroup("group.edit", (IAction)this.refreshConfigAction);
        }
        if (this.refreshAction.isEnabled()) {
            menu.appendToGroup("group.edit", (IAction)this.refreshAction);
        }
        if (this.propertiesAction.isEnabled()) {
            menu.appendToGroup("group.properties", (IAction)this.propertiesAction);
        }
        if (SiteHelper.downloadAndInstallSupported() && this.addOnRuntimeAction.isEnabled()) {
            menu.appendToGroup("additions", (IContributionItem)new Separator());
            menu.appendToGroup("additions", (IAction)this.addOnRuntimeAction);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openAction);
        if (this.refreshConfigAction.isEnabled()) {
            actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.refreshConfigAction);
        }
        if (this.refreshAction.isEnabled()) {
            actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.refreshAction);
        }
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
        actionBars.updateActionBars();
    }
}

