/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.actions;

import com.ibm.ws.st.common.core.ext.internal.UnsupportedServiceException;
import com.ibm.ws.st.core.internal.FileUtil;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.core.internal.jmx.JMXConnection;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.ConnectException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.server.core.IServer;

public abstract class OpenLogAction
extends SelectionProviderAction {
    protected WebSphereServerInfo wsServerInfo;
    protected WebSphereServer wsServer;
    IPath logFilePath = null;
    protected final Shell shell;

    public OpenLogAction(String name, ISelectionProvider sp, Shell shell) {
        super(sp, name);
        this.shell = shell;
        this.selectionChanged(this.getStructuredSelection());
    }

    public abstract IPath getServerInfoLogFile();

    public abstract IPath getServerLogFile() throws ConnectException, UnsupportedServiceException, IOException;

    public void selectionChanged(IStructuredSelection sel) {
        if (sel.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        boolean enabled = false;
        for (Object obj : sel) {
            if (obj instanceof WebSphereServerInfo) {
                this.wsServerInfo = (WebSphereServerInfo)obj;
                this.wsServer = WebSphereUtil.getWebSphereServer((WebSphereServerInfo)this.wsServerInfo);
                continue;
            }
            if (obj instanceof IServer) {
                IServer server = (IServer)obj;
                this.wsServer = (WebSphereServer)server.loadAdapter(WebSphereServer.class, null);
                if (this.wsServer == null) {
                    this.setEnabled(false);
                    return;
                }
                this.wsServerInfo = this.wsServer.getServerInfo();
                continue;
            }
            this.setEnabled(false);
            return;
        }
        if (this.wsServer != null && !this.wsServer.isLocalSetup()) {
            if (this.wsServer.getServer().getServerState() != 2) {
                this.setEnabled(false);
                return;
            }
            enabled = true;
        } else if (this.getServerInfoLogFile() != null && this.getServerInfoLogFile().toFile().exists()) {
            enabled = true;
        }
        this.setEnabled(enabled);
    }

    public void run() {
        Job job = new Job(Messages.downloadLogJob){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                if (OpenLogAction.this.wsServer != null && !OpenLogAction.this.wsServer.isLocalSetup()) {
                    JMXConnection jmx = null;
                    String serverName = OpenLogAction.this.wsServer.getServerName();
                    IPath logfile = null;
                    try {
                        OpenLogAction.this.logFilePath = OpenLogAction.this.getServerLogFile();
                        if (OpenLogAction.this.logFilePath == null) {
                            OpenLogAction.this.showError(Messages.downloadLogDialogTitle, Messages.downloadLogFailure);
                            IStatus iStatus = Status.OK_STATUS;
                            return iStatus;
                        }
                        logfile = OpenLogAction.this.wsServer.getWebSphereRuntime().getRemoteUsrMetadataPath().append("servers").append(serverName).append("logs").append(OpenLogAction.this.logFilePath.lastSegment());
                        jmx = OpenLogAction.this.wsServer.createJMXConnection();
                        IPath dir = logfile.removeLastSegments(1);
                        if (!dir.toFile().exists()) {
                            FileUtil.makeDir((IPath)dir);
                        }
                        if (jmx.isConnected()) {
                            jmx.downloadFile(OpenLogAction.this.logFilePath.toString(), logfile.toOSString());
                        }
                    }
                    catch (Exception e) {
                        Trace.logError("Error connecting to remote server : " + OpenLogAction.this.wsServer.getServerName(), e);
                        OpenLogAction.this.showError(Messages.downloadLogDialogTitle, NLS.bind((String)Messages.downloadLogError, (Object)e.getMessage()));
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    finally {
                        if (jmx != null) {
                            jmx.disconnect();
                        }
                    }
                    if (new File(logfile.toOSString()).exists() && new File(logfile.toOSString()).length() != 0L) {
                        OpenLogAction.this.openFile(logfile);
                    } else {
                        OpenLogAction.this.showError(Messages.downloadLogDialogTitle, NLS.bind((String)Messages.downloadLogDialogMessage, (Object)OpenLogAction.this.logFilePath.toOSString()));
                    }
                } else {
                    OpenLogAction.this.openFile(OpenLogAction.this.getServerInfoLogFile());
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void showError(final String title, final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)OpenLogAction.this.shell, (String)title, (String)message);
            }
        });
    }

    public void openFile(final IPath filePath) {
        final IFileStore fileStore = EFS.getLocalFileSystem().getStore(filePath);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = null;
                if (!fileStore.fetchInfo().isDirectory() && fileStore.fetchInfo().exists()) {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    page = window.getActivePage();
                }
                try {
                    if (page != null) {
                        IDE.openEditorOnFileStore(page, (IFileStore)fileStore);
                    }
                }
                catch (PartInitException e) {
                    Trace.logError("Error Opening messages.log located at : " + filePath.toOSString(), e);
                }
            }
        });
    }

    public File[] getFileList() {
        if (this.wsServer != null && this.wsServer.isLocalSetup()) {
            IPath file = this.getServerInfoLogFile();
            final String fileExtension = file.getFileExtension();
            final String fileName = file.removeFileExtension().lastSegment();
            FileFilter fileFilter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    String currentFileName = pathname.getName();
                    if (currentFileName.length() == fileName.length() + fileExtension.length() + 1) {
                        return false;
                    }
                    return currentFileName.startsWith(fileName) && currentFileName.endsWith(fileExtension);
                }
            };
            return file.removeLastSegments(1).toFile().listFiles(fileFilter);
        }
        return null;
    }
}

