/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.actions;

import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.facets.FacetUtil;
import org.eclipse.wst.server.core.util.SocketUtil;
import org.eclipse.wst.server.ui.internal.DeleteRuntimeDialog;

public class DeleteAction
extends SelectionProviderAction {
    private final Shell shell;
    private IRuntime runtime;
    private WebSphereServerInfo server;

    public DeleteAction(Shell shell, ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.actionDelete);
        this.shell = shell;
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        this.runtime = null;
        this.server = null;
        if (sel.size() != 1) {
            this.setEnabled(false);
            return;
        }
        for (Object obj : sel) {
            if (obj instanceof IRuntime) {
                this.runtime = (IRuntime)obj;
                continue;
            }
            if (obj instanceof WebSphereServerInfo) {
                this.server = (WebSphereServerInfo)obj;
                this.runtime = this.server.getWebSphereRuntime().getRuntime();
                continue;
            }
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    public void run() {
        if (this.server != null) {
            this.deleteWebSphereServer(this.runtime, this.server);
        } else if (this.runtime != null) {
            this.deleteRuntime(this.runtime);
        }
    }

    private void deleteRuntime(IRuntime runtime) {
        if (runtime == null) {
            return;
        }
        List<IServer> serverList = this.getServerList();
        boolean inUse = false;
        try {
            inUse = FacetUtil.isRuntimeTargeted((IRuntime)runtime);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!serverList.isEmpty() || inUse) {
            DeleteRuntimeDialog dialog = new DeleteRuntimeDialog(this.shell, !serverList.isEmpty(), inUse);
            if (dialog.open() != 0) {
                return;
            }
            if (dialog.isDeleteServers()) {
                List<IServer> runningList = this.getRunningServerList(serverList);
                try {
                    if (!runningList.isEmpty()) {
                        this.stopServers(runningList);
                    }
                    this.deleteServers(serverList);
                }
                catch (CoreException ce) {
                    MessageDialog.openError((Shell)this.shell, (String)Messages.title, (String)ce.getLocalizedMessage());
                    return;
                }
            }
            if (dialog.isRemoveTargets()) {
                try {
                    FacetUtil.removeTargets((IRuntime)runtime, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Throwable t) {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)1, "Error deleting facet targets", t);
                    }
                }
            }
        } else if (!MessageDialog.openConfirm((Shell)this.shell, (String)Messages.title, (String)NLS.bind((String)Messages.confirmDelete, (Object)runtime.getName()))) {
            return;
        }
        try {
            runtime.delete();
        }
        catch (CoreException ce) {
            MessageDialog.openError((Shell)this.shell, (String)Messages.title, (String)ce.getLocalizedMessage());
        }
        catch (Exception e) {
            Trace.logError("Error deleting runtime: " + runtime.getId(), e);
        }
    }

    private void deleteWebSphereServer(IRuntime runtime, WebSphereServerInfo serverInfo) {
        WebSphereRuntime wr;
        if (runtime == null) {
            return;
        }
        String serverName = serverInfo.getServerName();
        List<IServer> serverList = this.getServerList(serverInfo);
        if (!serverList.isEmpty()) {
            if (!MessageDialog.openConfirm((Shell)this.shell, (String)Messages.title, (String)NLS.bind((String)Messages.confirmDeleteServerInUse, (Object)serverName))) {
                return;
            }
            List<IServer> runningList = this.getRunningServerList(serverList);
            try {
                if (!runningList.isEmpty()) {
                    this.stopServers(runningList);
                }
                this.deleteServers(serverList);
            }
            catch (CoreException ce) {
                MessageDialog.openError((Shell)this.shell, (String)Messages.title, (String)ce.getLocalizedMessage());
                return;
            }
        } else if (!MessageDialog.openConfirm((Shell)this.shell, (String)Messages.title, (String)NLS.bind((String)Messages.confirmDelete, (Object)serverName))) {
            return;
        }
        if ((wr = (WebSphereRuntime)runtime.loadAdapter(WebSphereRuntime.class, null)) == null) {
            MessageDialog.openError((Shell)this.shell, (String)Messages.title, (String)Messages.errorWebsphereRuntimeAdapter);
            return;
        }
        for (int i = 0; i < 11; ++i) {
            try {
                wr.deleteServer(serverInfo, null);
                return;
            }
            catch (Exception e) {
                if (i == 11) {
                    MessageDialog.openError((Shell)this.shell, (String)Messages.title, (String)e.getLocalizedMessage());
                    continue;
                }
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
    }

    private void deleteServers(final List<IServer> serverList) throws CoreException {
        final DeleteActivity activity = new DeleteActivity(Messages.taskDeletingServers);
        Job job = new Job(Messages.taskDeletingServers){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    for (IServer server : serverList) {
                        server.delete();
                    }
                    activity.setIsDone(true);
                }
                catch (Exception e) {
                    Trace.logError("Error while deleting servers", e);
                    return new Status(4, "com.ibm.ws.st.ui", 0, e.getMessage(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        int size = serverList.size();
        ISchedulingRule[] rules = new ISchedulingRule[size + 1];
        for (int i = 0; i < size; ++i) {
            rules[i] = (ISchedulingRule)serverList.get(i);
        }
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        rules[size] = ruleFactory.createRule((IResource)ResourcesPlugin.getWorkspace().getRoot());
        job.setRule(MultiRule.combine((ISchedulingRule[])rules));
        job.setPriority(40);
        job.schedule();
        try {
            this.waitForActivity(activity, 500, 10.0f);
        }
        catch (TimeoutException e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.ui", e.getMessage()));
        }
    }

    private void stopServers(List<IServer> serverList) throws CoreException {
        final DeleteActivity activity = new DeleteActivity("");
        for (IServer server : serverList) {
            activity.setName(NLS.bind((String)Messages.taskStoppingServer, (Object)server.getName()));
            activity.setIsDone(false);
            server.stop(false, new IServer.IOperationListener(){

                public void done(IStatus status) {
                    if (status.getCode() == 4) {
                        Trace.logError("Error encountered while stopping the server..", status.getException());
                    }
                    activity.setIsDone(true);
                }
            });
            try {
                this.waitForActivity(activity, 500, 10.0f);
            }
            catch (TimeoutException e) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.ui", e.getMessage()));
            }
        }
    }

    private List<IServer> getServerList() {
        IServer[] servers = ServerCore.getServers();
        if (servers == null) {
            return Collections.emptyList();
        }
        ArrayList<IServer> list = new ArrayList<IServer>();
        for (IServer server : servers) {
            if (!this.runtime.equals(server.getRuntime())) continue;
            list.add(server);
        }
        return list;
    }

    private List<IServer> getServerList(WebSphereServerInfo serverInfo) {
        String serverName = serverInfo.getServerName();
        WebSphereServer[] servers = WebSphereUtil.getWebSphereServers();
        ArrayList<IServer> list = new ArrayList<IServer>(1);
        for (WebSphereServer ws : servers) {
            if (!this.runtime.equals(ws.getServer().getRuntime()) || !serverName.equals(ws.getServerName())) continue;
            IServer server = ws.getServer();
            if (server.isWorkingCopy()) {
                server = ((IServerWorkingCopy)server).getOriginal();
            }
            list.add(server);
            break;
        }
        return list;
    }

    private List<IServer> getRunningServerList(List<IServer> serverList) {
        if (serverList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IServer> runningList = new ArrayList<IServer>(serverList.size());
        for (IServer server : serverList) {
            if (server.getServerState() != 1 && server.getServerState() != 2 || !SocketUtil.isLocalhost((String)server.getHost())) continue;
            runningList.add(server);
        }
        return runningList;
    }

    private void waitForActivity(DeleteActivity activity, int pollingDelay, float timeout) throws TimeoutException {
        int iter = (int)(timeout * 1000.0f / (float)pollingDelay);
        for (int i = 0; i < iter; ++i) {
            try {
                Thread.sleep(pollingDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!activity.isDone()) continue;
            return;
        }
        throw new TimeoutException(NLS.bind((String)Messages.taskTimeoutError, (Object)activity.getName()));
    }

    private static class DeleteActivity {
        private String name;
        private boolean isDone = false;

        protected DeleteActivity(String name) {
            this.name = name;
        }

        protected void setName(String name) {
            this.name = name;
        }

        protected void setIsDone(boolean isDone) {
            this.isDone = isDone;
        }

        protected String getName() {
            return this.name;
        }

        protected boolean isDone() {
            return this.isDone;
        }
    }
}

