/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal;

import com.ibm.ws.st.common.core.ext.internal.servertype.AbstractServerBehaviourExtension;
import com.ibm.ws.st.core.internal.SetLooseConfigCommand;
import com.ibm.ws.st.core.internal.SetPublishWithErrorCommand;
import com.ibm.ws.st.core.internal.SetStopServerOnShutdownCommand;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerBehaviour;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.eclipse.wst.server.ui.editor.IServerEditorPartInput;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;

public class ServerGeneralEditorSection
extends ServerEditorSection {
    protected WebSphereServer wsServer;
    protected Button looseConfigButton;
    protected Button stopOnShutdown;
    protected Label serverName;
    protected boolean updating;
    protected PropertyChangeListener listener;
    protected Button publishWithError;
    public final String PUBLISH_WITH_ERROR = "publishWithError";
    private boolean initialLooseConfigButtonState;

    protected void addChangeListener() {
        this.listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                Boolean b;
                if (ServerGeneralEditorSection.this.updating) {
                    return;
                }
                ServerGeneralEditorSection.this.updating = true;
                if ("looseConfig".equals(event.getPropertyName()) && (b = (Boolean)event.getNewValue()) != null) {
                    ServerGeneralEditorSection.this.looseConfigButton.setSelection(b.booleanValue());
                }
                ServerGeneralEditorSection.this.updating = false;
            }
        };
        this.server.addPropertyChangeListener(this.listener);
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        FormToolkit toolkit = this.getFormToolkit(parent.getDisplay());
        Section section = toolkit.createSection(parent, 384);
        section.setText(Messages.editorGeneralTitle);
        section.setDescription(Messages.editorGeneralDescription);
        section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(784));
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        whs.setHelp((Control)composite, "com.ibm.ws.st.ui.twnr0002");
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
        Label label = new Label(composite, 0);
        label.setText(Messages.server);
        this.serverName = new Label(composite, 0);
        this.serverName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label(composite, 0);
        label.setText("");
        Hyperlink openConfigLink = toolkit.createHyperlink(composite, Messages.editorGeneralOpenConfiguration, 0);
        GridData data = new GridData(4, 1, false, false);
        openConfigLink.setLayoutData((Object)data);
        openConfigLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent arg0) {
                ConfigurationFile configFile = ServerGeneralEditorSection.this.wsServer.getConfiguration();
                if (configFile != null) {
                    Activator.openConfigurationEditor(configFile.getIFile(), configFile.getURI());
                }
            }
        });
        this.looseConfigButton = toolkit.createButton(composite, Messages.editorGeneralLooseConfig, 96);
        data = new GridData(4, 1, false, false);
        data.horizontalSpan = 2;
        data.verticalIndent = 5;
        this.looseConfigButton.setLayoutData((Object)data);
        this.looseConfigButton.setToolTipText(Messages.editorGeneralLooseConfigMessage);
        this.looseConfigButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ServerGeneralEditorSection.this.updating) {
                    return;
                }
                ServerGeneralEditorSection.this.updating = true;
                boolean sel = ServerGeneralEditorSection.this.looseConfigButton.getSelection();
                ServerGeneralEditorSection.this.execute((IUndoableOperation)new SetLooseConfigCommand(ServerGeneralEditorSection.this.wsServer, sel));
                ServerGeneralEditorSection.this.updating = false;
            }
        });
        this.stopOnShutdown = toolkit.createButton(composite, Messages.editorGeneralStopServerOnShutdown, 96);
        data = new GridData(4, 1, false, false);
        data.horizontalSpan = 2;
        data.verticalIndent = 5;
        this.stopOnShutdown.setLayoutData((Object)data);
        this.stopOnShutdown.setToolTipText(Messages.editorGeneralStopServerOnShutdownMessage);
        this.stopOnShutdown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ServerGeneralEditorSection.this.updating) {
                    return;
                }
                ServerGeneralEditorSection.this.updating = true;
                boolean sel = ServerGeneralEditorSection.this.stopOnShutdown.getSelection();
                ServerGeneralEditorSection.this.execute((IUndoableOperation)new SetStopServerOnShutdownCommand(ServerGeneralEditorSection.this.wsServer, sel));
                ServerGeneralEditorSection.this.updating = false;
            }
        });
        this.publishWithError = toolkit.createButton(composite, Messages.publishWithErrors, 96);
        data = new GridData(4, 1, false, false);
        data.horizontalSpan = 2;
        data.verticalIndent = 5;
        this.publishWithError.setLayoutData((Object)data);
        this.publishWithError.setToolTipText(Messages.publishWithErrors);
        this.publishWithError.setSelection(this.wsServer.isPublishWithError());
        this.publishWithError.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ServerGeneralEditorSection.this.updating) {
                    return;
                }
                ServerGeneralEditorSection.this.updating = true;
                boolean sel = ServerGeneralEditorSection.this.publishWithError.getSelection();
                ServerGeneralEditorSection.this.execute((IUndoableOperation)new SetPublishWithErrorCommand(ServerGeneralEditorSection.this.wsServer, sel));
                ServerGeneralEditorSection.this.updating = false;
            }
        });
        this.initialize();
    }

    public void dispose() {
        if (this.server != null) {
            this.server.removePropertyChangeListener(this.listener);
        }
        super.dispose();
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        if (this.server != null) {
            this.wsServer = (WebSphereServer)this.server.loadAdapter(WebSphereServer.class, null);
            this.addChangeListener();
            if (input instanceof IServerEditorPartInput) {
                this.readOnly = ((IServerEditorPartInput)input).isServerReadOnly();
            }
        }
        this.initialize();
    }

    protected void initialize() {
        Boolean state;
        if (this.serverName == null || this.wsServer == null) {
            return;
        }
        this.serverName.setText(this.wsServer.getServerName() + "");
        this.updating = true;
        this.looseConfigButton.setSelection(this.wsServer.isLooseConfigEnabled());
        boolean isEnabled = !this.readOnly && this.wsServer.isLocalSetup();
        WebSphereServerBehaviour webSphereServerBehaviour = this.wsServer.getWebSphereServerBehaviour();
        AbstractServerBehaviourExtension ext = (AbstractServerBehaviourExtension)webSphereServerBehaviour.getAdapter(AbstractServerBehaviourExtension.class);
        if (ext != null && (state = ext.isLooseConfigEnabled((ServerBehaviourDelegate)webSphereServerBehaviour)) != null) {
            isEnabled = state;
        }
        this.looseConfigButton.setEnabled(isEnabled);
        if (isEnabled) {
            this.updateRunWithWorkspaceResourcesState(true);
        }
        this.initialLooseConfigButtonState = this.looseConfigButton.getSelection();
        this.stopOnShutdown.setSelection(this.wsServer.isStopOnShutdown());
        this.stopOnShutdown.setEnabled(!this.readOnly);
        this.updating = false;
    }

    protected void updateRunWithWorkspaceResourcesState(boolean isInitialize) {
        if (this.looseConfigButton == null) {
            return;
        }
        this.looseConfigButton.setEnabled(true);
        if (!isInitialize && this.wsServer != null) {
            this.wsServer.setLooseConfigEnabled(true);
            this.looseConfigButton.setSelection(true);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        boolean selection;
        IStatus status = null;
        WebSphereServerBehaviour webSphereServerBehaviour = this.wsServer.getWebSphereServerBehaviour();
        AbstractServerBehaviourExtension ext = (AbstractServerBehaviourExtension)webSphereServerBehaviour.getAdapter(AbstractServerBehaviourExtension.class);
        if (ext != null && this.initialLooseConfigButtonState != (selection = this.looseConfigButton.getSelection()) && (status = ext.preSaveLooseConfigChange((ServerBehaviourDelegate)webSphereServerBehaviour, selection)) != Status.OK_STATUS) {
            this.looseConfigButton.setSelection(!selection);
            this.execute((IUndoableOperation)new SetLooseConfigCommand(this.wsServer, !selection));
            return;
        }
        this.initialLooseConfigButtonState = this.looseConfigButton.getSelection();
        super.doSave(monitor);
    }
}

