/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.liberty.gradle.internal;

import com.ibm.ws.st.liberty.gradle.internal.Messages;
import com.ibm.ws.st.liberty.gradle.internal.Trace;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.ibm.ws.st.liberty.gradle";
    private static final String BUILDSHIP_PLUGIN_ID = "org.eclipse.buildship.core";
    private static Activator plugin;
    protected Map<String, ImageDescriptor> imageDescriptors = new HashMap<String, ImageDescriptor>();
    private static URL ICON_BASE_URL;
    private static final String URL_OBJ16 = "obj16/";
    public static final String IMG_GRADLE_RUNTIME = "gradleRuntime";
    public static final String IMG_GRADLE_FOLDER = "gradleFolder";

    public void start(BundleContext context) throws Exception {
        if (Platform.getBundle((String)BUILDSHIP_PLUGIN_ID) == null) {
            Status status = new Status(4, PLUGIN_ID, Messages.noEclipseBuildshipError);
            throw new CoreException((IStatus)status);
        }
        super.start(context);
        plugin = this;
        Trace.ENABLED = this.isDebugging();
        Hashtable<String, String> props = new Hashtable<String, String>(4);
        props.put("listener.symbolic.name", PLUGIN_ID);
        context.registerService(DebugOptionsListener.class.getName(), (Object)Trace.TS, props);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static Activator getInstance() {
        return plugin;
    }

    private void registerImage(ImageRegistry registry, String key, String partialURL) {
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)new URL(ICON_BASE_URL, partialURL));
            registry.put(key, id);
            this.imageDescriptors.put(key, id);
        }
        catch (Exception e) {
            Trace.trace((byte)1, "Error registering image", e);
        }
    }

    protected ImageRegistry createImageRegistry() {
        ImageRegistry registry = new ImageRegistry();
        if (ICON_BASE_URL == null) {
            ICON_BASE_URL = plugin.getBundle().getEntry("icons/");
        }
        this.registerImage(registry, IMG_GRADLE_FOLDER, ICON_BASE_URL + URL_OBJ16 + "/gradle-folder.png");
        this.registerImage(registry, IMG_GRADLE_RUNTIME, ICON_BASE_URL + URL_OBJ16 + "/liberty-runtime-gradle.png");
        return registry;
    }

    public static Image getImage(String key) {
        return Activator.getInstance().getImageRegistry().get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        try {
            Activator.getInstance().getImageRegistry();
            return Activator.getInstance().imageDescriptors.get(key);
        }
        catch (Exception e) {
            Trace.trace((byte)1, "Missing image", e);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public static IPath getLibertyGradleMetadataPath() {
        IPath path = Activator.getInstance().getStateLocation().append("LibertyGradle");
        try {
            path.toFile().mkdirs();
        }
        catch (Exception e) {
            Trace.logError("Failed to create LibertyGradle metadata directory: " + path.toOSString(), e);
        }
        return path;
    }
}

