/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.maven.liberty.integration.internal;

import com.ibm.etools.maven.liberty.integration.manager.internal.LibertyManager;
import com.ibm.etools.maven.liberty.integration.manager.internal.LibertyMavenProjectMapping;
import com.ibm.etools.maven.liberty.integration.manager.internal.MavenProjectInspector;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.ConfigurationType;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.ILibertyBuildPluginImpl;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.IProjectInspector;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.LibertyBuildPluginConfiguration;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.Trace;
import com.ibm.ws.st.liberty.buildplugin.integration.manager.internal.AbstractLibertyProjectMapping;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;

public class LibertyMaven
implements ILibertyBuildPluginImpl {
    private static LibertyMaven instance = new LibertyMaven();

    private LibertyMaven() {
    }

    public static ILibertyBuildPluginImpl getInstance() {
        return instance;
    }

    public static boolean isMavenProject(IProject project, IProgressMonitor monitor) {
        return instance.getProjectInspector(project, monitor).isMavenProject();
    }

    public static LibertyBuildPluginConfiguration getLibertyMavenProjectConfiguration(IProject project, IProgressMonitor monitor) {
        return instance.getProjectInspector(project, monitor).getBuildPluginConfiguration(monitor);
    }

    public static boolean runMavenGoal(final IPath workingDir, String specifiedGoal, List<String> profiles, IProgressMonitor monitor) {
        boolean isSuccessful = true;
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.eclipse.m2e.Maven2LaunchConfigurationType");
        String goal = specifiedGoal + " -DskipTests=true -DskipLibertyPackage=true";
        try {
            Trace.trace((byte)0, (String)("Running maven goal '" + goal + "' with working directory: " + workingDir.toOSString()));
            ILaunchConfigurationWorkingCopy workingCopy = launchConfigurationType.newInstance((IContainer)null, workingDir.lastSegment());
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, workingDir.toOSString());
            workingCopy.setAttribute("M2_GOALS", goal);
            if (profiles != null && profiles.size() > 0) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < profiles.size(); ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    sb.append(profiles.get(i));
                }
                workingCopy.setAttribute("M2_PROFILES", sb.toString());
            }
            ILaunchConfiguration launchConfig = workingCopy.doSave();
            ILaunch launch = launchConfig.launch("run", monitor);
            Trace.trace((byte)0, (String)("Running maven goal '" + goal + "' with working directory: " + workingDir.toOSString()));
            IProcess[] processes = launch.getProcesses();
            ArrayList<IStreamMonitor> streamMonitors = new ArrayList<IStreamMonitor>();
            IStreamListener streamListener = new IStreamListener(){

                public void streamAppended(String text, IStreamMonitor monitor) {
                    Trace.trace((byte)0, (String)(workingDir.lastSegment() + ": " + text));
                }
            };
            for (IProcess p : processes) {
                IStreamMonitor outStream = p.getStreamsProxy().getOutputStreamMonitor();
                outStream.addListener(streamListener);
                streamMonitors.add(outStream);
                IStreamMonitor errorStream = p.getStreamsProxy().getErrorStreamMonitor();
                errorStream.addListener(streamListener);
                streamMonitors.add(errorStream);
            }
            while (!launch.isTerminated() && !monitor.isCanceled()) {
                Thread.sleep(500L);
            }
            for (IStreamMonitor m : streamMonitors) {
                try {
                    m.removeListener(streamListener);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            isSuccessful = false;
            Trace.logError((String)("The maven goal '" + goal + "' failed to execute using working directory: " + workingDir.toOSString()), (Throwable)e);
        }
        return isSuccessful;
    }

    public static Set<String> getTrackedProjects() {
        return LibertyMavenProjectMapping.getInstance().getMappedProjectSet();
    }

    public static IProject getMappedProject(IServer server) {
        if (server == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, (String)"The server argument is null.");
            }
            return null;
        }
        return LibertyMavenProjectMapping.getInstance().getMappedProject(server);
    }

    public static IServer getMappedServer(String projectName) {
        AbstractLibertyProjectMapping.ProjectMapping mapping = LibertyMavenProjectMapping.getInstance().getMapping(projectName);
        if (mapping == null || mapping.getServerID() == null) {
            return null;
        }
        return ServerCore.findServer((String)mapping.getServerID());
    }

    private MavenProjectInspector getProjectInspector(IProject project, IProgressMonitor monitor) {
        return new MavenProjectInspector(project);
    }

    public boolean isSupportedProject(IProject project, IProgressMonitor monitor) {
        return instance.getProjectInspector(project, monitor).isSupportedProject(monitor);
    }

    public void updateSrcConfig(IProject project, LibertyBuildPluginConfiguration config, IProgressMonitor monitor) {
        IPath location = project.getLocation();
        MavenProjectInspector mavenProjectInspector = (MavenProjectInspector)LibertyMaven.getInstance().getProjectInspector(project);
        boolean useLegacyRepublishCmd = mavenProjectInspector.useLegacyMvnGoal(monitor);
        String goal = useLegacyRepublishCmd ? "package liberty:install-apps" : "package liberty:deploy";
        LibertyMaven.runMavenGoal(location, goal, config.getActiveBuildProfiles(), monitor);
    }

    public LibertyBuildPluginConfiguration getLibertyBuildPluginConfiguration(IProject project, IProgressMonitor monitor) {
        return LibertyMaven.getLibertyMavenProjectConfiguration(project, monitor);
    }

    public String getRelativeBuildPluginConfigurationFileLocation() {
        return "/target/liberty-plugin-config.xml";
    }

    public IStatus preServerSetup(IProject project, LibertyBuildPluginConfiguration config, IPath serverPath, IProgressMonitor monitor) {
        String parentId = config.getConfigValue(ConfigurationType.aggregatorParentId);
        String parentBaseDir = config.getConfigValue(ConfigurationType.aggregatorParentBasedir);
        List profiles = config.getActiveBuildProfiles();
        if (parentId != null && parentBaseDir != null) {
            Path parentPath = new Path(parentBaseDir);
            if (!parentPath.toFile().exists()) {
                return new Status(4, "com.ibm.ws.st.liberty.buildplugin.integration", "The parent project could not be found " + parentId + " : " + parentBaseDir);
            }
            LibertyMaven.runMavenGoal((IPath)parentPath, "install", profiles, monitor);
        }
        if (!serverPath.toFile().exists()) {
            MavenProjectInspector mavenProjectInspector = (MavenProjectInspector)LibertyMaven.getInstance().getProjectInspector(project);
            boolean useLegacyRepublishCmd = mavenProjectInspector.useLegacyMvnGoal(monitor);
            String goal = useLegacyRepublishCmd ? "package liberty:install-apps" : "package liberty:deploy";
            Trace.trace((byte)0, (String)("Running " + goal + " goal on project: " + project.getName()));
            LibertyMaven.runMavenGoal(project.getLocation(), goal, profiles, monitor);
        }
        return Status.OK_STATUS;
    }

    public String getServerType() {
        return "LibertyMaven";
    }

    public boolean isDependencyModule(IProject moduleProject, IServer server) {
        IProject project = LibertyMaven.getMappedProject(server);
        if (project != null) {
            try {
                IModule[] modules;
                MavenProjectInspector pi = new MavenProjectInspector(project);
                for (IModule m : modules = pi.getProjectModules()) {
                    if (!m.getProject().equals(moduleProject)) continue;
                    return true;
                }
            }
            catch (Exception e) {
                Trace.logError((String)("Liberty Maven module lookup hit an error for project " + project.getName()), (Throwable)e);
            }
        }
        return false;
    }

    public AbstractLibertyProjectMapping getMappingHandler() {
        return LibertyMavenProjectMapping.getInstance();
    }

    public IProjectInspector getProjectInspector(IProject project) {
        return new MavenProjectInspector(project);
    }

    public void triggerAddRuntimeAndServer(IProject project, IProgressMonitor monitor) {
        LibertyManager.getInstance().triggerAddProject(project, monitor);
    }
}

