/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.liberty.buildplugin.integration.xml.internal;

import com.ibm.ws.st.liberty.buildplugin.integration.internal.Trace;
import com.ibm.ws.st.liberty.buildplugin.integration.manager.internal.AbstractLibertyProjectMapping;
import com.ibm.ws.st.liberty.buildplugin.integration.xml.internal.XMLDocumentBuilder;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class AbstractProjectMapXML
extends XMLDocumentBuilder {
    public static final String ROOT_ELEMENT = "mappings";
    private static final String PROJECT_ELEMENT = "project";
    private static final String SERVER_ID_ELEMENT = "serverId";
    private static final String RUNTIME_ID_ELEMENT = "runtimeId";
    private static final String NAME_ATTR = "name";
    private static final String IGNORED_ATTR = "ignored";
    private final File xmlFile;

    protected AbstractProjectMapXML(File xmlFile) {
        this.xmlFile = xmlFile;
    }

    public synchronized void unmarshall(ConcurrentHashMap<String, AbstractLibertyProjectMapping.ProjectMapping> trackedLibertyBuildPluginProjects, Set<String> ignoredProjects) throws ParserConfigurationException, SAXException, IOException {
        this.readDocument(this.xmlFile);
        this.fillMap(trackedLibertyBuildPluginProjects, ignoredProjects);
    }

    private void fillMap(ConcurrentHashMap<String, AbstractLibertyProjectMapping.ProjectMapping> trackedLibertyBuildPluginProjects, Set<String> ignoredProjects) {
        Element root = this.doc.getDocumentElement();
        NodeList mappings = root.getChildNodes();
        for (int i = 0; i < mappings.getLength(); ++i) {
            Element project;
            String projectName = null;
            String serverID = null;
            String runtimeID = null;
            boolean isIgnored = false;
            Node projNode = mappings.item(i);
            if (projNode.getNodeType() != 1 || this.invalidValue(projectName = (project = (Element)projNode).getAttribute(NAME_ATTR).trim())) continue;
            String isIgnoredValue = project.getAttribute(IGNORED_ATTR).trim();
            if (isIgnoredValue != null) {
                isIgnored = Boolean.parseBoolean(isIgnoredValue);
            }
            if (isIgnored) {
                ignoredProjects.add(projectName);
                return;
            }
            if (ignoredProjects.contains(projectName)) {
                ignoredProjects.remove(projectName);
            }
            NodeList projectChildren = project.getChildNodes();
            for (int j = 0; j < projectChildren.getLength(); ++j) {
                Node childNode = projectChildren.item(j);
                if (childNode.getNodeType() != 1) continue;
                Element c = (Element)childNode;
                if (SERVER_ID_ELEMENT.equals(c.getNodeName())) {
                    serverID = c.getTextContent().trim();
                    if (!this.invalidValue(serverID)) continue;
                    Trace.logError("Invalid server ID found in project mapping metadata file: " + serverID, null);
                    serverID = null;
                    continue;
                }
                if (!RUNTIME_ID_ELEMENT.equals(c.getNodeName()) || !this.invalidValue(runtimeID = c.getTextContent().trim())) continue;
                Trace.logError("Invalid runtime ID found in project mapping metadata file: " + runtimeID, null);
                runtimeID = null;
            }
            trackedLibertyBuildPluginProjects.put(projectName, new AbstractLibertyProjectMapping.ProjectMapping(runtimeID, serverID));
        }
    }

    private boolean invalidValue(String value) {
        return value == null || value.isEmpty();
    }

    public synchronized void marshall(ConcurrentHashMap<String, AbstractLibertyProjectMapping.ProjectMapping> trackedLibertyBuildPluginProjects, Set<String> ignoredProjects) throws ParserConfigurationException, IOException, TransformerException {
        this.createNewDocument(ROOT_ELEMENT);
        this.marshallMap(trackedLibertyBuildPluginProjects, ignoredProjects);
        this.writeXMLDocument(this.xmlFile);
    }

    private synchronized void marshallMap(ConcurrentHashMap<String, AbstractLibertyProjectMapping.ProjectMapping> values, Set<String> ignoredProjects) {
        Element child;
        if (values != null) {
            for (Map.Entry entry : values.entrySet()) {
                child = this.doc.createElement(PROJECT_ELEMENT);
                child.setAttribute(NAME_ATTR, (String)entry.getKey());
                this.createElement(child, (AbstractLibertyProjectMapping.ProjectMapping)entry.getValue());
                this.doc.getDocumentElement().appendChild(child);
            }
        }
        if (ignoredProjects != null) {
            for (String string : ignoredProjects) {
                child = this.doc.createElement(PROJECT_ELEMENT);
                child.setAttribute(NAME_ATTR, string);
                child.setAttribute(IGNORED_ATTR, Boolean.TRUE.toString());
                this.doc.getDocumentElement().appendChild(child);
            }
        }
    }

    private void createElement(Element elem, AbstractLibertyProjectMapping.ProjectMapping value) {
        String runtimeID;
        if (value == null) {
            return;
        }
        String serverID = value.getServerID();
        if (serverID != null) {
            this.createElement(elem, SERVER_ID_ELEMENT, serverID);
        }
        if ((runtimeID = value.getRuntimeID()) != null) {
            this.createElement(elem, RUNTIME_ID_ELEMENT, runtimeID);
        }
    }

    private void createElement(Element elem, String key, String value) {
        if (value == null) {
            return;
        }
        Element child = this.doc.createElement(key);
        child.appendChild(this.doc.createTextNode(value));
        elem.appendChild(child);
    }
}

