/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.security;

import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.security.LibertyX509CertPathValidatorRegistry;
import com.ibm.ws.st.core.internal.security.LibertyX509CertPathValidatorResult;
import com.ibm.ws.st.core.internal.security.LibertyX509CertRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.X509TrustManager;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class LibertyX509TrustManager
implements X509TrustManager {
    private static final String CERTIFICATE_TYPE = "X.509";
    private static final String ALGORITHM_TYPE = "PKIX";
    private static final String TRUSTED_KEYSTORE = "libertycerts";

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return null;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        LibertyX509CertPathValidatorResult result;
        LibertyX509CertPathValidatorResult.Status status;
        LibertyX509CertPathValidatorRegistry registry;
        LibertyX509CertPathValidatorResult[] results;
        int nastyIndex;
        Certificate nastyCert;
        CertPath nastyCertPath;
        Exception cause;
        boolean valid;
        CertPath certPath;
        block32: {
            Bundle bundle;
            URL keyStoreURL;
            if (Trace.ENABLED) {
                Trace.trace((byte)9, "certs=[" + Arrays.toString(certs) + "] authType=[" + authType + "]");
            }
            CertificateFactory certificateFactory = CertificateFactory.getInstance(CERTIFICATE_TYPE);
            if (Trace.ENABLED) {
                Trace.trace((byte)9, "certificateFactory=[" + certificateFactory + "]");
            }
            certPath = certificateFactory.generateCertPath(Arrays.asList(certs));
            if (Trace.ENABLED) {
                Trace.trace((byte)9, "certPath=[" + certPath + "]");
            }
            valid = false;
            cause = null;
            nastyCertPath = null;
            nastyCert = null;
            nastyIndex = -1;
            String Trusted_KeyStore = TRUSTED_KEYSTORE;
            if (Boolean.getBoolean("Liberty.Security.IgnorePredefined.KeyStore")) {
                Trusted_KeyStore = Trusted_KeyStore + "_ignore";
            }
            URL uRL = keyStoreURL = (bundle = Platform.getBundle((String)"com.ibm.ws.st.core")) == null ? null : FileLocator.find((Bundle)bundle, (IPath)new Path(Trusted_KeyStore), null);
            if (keyStoreURL != null) {
                try {
                    CertPathValidator certPathValidator = CertPathValidator.getInstance(ALGORITHM_TYPE);
                    if (Trace.ENABLED) {
                        Trace.trace((byte)9, "certPathValidator=[" + certPathValidator + "]");
                    }
                    KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    if (Trace.ENABLED) {
                        Trace.trace((byte)9, "keystore=[" + keyStore + "]");
                    }
                    InputStream inputStream = keyStoreURL.openStream();
                    char[] password = LibertyX509CertRegistry.getPassword().toCharArray();
                    keyStore.load(inputStream, password);
                    PKIXParameters parameters = new PKIXParameters(keyStore);
                    parameters.setRevocationEnabled(false);
                    if (Trace.ENABLED) {
                        Trace.trace((byte)9, "parameters=[" + parameters + "]");
                    }
                    certPathValidator.validate(certPath, parameters);
                    valid = true;
                }
                catch (NoSuchAlgorithmException e) {
                    Trace.logError("CertPathValidator.getInstance() or KeyStore.load(...) failed.", e);
                    cause = e;
                }
                catch (KeyStoreException e) {
                    Trace.logError("KeyStore.getInstance() or new PKIXParameters(...) failed.", e);
                    cause = e;
                }
                catch (IOException e) {
                    Trace.logError("Failed to open keystore input stream, or load the keystore from it.", e);
                    cause = e;
                }
                catch (InvalidAlgorithmParameterException e) {
                    Trace.logError("Failed to construct or use PKIXParameters.", e);
                    cause = e;
                }
                catch (CertificateException e) {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)9, "No predefined KeyStore was found.", e);
                    }
                    cause = e;
                }
                catch (CertPathValidatorException e) {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)9, "Server certificate validation failed.", e);
                    }
                    cause = e;
                    nastyCertPath = e.getCertPath();
                    if (nastyCertPath == null) break block32;
                    List<? extends Certificate> nastyCerts = nastyCertPath.getCertificates();
                    int size = nastyCerts.size();
                    if (size > 0) {
                        nastyIndex = e.getIndex();
                        Certificate certificate = nastyCert = nastyIndex >= 0 ? nastyCerts.get(nastyIndex) : nastyCerts.get(size - 1);
                    }
                    if (!Trace.ENABLED) break block32;
                    Trace.trace((byte)9, "nastyCertPath=[" + nastyCertPath + "] size=[" + size + "] nastyIndex=[" + nastyIndex + "] nastyCert=[" + nastyCert + "]");
                }
            }
        }
        if (!valid) {
            if (nastyCertPath == null) {
                nastyCertPath = certPath;
                List<? extends Certificate> nastyCerts = certPath.getCertificates();
                nastyIndex = nastyCerts.size() - 1;
                if (nastyIndex >= 0) {
                    nastyCert = nastyCerts.get(nastyIndex);
                }
                if (Trace.ENABLED) {
                    Trace.trace((byte)9, "nastyCertPath=[" + nastyCertPath + "] nastyIndex=[" + nastyIndex + "] nastyCert=[" + nastyCert + "]");
                }
            }
            try {
                valid = LibertyX509CertRegistry.instance().isTrusted(nastyCert);
            }
            catch (KeyStoreException e) {
                Trace.logError("An unexpected error occurred while checking the registry.", e);
            }
        }
        if (!valid && nastyCertPath != null && (results = (registry = LibertyX509CertPathValidatorRegistry.instance()).validate(nastyCertPath, nastyIndex, null, cause)).length > 0 && (status = (result = results[results.length - 1]).getStatus()) != LibertyX509CertPathValidatorResult.Status.ABSTAINED && status != LibertyX509CertPathValidatorResult.Status.REJECTED) {
            valid = true;
            try {
                if (status == LibertyX509CertPathValidatorResult.Status.VALID_FOR_SESSION) {
                    LibertyX509CertRegistry.instance().trustCertificateTransiently(result.getCertificate());
                } else if (status == LibertyX509CertPathValidatorResult.Status.VALID_FOR_WORKSPACE) {
                    LibertyX509CertRegistry.instance().trustCertificatePersistently(result.getCertificate());
                }
            }
            catch (KeyStoreException e) {
                Trace.logError("Saving the trusted certificate to the KeyStore failed", e);
            }
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)9, "valid=[" + valid + "]");
        }
        if (!valid) {
            throw cause == null ? new CertificateException() : new CertificateException(cause);
        }
    }
}

