/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.launch;

import com.ibm.ws.st.core.AbstractLibertyDebugFactory;
import com.ibm.ws.st.core.internal.Activator;
import com.ibm.ws.st.core.internal.IPromptIssue;
import com.ibm.ws.st.core.internal.IPromptResponse;
import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.PromptAction;
import com.ibm.ws.st.core.internal.PromptHandler;
import com.ibm.ws.st.core.internal.PromptUtil;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerBehaviour;
import com.ibm.ws.st.core.internal.launch.AbstractServerStartupExtension;
import com.ibm.ws.st.core.internal.launch.ServerStartInfo;
import com.ibm.ws.st.core.internal.launch.WebSphereLaunchConfigurationDelegate;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.jdi.Bootstrap;
import org.eclipse.jdi.TimeoutException;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaHotCodeReplaceListener;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;

public class LaunchUtilities {
    public static int TIMEOUT = 10000;
    public static final String DEBUGGER_FACTORY_EXTENSION_POINT = "debugTargetFactory";
    public static final String DEBUGGER_FACTORY_OVERRIDE_PROPERTY = "com.ibm.ws.st.debugFactoryOverride";
    public static final String DEBUGGER_FACTORY_JDT_OVERRIDE_WEIGHT = "0";
    protected static AbstractLibertyDebugFactory debugTargetFactory = null;
    protected static boolean debugTargetFactoryHasBeenInitialized = false;

    public static int findFreePort() {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException iOException) {
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return -1;
    }

    protected static IProcess newProcess(final IServer server, ILaunch launch, Process p, String label) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(IProcess.ATTR_PROCESS_TYPE, "java");
        return new RuntimeProcess(launch, p, label, attributes){

            public void terminate() throws DebugException {
                int state = server.getServerState();
                WebSphereServer wsServer = (WebSphereServer)((Object)server.loadAdapter(WebSphereServer.class, null));
                if (state != 4 && state != 3 && wsServer != null && wsServer.isStopOnShutdown()) {
                    server.stop(false);
                    WebSphereServerBehaviour wsb = (WebSphereServerBehaviour)((Object)server.loadAdapter(WebSphereServerBehaviour.class, null));
                    if (wsb != null && wsb.waitForServerStop(10000)) {
                        return;
                    }
                    super.terminate();
                }
            }
        };
    }

    public static AttachingConnector getAttachingConnector() {
        List<AttachingConnector> connectors = Bootstrap.virtualMachineManager().attachingConnectors();
        for (int i = 0; i < connectors.size(); ++i) {
            AttachingConnector c = connectors.get(i);
            if (!"com.sun.jdi.SocketAttach".equals(c.name())) continue;
            return c;
        }
        return null;
    }

    public static void configureConnector(Map map, String host, int portNumber) {
        Connector.StringArgument hostArg = (Connector.StringArgument)map.get("hostname");
        hostArg.setValue(host);
        Connector.IntegerArgument portArg = (Connector.IntegerArgument)map.get("port");
        portArg.setValue(portNumber);
        Connector.IntegerArgument timeoutArg = (Connector.IntegerArgument)map.get("timeout");
        if (timeoutArg != null) {
            int timeout = Platform.getPreferencesService().getInt("org.eclipse.jdt.launching", JavaRuntime.PREF_CONNECT_TIMEOUT, 20000, null);
            timeoutArg.setValue(timeout);
        }
    }

    public static IDebugTarget createRemoteJDTDebugTarget(ILaunch launch, int remoteDebugPortNum, String hostName, AttachingConnector connector, Map map) throws CoreException {
        if (launch == null || hostName == null || hostName.length() == 0) {
            return null;
        }
        VirtualMachine remoteVM = null;
        Exception ex = null;
        IDebugTarget debugTarget = null;
        try {
            remoteVM = LaunchUtilities.attachJVM(hostName, remoteDebugPortNum, connector, map, TIMEOUT);
        }
        catch (Exception e) {
            ex = e;
        }
        if (remoteVM == null) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", 120, "", (Throwable)ex));
        }
        String name = NLS.bind((String)Messages.debugTargetLabel, (Object)hostName, (Object)(remoteDebugPortNum + ""));
        debugTarget = JDIDebugModel.newDebugTarget((ILaunch)launch, (VirtualMachine)remoteVM, (String)name, null, (boolean)false, (boolean)true, (boolean)true);
        return debugTarget;
    }

    public static VirtualMachine attachJVM(String hostName, int port, AttachingConnector connector, Map map, int timeout) {
        VirtualMachine vm = null;
        int timeOut = timeout;
        try {
            try {
                vm = connector.attach(map);
            }
            catch (IOException e) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)0, "Error occured while trying to connect to the remote virtual machine " + e);
                }
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
            while (vm == null && timeOut > 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                timeOut -= 100;
                try {
                    vm = connector.attach(map);
                }
                catch (IOException iOException) {}
            }
        }
        catch (IllegalConnectorArgumentsException illegalConnectorArgumentsException) {
            // empty catch block
        }
        return vm;
    }

    public static void connectRemoteDebugClient(ILaunch launch, int remoteDebugPortNum, WebSphereServer wsServer) throws CoreException {
        WebSphereServerBehaviour wsBehaviour = wsServer.getWebSphereServerBehaviour();
        String hostName = wsServer.getConnectionHost();
        AbstractLibertyDebugFactory df = LaunchUtilities.getDebugTargetFactory();
        IDebugTarget curDebugTarget = null;
        if (df != null) {
            String debugTargetLabel = NLS.bind((String)Messages.debugTargetLabel, (Object)hostName, (Object)(remoteDebugPortNum + ""));
            curDebugTarget = df.createDebugTarget(launch, hostName, Integer.toString(remoteDebugPortNum), debugTargetLabel, null);
        }
        if (curDebugTarget == null) {
            try {
                AttachingConnector connector = LaunchUtilities.getAttachingConnector();
                Map<String, Connector.Argument> map = connector.defaultArguments();
                LaunchUtilities.configureConnector(map, hostName, remoteDebugPortNum);
                curDebugTarget = LaunchUtilities.createRemoteJDTDebugTarget(launch, remoteDebugPortNum, hostName, connector, map);
            }
            catch (CoreException e) {
                Trace.logError("Couldn't create a debug target. Debug connection failed.", e);
                throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", e.getLocalizedMessage(), (Throwable)e));
            }
        }
        if (curDebugTarget != null) {
            wsBehaviour.setDebugTarget(curDebugTarget);
            Activator.getInstance().addDebugTarget(curDebugTarget);
            wsBehaviour.setDebugPortNum(remoteDebugPortNum);
            launch.addDebugTarget(curDebugTarget);
            IJavaDebugTarget jdt = (IJavaDebugTarget)curDebugTarget.getAdapter(IJavaDebugTarget.class);
            if (jdt != null) {
                jdt.addHotCodeReplaceListener((IJavaHotCodeReplaceListener)new WebSphereJavaHotCodeReplaceListener(wsServer.getServer()));
            }
        }
    }

    public static String processVMArguments(String vmArgs, ServerStartInfo startInfo) {
        try {
            AbstractServerStartupExtension[] preStartExtensions = Activator.getInstance().getPreStartExtensions();
            if (preStartExtensions.length == 0) {
                return vmArgs;
            }
            String[] vmArray = DebugPlugin.parseArguments((String)vmArgs);
            ArrayList<String> vmArgsList = new ArrayList<String>(vmArray.length);
            for (String vmArg : vmArray) {
                vmArgsList.add(vmArg);
            }
            for (AbstractServerStartupExtension startup : preStartExtensions) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)0, "VMArgs BEFORE Pre-startup class: " + startup.getClass().toString() + " " + ((Object)vmArgsList).toString());
                }
                startup.setJVMOptions(startInfo, vmArgsList);
                if (!Trace.ENABLED) continue;
                Trace.trace((byte)0, "VMArgs AFTER Pre-startup class: " + startup.getClass().toString() + " " + ((Object)vmArgsList).toString());
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < vmArgsList.size(); ++i) {
                String s;
                if (i > 0) {
                    sb.append(" ");
                }
                if (!(s = (String)vmArgsList.get(i)).contains("\"")) {
                    sb.append("\"" + s + "\"");
                    continue;
                }
                sb.append(s);
            }
            return sb.toString();
        }
        catch (Exception e) {
            Trace.logError("Problem occurred while arguments were processed", e);
            return vmArgs;
        }
    }

    public static AbstractLibertyDebugFactory getDebugTargetFactory() {
        if (!debugTargetFactoryHasBeenInitialized) {
            if (PromptUtil.isRunningGUIMode()) {
                debugTargetFactory = LaunchUtilities.createDebugTargetFactory();
            }
            debugTargetFactoryHasBeenInitialized = true;
        }
        return debugTargetFactory;
    }

    public static AbstractLibertyDebugFactory createDebugTargetFactory() {
        AbstractLibertyDebugFactory debugTargetFactory;
        block15: {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, WebSphereLaunchConfigurationDelegate.class + "createDebugTargetUtil() Loading debug target factory extension point...");
            }
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] configElements = registry.getConfigurationElementsFor("com.ibm.ws.st.core", DEBUGGER_FACTORY_EXTENSION_POINT);
            debugTargetFactory = null;
            String override = System.getProperty(DEBUGGER_FACTORY_OVERRIDE_PROPERTY);
            int highestWeight = 0;
            IConfigurationElement selectedDebuggerConfig = null;
            int i = configElements.length;
            while (--i >= 0) {
                try {
                    String curWeightString = configElements[i].getAttribute("weight");
                    if (Trace.ENABLED) {
                        Trace.trace((byte)0, WebSphereLaunchConfigurationDelegate.class + "createDebugTargetFactory() Found debugger : " + configElements[i].getAttribute("class") + " with weight : " + curWeightString);
                    }
                    if (override != null) {
                        if (DEBUGGER_FACTORY_JDT_OVERRIDE_WEIGHT.equals(override)) {
                            return null;
                        }
                        if (curWeightString == null || !curWeightString.equals(override)) continue;
                        if (Trace.ENABLED) {
                            Trace.trace((byte)0, WebSphereLaunchConfigurationDelegate.class + "createDebugTargetFactory() Found debugger : " + configElements[i].getAttribute("class") + " which matches override value : " + curWeightString);
                        }
                        selectedDebuggerConfig = configElements[i];
                        break;
                    }
                    int curWeightInt = 1;
                    try {
                        curWeightInt = Integer.parseInt(curWeightString);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (curWeightInt < highestWeight) continue;
                    if (Trace.ENABLED) {
                        Trace.trace((byte)0, WebSphereLaunchConfigurationDelegate.class + "createDebugTargetFactory() Found debugger : " + configElements[i].getAttribute("class") + " with weight : " + curWeightInt);
                    }
                    selectedDebuggerConfig = configElements[i];
                    highestWeight = curWeightInt;
                }
                catch (Throwable t) {
                    if (!Trace.ENABLED) continue;
                    Trace.trace((byte)0, WebSphereLaunchConfigurationDelegate.class + "createDebugTargetFactory() Could not load the debug target util: " + configElements[i].getAttribute("class"), t);
                }
            }
            if (selectedDebuggerConfig != null) {
                try {
                    debugTargetFactory = (AbstractLibertyDebugFactory)selectedDebuggerConfig.createExecutableExtension("class");
                }
                catch (Throwable t) {
                    if (!Trace.ENABLED) break block15;
                    Trace.trace((byte)0, WebSphereLaunchConfigurationDelegate.class + "createDebugTargetFactory() Could not load the debug target util: " + selectedDebuggerConfig.getAttribute("class"), t);
                }
            }
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)0, WebSphereLaunchConfigurationDelegate.class + "createDebugTargetFactory() Finished creating debug target util: " + debugTargetFactory);
        }
        return debugTargetFactory;
    }

    public static void updateServerConfig(final WebSphereServer wsServer) {
        if (ServerCore.isAutoPublishing() && !wsServer.isLocalSetup() && !wsServer.getWebSphereServerBehaviour().isLocalUserDir()) {
            Job job = new Job(NLS.bind((String)Messages.jobWaitForServerStart, (Object)wsServer.getServer().getName())){

                protected IStatus run(IProgressMonitor monitor) {
                    WebSphereServerBehaviour wsBehaviour = wsServer.getWebSphereServerBehaviour();
                    wsBehaviour.waitForServerStart(wsServer.getServer(), monitor);
                    wsBehaviour.startAutoConfigSyncJob();
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    public static class WebSphereJavaHotCodeReplaceListener
    implements IJavaHotCodeReplaceListener {
        private final IServer server;

        public WebSphereJavaHotCodeReplaceListener(IServer curServer) {
            this.server = curServer;
        }

        public void hotCodeReplaceFailed(IJavaDebugTarget jdt, DebugException de) {
            PromptHandler promptHandler;
            IThread[] threads;
            ArrayList<String> outOfSyncClasses;
            ArrayList<IThread> suspendedThreads;
            ArrayList<IThread> resumingThreads;
            ArrayList<IModule> matchedModuleLst;
            block33: {
                matchedModuleLst = new ArrayList<IModule>();
                resumingThreads = new ArrayList<IThread>();
                suspendedThreads = new ArrayList<IThread>();
                outOfSyncClasses = new ArrayList<String>(3);
                try {
                    threads = jdt.getThreads();
                    IModule[] containedModules = this.server.getModules();
                    List<IModule> containedModuleLst = Arrays.asList(containedModules);
                    for (IThread curThread : threads) {
                        IModule[] curModules;
                        IProject curProj;
                        Object srcElement;
                        if (!curThread.isSuspended()) continue;
                        suspendedThreads.add(curThread);
                        IStackFrame curStackFrame = curThread.getTopStackFrame();
                        ISourceLocator curSrcLocator = jdt.getLaunch().getSourceLocator();
                        if (curSrcLocator == null || !((srcElement = curSrcLocator.getSourceElement(curStackFrame)) instanceof IFile) || (curProj = ((IFile)srcElement).getProject()) == null) continue;
                        for (IModule curModule : curModules = ServerUtil.getModules((IProject)curProj)) {
                            try {
                                IModule[] rootModules = this.server.getRootModules(curModule, null);
                                if (rootModules == null) continue;
                                for (IModule curRootModule : rootModules) {
                                    String curStackClassName;
                                    if (!containedModuleLst.contains(curRootModule) || matchedModuleLst.contains(curRootModule)) continue;
                                    matchedModuleLst.add(curRootModule);
                                    if (curStackFrame instanceof IJavaStackFrame && (curStackClassName = ((IJavaStackFrame)curStackFrame).getReceivingTypeName()) != null && !outOfSyncClasses.contains(curStackClassName)) {
                                        outOfSyncClasses.add(curStackClassName);
                                    }
                                    if (resumingThreads.contains(curThread)) continue;
                                    resumingThreads.add(curThread);
                                }
                            }
                            catch (CoreException e) {
                                if (!Trace.ENABLED) continue;
                                Trace.trace((byte)7, "Failed to find the root module to react to hot code replace failure: server=" + this.server + ", curModule=" + curModule);
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    if (!Trace.ENABLED) break block33;
                    Trace.trace((byte)0, "Failed to find the containing module that causes hot code replace.", e);
                }
            }
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Hot method replace failed detected: " + this.server.getName());
            }
            if ((promptHandler = Activator.getPromptHandler()) != null && !PromptUtil.isSuppressDialog()) {
                int matchedModuleSize = matchedModuleLst.size();
                String[] matchedModuleNames = new String[matchedModuleSize];
                int index = 0;
                for (IModule curMatchedModule : matchedModuleLst) {
                    matchedModuleNames[index++] = curMatchedModule.getName();
                }
                HotMethodReplaceFailedPrompt prompt = new HotMethodReplaceFailedPrompt(de.getLocalizedMessage(), matchedModuleNames);
                IPromptResponse response = promptHandler.getResponse(Messages.hotCodeReplaceFailedTitle, new PromptHandler.AbstractPrompt[]{prompt}, 4096);
                IPromptIssue[] issues = prompt.getIssues();
                if (response != null && response.getSelectedAction(issues[0]) != PromptAction.IGNORE) {
                    if (matchedModuleSize == 0) {
                        for (IThread curThread : suspendedThreads) {
                            if (!curThread.isSuspended() || !curThread.canResume()) continue;
                            try {
                                curThread.resume();
                            }
                            catch (DebugException curProj) {}
                        }
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        try {
                            for (IThread curThread : threads = jdt.getThreads()) {
                                if (!curThread.isSuspended() || !curThread.canResume()) continue;
                                try {
                                    curThread.resume();
                                }
                                catch (DebugException debugException) {
                                    // empty catch block
                                }
                            }
                        }
                        catch (Exception exception) {}
                    } else {
                        for (IThread curThread : resumingThreads) {
                            if (!curThread.isSuspended() || !curThread.canResume()) continue;
                            try {
                                curThread.resume();
                            }
                            catch (DebugException curProj) {}
                        }
                    }
                    if (matchedModuleSize > 0) {
                        for (IModule curModule : matchedModuleLst) {
                            try {
                                if (jdt instanceof JDIDebugTarget) {
                                    JDIDebugTarget jdiDebug = (JDIDebugTarget)jdt;
                                    jdiDebug.removeOutOfSynchTypes(outOfSyncClasses);
                                    jdiDebug.fireChangeEvent(256);
                                }
                                this.server.restartModule(new IModule[]{curModule}, null);
                            }
                            catch (Exception e) {
                                if (!Trace.ENABLED) continue;
                                Trace.trace((byte)1, "Failed to restart module: " + curModule.getName());
                            }
                        }
                    } else {
                        this.server.restart("debug", new IServer.IOperationListener(){

                            public void done(IStatus arg0) {
                                if (Trace.ENABLED) {
                                    Trace.trace((byte)0, "Server has restarted successfully for hot method replace fix.");
                                }
                            }
                        });
                    }
                }
            }
        }

        public void hotCodeReplaceSucceeded(IJavaDebugTarget jdt) {
        }

        public void obsoleteMethods(IJavaDebugTarget jdt) {
        }
    }

    static class HotCodeReplaceIssue
    implements IPromptIssue {
        private final boolean isRestartServers;
        private final String details;

        HotCodeReplaceIssue(String errMsg, String[] moduleNames) {
            this.isRestartServers = moduleNames == null || moduleNames.length == 0;
            this.details = this.buildDetails(errMsg, moduleNames);
        }

        @Override
        public String getType() {
            return Messages.hotCodeReplaceFailedIssue;
        }

        @Override
        public String getSummary() {
            return Messages.hotCodeReplaceFailedSummary;
        }

        @Override
        public String getDetails() {
            return this.details;
        }

        @Override
        public PromptAction[] getPossibleActions() {
            PromptAction[] promptActionArray;
            if (this.isRestartServers) {
                PromptAction[] promptActionArray2 = new PromptAction[2];
                promptActionArray2[0] = PromptAction.RESTART_SERVERS;
                promptActionArray = promptActionArray2;
                promptActionArray2[1] = PromptAction.IGNORE;
            } else {
                PromptAction[] promptActionArray3 = new PromptAction[2];
                promptActionArray3[0] = PromptAction.RESTART_APPLICATIONS;
                promptActionArray = promptActionArray3;
                promptActionArray3[1] = PromptAction.IGNORE;
            }
            return promptActionArray;
        }

        @Override
        public PromptAction getDefaultAction() {
            return this.isRestartServers ? PromptAction.RESTART_SERVERS : PromptAction.RESTART_APPLICATIONS;
        }

        private String buildDetails(String errMsg, String[] moduleNames) {
            if (moduleNames != null && moduleNames.length > 0) {
                StringBuilder moduleLstStr = new StringBuilder();
                for (String curModuleName : moduleNames) {
                    moduleLstStr.append("\t").append(curModuleName).append("\n");
                }
                return NLS.bind((String)Messages.hotCodeReplaceFailedGeneralMsg, (Object)errMsg) + NLS.bind((String)Messages.hotCodeReplaceFailedRestartModuleMsg, (Object)moduleLstStr);
            }
            return NLS.bind((String)Messages.hotCodeReplaceFailedGeneralMsg, (Object)errMsg) + Messages.hotCodeReplaceFailedRestartServerMsg;
        }
    }

    protected static class HotMethodReplaceFailedPrompt
    extends PromptHandler.AbstractPrompt {
        private final IPromptIssue issue;

        protected HotMethodReplaceFailedPrompt(String curErrMsg, String[] curModuleNames) {
            this.issue = new HotCodeReplaceIssue(curErrMsg, curModuleNames);
        }

        @Override
        public boolean getApplyAlways() {
            return false;
        }

        @Override
        public IPromptIssue[] getIssues() {
            return new IPromptIssue[]{this.issue};
        }
    }
}

