/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.launch;

import com.ibm.ws.st.core.internal.FileUtil;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.jmx.JMXConnection;
import com.ibm.ws.st.core.internal.launch.ConsoleReader;
import com.ibm.ws.st.core.internal.launch.StreamMonitor;
import java.io.File;
import java.io.IOException;
import javax.management.openmbean.CompositeData;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy2;

public class ConsoleStreamsProxy
implements IStreamsProxy2 {
    private static final int DELAY = 500;
    private static final int JMX_DELAY = 5000;
    final ConsoleReader consoleMonitor;
    private final StreamMonitor outMonitor;
    private final StreamMonitor errMonitor;
    private final File consoleFile;
    private final boolean useConsoleLog;
    protected Thread streamThread;
    protected boolean done = false;
    protected JMXConnection jmx;

    public ConsoleStreamsProxy(File consoleFile, boolean useConsoleLog, JMXConnection jmx) {
        if (consoleFile == null) {
            throw new IllegalArgumentException("Console file cannot be null");
        }
        this.consoleFile = consoleFile;
        this.useConsoleLog = useConsoleLog;
        this.outMonitor = new StreamMonitor(useConsoleLog);
        this.errMonitor = new StreamMonitor(useConsoleLog);
        this.consoleMonitor = new ConsoleReader(consoleFile, this.outMonitor, this.errMonitor);
        this.jmx = jmx;
        this.startMonitoring();
    }

    public IStreamMonitor getErrorStreamMonitor() {
        return this.errMonitor;
    }

    public IStreamMonitor getOutputStreamMonitor() {
        return this.outMonitor;
    }

    public void write(String input) throws IOException {
    }

    public void close() {
        if (Trace.ENABLED) {
            Trace.trace((byte)0, "Terminating console monitor");
        }
        this.done = true;
        this.consoleMonitor.close();
    }

    protected void update() {
        if (this.jmx != null) {
            this.updateLogFileViaJMX();
        }
        this.consoleMonitor.update();
    }

    private void startMonitoring() {
        if (this.streamThread != null) {
            return;
        }
        this.streamThread = new Thread("WebSphere console monitor"){

            @Override
            public void run() {
                this.checkAndSetCharset();
                while (!ConsoleStreamsProxy.this.done) {
                    ConsoleStreamsProxy.this.update();
                    try {
                        int delay = ConsoleStreamsProxy.this.jmx == null ? 500 : 5000;
                        1.sleep(delay);
                    }
                    catch (Exception exception) {}
                }
                ConsoleStreamsProxy.this.streamThread = null;
            }

            private void checkAndSetCharset() {
                if (ConsoleStreamsProxy.this.jmx == null) {
                    return;
                }
                try {
                    String osNameAttr = (String)ConsoleStreamsProxy.this.jmx.getMBeanAttribute("java.lang:type=OperatingSystem", "Name");
                    if (osNameAttr != null && osNameAttr.equals("z/OS")) {
                        ConsoleStreamsProxy.this.consoleMonitor.setCharset("IBM1047");
                    }
                }
                catch (Exception e) {
                    Trace.logError("Problem while checking the charset", e);
                }
            }
        };
        this.streamThread.setPriority(1);
        this.streamThread.setDaemon(true);
        this.streamThread.start();
    }

    public void closeInputStream() throws IOException {
    }

    private void updateLogFileViaJMX() {
        block5: {
            if (this.jmx == null) {
                return;
            }
            try {
                String logFileName;
                String messagesFileName = "messages.log";
                String string = logFileName = this.useConsoleLog ? "console.log" : messagesFileName;
                if (this.jmx.isConnected()) {
                    CompositeData metadata = (CompositeData)this.jmx.getMetadata("${com.ibm.ws.logging.log.directory}", "a");
                    String logFileDirectory = (String)metadata.get("fileName");
                    Path consoleFilePath = new Path(this.consoleFile.getAbsolutePath());
                    if (!this.consoleFile.exists()) {
                        FileUtil.makeDir(consoleFilePath.removeLastSegments(1));
                    }
                    this.jmx.downloadFile(logFileDirectory + "/" + logFileName, consoleFilePath.toOSString());
                }
            }
            catch (Exception e) {
                if (!Trace.ENABLED) break block5;
                Trace.trace((byte)7, "Failed to download latest console file.", e);
            }
        }
    }
}

