/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.config.validation;

import com.ibm.ws.st.core.internal.config.validation.ConfigFileFilterItem;
import com.ibm.ws.st.core.internal.config.validation.MatchFilterItem;
import com.ibm.ws.st.core.internal.config.validation.ValidationFilterSettings;
import com.ibm.ws.st.core.internal.config.validation.ValidationFilterUtil;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class ValidationFilterMatcher {
    private final IProject project;
    private final ValidationFilterSettings valSettings;

    public ValidationFilterMatcher(IProject project) {
        this.project = project;
        this.valSettings = new ValidationFilterSettings(project);
    }

    public boolean isIgnoreAttribute(IResource resource, String elemName, String attrName) {
        Set<ConfigFileFilterItem> configSet = this.valSettings.getConfigFileItems();
        String pathString = ValidationFilterUtil.getRelativePathString(this.project, resource);
        for (ConfigFileFilterItem cfi : configSet) {
            MatchFilterItem[] matchItems;
            String configPath = cfi.getPath();
            if (configPath != "*" && !configPath.equals(pathString)) continue;
            for (MatchFilterItem matchItem : matchItems = cfi.getMatchItems()) {
                if (!this.matchAttribute(matchItem, elemName, attrName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchAttribute(MatchFilterItem matchItem, String elemName, String attrName) {
        String matchElemName;
        if ("UNREC_ATTR".equals(matchItem.getPattern()) && ((matchElemName = matchItem.getElementName()) == "*" || matchElemName.equals(elemName))) {
            String matchAttrName = matchItem.getAttributeName();
            return matchAttrName == "*" || matchAttrName.equals(attrName);
        }
        return false;
    }
}

