/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.config.validation;

import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.config.validation.AbstractTextFileParser;
import com.ibm.ws.st.core.internal.config.validation.ConfigurationValidator;
import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.validation.ValidationResult;

public class JVMOptionsValidator
extends AbstractTextFileParser {
    public JVMOptionsValidator(IFile file) throws CoreException, UnsupportedEncodingException {
        super(file);
    }

    @Override
    protected void parseImpl(ValidationResult result) throws IOException {
        this.readChar();
        while (true) {
            String s;
            String t;
            if ('#' == this.nextChar) {
                while (!JVMOptionsValidator.isEOLChar(this.nextChar)) {
                    this.readChar();
                }
                this.readEOL();
                continue;
            }
            if (JVMOptionsValidator.isEOLChar(this.nextChar)) {
                this.readEOL();
                continue;
            }
            StringBuilder sb = new StringBuilder();
            try {
                while (!JVMOptionsValidator.isEOLChar(this.nextChar)) {
                    sb.append(this.nextChar);
                    this.readChar();
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            if ((t = (s = sb.toString()).trim()).length() == 0) {
                result.add(ConfigurationValidator.createInvalidWhitespaceMessage(this.file, this.line, this.charCount - s.length(), this.charCount));
            } else {
                int end;
                int start = s.indexOf(t);
                if (start > 0) {
                    result.add(ConfigurationValidator.createInvalidWhitespaceMessage(this.file, this.line, this.charCount - s.length(), this.charCount - s.length() + start));
                }
                if ((end = start + t.length()) < s.length()) {
                    result.add(ConfigurationValidator.createInvalidWhitespaceMessage(this.file, this.line, this.charCount - s.length() + end, this.charCount));
                }
                if (!t.startsWith("-")) {
                    int x = this.charCount - s.length();
                    result.add(ConfigurationValidator.createMessage(this.file, Messages.invalidJVMOption, this.line, x, x + 1));
                }
            }
            this.readEOL();
        }
    }
}

