/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.config;

import com.ibm.ws.st.core.internal.config.ConfigVars;
import com.ibm.ws.st.core.internal.config.DocumentLocation;
import com.ibm.ws.st.core.internal.config.ExtendedConfigFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;

public class ServerEnv
extends ExtendedConfigFile {
    private final HashMap<String, String> envVars = new HashMap();
    private final HashMap<String, Integer> varLines = new HashMap();
    private long lastModified = -1L;

    public ServerEnv(File file, IFile ifile) throws IOException {
        super(file, ifile);
        this.lastModified = file.lastModified();
        this.load();
    }

    public boolean hasChanged() {
        long timestamp = this.file.lastModified();
        return timestamp != this.lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws IOException {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(this.file));
            int lineNo = 0;
            while ((line = reader.readLine()) != null) {
                int index;
                ++lineNo;
                String trimmedLine = line.trim();
                if (trimmedLine.isEmpty() || trimmedLine.startsWith("#") || (index = line.indexOf(61)) <= 0) continue;
                String key = line.substring(0, index);
                String value = line.substring(index + 1, line.length());
                this.envVars.put(key, value);
                this.varLines.put(key, new Integer(lineNo));
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public String getValue(String varName) {
        return this.envVars.get(varName);
    }

    public void getVariables(ConfigVars vars) {
        Set<Map.Entry<String, String>> entries = this.envVars.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String key = entry.getKey();
            DocumentLocation location = DocumentLocation.createDocumentLocation(this.file.toURI(), DocumentLocation.Type.SERVER_ENV, this.varLines.get(key));
            vars.addResolved("env." + key, entry.getValue(), null, location);
        }
    }

    @Override
    public String toString() {
        return "Server Env [" + this.file + "]";
    }
}

