/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.config;

import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.core.internal.config.DOMUtils;
import com.ibm.ws.st.core.internal.generation.SchemaMetadata;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.CMDocumentManager;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMDocumentCache;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xsd.contentmodel.internal.XSDImpl;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDVariety;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SchemaUtil {
    static final String EXT_XSD = "http://www.ibm.com/xmlns/dde/schema/annotation/ext";
    static final String SCHEMA_XSD = "http://www.w3.org/2001/XMLSchema";

    public static String getAttributeDefault(Document doc, String[] tags, String attrName, URI uri) {
        CMAttributeDeclaration a = SchemaUtil.getAttribute(doc, tags, attrName, uri);
        return a != null ? a.getDefaultValue() : null;
    }

    public static CMAttributeDeclaration getAttribute(Document doc, String[] tags, String attrName, URI uri) {
        CMElementDeclaration element = SchemaUtil.getElement(doc, tags, uri);
        if (element != null) {
            return SchemaUtil.getAttr(element, attrName);
        }
        return null;
    }

    public static CMAttributeDeclaration getAttribute(Document doc, String[] tags, String attrName, URL schemaURL) {
        CMElementDeclaration element = SchemaUtil.getElement(doc, tags, schemaURL);
        if (element != null) {
            return SchemaUtil.getAttr(element, attrName);
        }
        return null;
    }

    public static CMElementDeclaration getElement(Document doc, String[] tags, URI uri) {
        CMDocument cmDoc = SchemaUtil.getSchema(doc, uri);
        return cmDoc != null ? SchemaUtil.getElement(cmDoc, tags) : null;
    }

    public static CMElementDeclaration getElement(Document doc, String[] tags, URL schemaURL) {
        CMDocument cmDoc = schemaURL == null ? null : SchemaUtil.getCMDocument(schemaURL, doc);
        return cmDoc != null ? SchemaUtil.getElement(cmDoc, tags) : null;
    }

    public static CMDataType getAttributeType(Document doc, String[] tags, String attrName, URI uri) {
        CMAttributeDeclaration attr = SchemaUtil.getAttribute(doc, tags, attrName, uri);
        if (attr != null) {
            return attr.getAttrType();
        }
        return null;
    }

    public static CMDataType getElementType(Document doc, String[] tags, URI uri) {
        CMElementDeclaration element = SchemaUtil.getElement(doc, tags, uri);
        if (element != null) {
            CMDataType type = element.getDataType();
            return type;
        }
        return null;
    }

    public static CMDataType getAttributeType(Element parent, String name, Document doc, URI uri) {
        String[] tags = SchemaUtil.getTags(parent);
        return SchemaUtil.getAttributeType(doc, tags, name, uri);
    }

    public static String[] getEnumeratedValues(Document doc, String[] tags, URI uri) {
        CMDataType type = SchemaUtil.getElementType(doc, tags, uri);
        return type != null ? type.getEnumeratedValues() : null;
    }

    public static CMAttributeDeclaration findAttribute(Attr a, URI uri) {
        Document doc = a.getOwnerDocument();
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)doc);
        return modelQuery != null ? modelQuery.getCMAttributeDeclaration(a) : null;
    }

    public static CMElementDeclaration getElement(Element e) {
        Document doc = e.getOwnerDocument();
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)doc);
        return modelQuery == null ? null : modelQuery.getCMElementDeclaration(e);
    }

    public static CMAttributeDeclaration getAttribute(Element elem, String attrName) {
        CMElementDeclaration elemDecl = SchemaUtil.getElement(elem);
        return elemDecl == null ? null : SchemaUtil.getAttr(elemDecl, attrName);
    }

    public static String getLabel(CMNode node) {
        return SchemaUtil.getAppInfo(node, EXT_XSD, "label");
    }

    public static String getLabel(Document doc, String[] elemTags, URI uri) {
        CMElementDeclaration elemDecl = SchemaUtil.getElement(doc, elemTags, uri);
        if (elemDecl == null) {
            return null;
        }
        return SchemaUtil.getLabel((CMNode)elemDecl);
    }

    public static String getLabel(Document doc, String[] elemTags, String attrName, URI uri) {
        CMAttributeDeclaration attrDecl = SchemaUtil.getAttribute(doc, elemTags, attrName, uri);
        if (attrDecl == null) {
            return null;
        }
        return SchemaUtil.getLabel((CMNode)attrDecl);
    }

    public static String[] getReferences(CMNode node) {
        return SchemaUtil.getAppInfo(node, EXT_XSD, "reference", false);
    }

    public static String getExtInfo(CMNode node, String extName) {
        return SchemaUtil.getAppInfo(node, EXT_XSD, extName);
    }

    public static boolean hasExtraProperties(CMNode node) {
        Element[] elems = SchemaUtil.getAppInfoElements(node, EXT_XSD, "extraProperties", true);
        return elems.length > 0;
    }

    static String getAppInfo(CMNode node, String ns, String tag) {
        String[] result = SchemaUtil.getAppInfo(node, ns, tag, true);
        if (result.length == 0) {
            return null;
        }
        return result[0];
    }

    private static String[] getAppInfo(CMNode node, String ns, String tag, boolean firstOnly) {
        String APPINFO = "appinfo";
        XSDAnnotation annotation = SchemaUtil.getAnnotation(node);
        ArrayList<String> resultList = new ArrayList<String>();
        if (annotation != null) {
            Element e = annotation.getElement();
            Element e2 = DOMUtils.getFirstChildElement(e, SCHEMA_XSD, "appinfo");
            while (e2 != null) {
                Element e3 = DOMUtils.getFirstChildElement(e2, ns, tag);
                while (e3 != null) {
                    String s = DOMUtils.getTextContent(e3);
                    if (s != null) {
                        if (firstOnly) {
                            return new String[]{s.trim()};
                        }
                        resultList.add(s.trim());
                    }
                    e3 = DOMUtils.getNextElement(e3, ns, tag);
                }
                e2 = DOMUtils.getNextElement(e2, SCHEMA_XSD, "appinfo");
            }
        }
        return resultList.toArray(new String[resultList.size()]);
    }

    private static Element[] getAppInfoElements(CMNode node, String ns, String tag, boolean firstOnly) {
        String APPINFO = "appinfo";
        XSDAnnotation annotation = SchemaUtil.getAnnotation(node);
        ArrayList<Element> resultList = new ArrayList<Element>();
        if (annotation != null) {
            Element e = annotation.getElement();
            Element e2 = DOMUtils.getFirstChildElement(e, SCHEMA_XSD, "appinfo");
            while (e2 != null) {
                Element e3 = DOMUtils.getFirstChildElement(e2, ns, tag);
                while (e3 != null) {
                    if (firstOnly) {
                        return new Element[]{e3};
                    }
                    resultList.add(e3);
                    e3 = DOMUtils.getNextElement(e3, ns, tag);
                }
                e2 = DOMUtils.getNextElement(e2, SCHEMA_XSD, "appinfo");
            }
        }
        return resultList.toArray(new Element[resultList.size()]);
    }

    public static String getDocumentation(CMNode node) {
        XSDAnnotation annotation = SchemaUtil.getAnnotation(node);
        return SchemaUtil.getDocumentation(annotation);
    }

    public static String getDocumentation(XSDAnnotation annotation) {
        String s;
        Element e;
        Element documentation;
        String DOCUMENTATION = "documentation";
        if (annotation != null && (documentation = DOMUtils.getFirstChildElement(e = annotation.getElement(), SCHEMA_XSD, "documentation")) != null && (s = DOMUtils.getTextContent(documentation)) != null) {
            return s.trim();
        }
        return null;
    }

    private static XSDAnnotation getAnnotation(CMNode node) {
        XSDImpl.XSDAttributeUseAdapter adapter;
        Notifier target;
        XSDAnnotation annotation = null;
        if (node instanceof XSDImpl.XSDElementDeclarationAdapter) {
            XSDElementDeclaration edecl;
            XSDImpl.XSDElementDeclarationAdapter adapter2 = (XSDImpl.XSDElementDeclarationAdapter)node;
            Notifier target2 = adapter2.getTarget();
            if (target2 instanceof XSDElementDeclaration && (annotation = (edecl = (XSDElementDeclaration)target2).getAnnotation()) == null) {
                XSDTypeDefinition type = edecl.getTypeDefinition();
                annotation = type.getAnnotation();
                while (annotation == null && type.getBaseType() != null && !type.isCircular()) {
                    type = type.getBaseType();
                    annotation = type.getAnnotation();
                }
            }
        } else if (node instanceof XSDImpl.XSDAttributeUseAdapter && (target = (adapter = (XSDImpl.XSDAttributeUseAdapter)node).getTarget()) instanceof XSDAttributeUse) {
            XSDAttributeUse use = (XSDAttributeUse)target;
            XSDAttributeDeclaration attr = use.getAttributeDeclaration();
            annotation = attr.getAnnotation();
        }
        return annotation;
    }

    static CMElementDeclaration getElement(CMDocument cmDoc, String[] tags) {
        CMNamedNodeMap map = cmDoc.getElements();
        CMElementDeclaration element = (CMElementDeclaration)map.getNamedItem(tags[0]);
        for (int i = 1; element != null && i < tags.length; ++i) {
            element = SchemaUtil.getElement(element, tags[i]);
        }
        return element;
    }

    public static CMElementDeclaration getElement(CMElementDeclaration element, String tag) {
        CMNamedNodeMap map = element.getLocalElements();
        return map != null ? (CMElementDeclaration)map.getNamedItem(tag) : null;
    }

    public static CMAttributeDeclaration getAttr(CMElementDeclaration element, String name) {
        CMNamedNodeMap attrs = element.getAttributes();
        return (CMAttributeDeclaration)attrs.getNamedItem(name);
    }

    static boolean hasAttr(Element element, String attrName, URI uri) {
        CMNamedNodeMap attrs;
        String[] tags = SchemaUtil.getTags(element);
        CMElementDeclaration elemDecl = SchemaUtil.getElement(element.getOwnerDocument(), tags, uri);
        return elemDecl != null && (attrs = elemDecl.getAttributes()).getNamedItem(attrName) != null;
    }

    public static String[] getTags(Element element) {
        ArrayList<String> tagList = new ArrayList<String>();
        tagList.add(element.getNodeName());
        for (Node parent = element.getParentNode(); parent != null && parent.getNodeType() == 1; parent = parent.getParentNode()) {
            tagList.add(parent.getNodeName());
        }
        int len = tagList.size();
        String[] tags = new String[len];
        for (int i = 0; i < tagList.size(); ++i) {
            tags[i] = (String)tagList.get(len - i - 1);
        }
        return tags;
    }

    static CMDocument getSchema(Document dom, URI uri) {
        CMDocument cmDoc = null;
        URL grammarURL = SchemaUtil.getSchemaURL(uri);
        if (grammarURL != null) {
            cmDoc = SchemaUtil.getCMDocument(grammarURL, dom);
        }
        return cmDoc;
    }

    public static URL getSchemaURLNoFallback(URI uri) {
        URL grammarURL;
        block7: {
            WebSphereRuntime[] runtimes = WebSphereUtil.getWebSphereRuntimes();
            grammarURL = null;
            if (runtimes != null) {
                for (WebSphereRuntime runtime : runtimes) {
                    List<WebSphereServerInfo> serverInfos = runtime.getWebSphereServerInfos();
                    for (int i = 0; i < serverInfos.size() && grammarURL == null; ++i) {
                        grammarURL = serverInfos.get(i).getConfigurationSchemaURL(uri);
                    }
                    if (grammarURL != null) continue;
                    grammarURL = runtime.getConfigurationSchemaURL(uri);
                }
            }
            if (grammarURL == null) {
                try {
                    WebSphereRuntime wrt = WebSphereUtil.getTargetedRuntime(uri);
                    if (wrt != null) {
                        grammarURL = wrt.getConfigurationSchemaURL();
                    }
                }
                catch (CoreException e) {
                    if (!Trace.ENABLED) break block7;
                    Trace.logError("Failed to get schema from targeted runtime for file " + uri.toString(), e);
                }
            }
        }
        return grammarURL;
    }

    public static URL getSchemaURL(URI uri) {
        URL grammarURL = SchemaUtil.getSchemaURLNoFallback(uri);
        if (grammarURL == null) {
            grammarURL = SchemaMetadata.getFallbackSchema();
        }
        return grammarURL;
    }

    private static CMDocument getCMDocument(URL grammarURL, Document dom) {
        CMDocumentManager manager;
        CMDocumentCache cache;
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)dom);
        if (modelQuery != null && modelQuery.getCMDocumentManager() != null && (cache = (manager = modelQuery.getCMDocumentManager()).getCMDocumentCache()) != null) {
            String s = grammarURL.toString();
            CMDocument cmDoc = cache.getCMDocument(s);
            if (cmDoc == null && dom != null && dom.getDocumentElement() != null) {
                modelQuery.getCMNode((Node)dom.getDocumentElement());
                cmDoc = cache.getCMDocument(s);
            }
            if (cmDoc != null) {
                return cmDoc;
            }
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)1, "The CMDocument could not be found for: " + grammarURL);
        }
        return null;
    }

    public static XSDTypeDefinition getTypeDefinitionFromSchema(CMNode node) {
        XSDTypeDefinition type = null;
        if (node instanceof XSDImpl.XSDElementDeclarationAdapter) {
            XSDImpl.XSDElementDeclarationAdapter adapter = (XSDImpl.XSDElementDeclarationAdapter)node;
            Notifier target = adapter.getTarget();
            if (target instanceof XSDElementDeclaration) {
                XSDElementDeclaration edecl = (XSDElementDeclaration)target;
                type = edecl.getTypeDefinition();
            }
        } else if (node instanceof XSDImpl.XSDAttributeUseAdapter) {
            XSDImpl.XSDAttributeUseAdapter adapter = (XSDImpl.XSDAttributeUseAdapter)node;
            Notifier target = adapter.getTarget();
            if (target instanceof XSDAttributeUse) {
                XSDAttributeUse use = (XSDAttributeUse)target;
                XSDAttributeDeclaration attr = use.getAttributeDeclaration();
                type = attr.getTypeDefinition();
            }
            if (target instanceof XSDAttributeDeclaration) {
                XSDAttributeDeclaration attr = (XSDAttributeDeclaration)target;
                type = attr.getTypeDefinition();
            }
        }
        return type;
    }

    public static List<XSDSimpleTypeDefinition> getMemberTypesFromUnion(CMNode node) {
        XSDSimpleTypeDefinition st;
        XSDTypeDefinition type = SchemaUtil.getTypeDefinitionFromSchema(node);
        if (type instanceof XSDSimpleTypeDefinition && type.getName() == null && (st = (XSDSimpleTypeDefinition)type).getVariety().equals((Object)XSDVariety.UNION_LITERAL)) {
            return st.getMemberTypeDefinitions();
        }
        return null;
    }
}

