/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.ApplicationPublisher;
import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.OutOfSyncModuleInfo;
import com.ibm.ws.st.core.internal.PublishUnit;
import com.ibm.ws.st.core.internal.ServerExtension;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerBehaviour;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.jmx.JMXConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;

public class ServerExtensionWrapper {
    private static final String EXTENSION_POINT = "serverExtensions";
    private static final String MODULE = "module";
    private static final String TYPE = "type";
    private static final String APPLICATION_TYPE = "applicationType";
    private static final String APPLICATION_ELEMENT = "applicationElement";
    private static String[] allApplicationTypes;
    private static String[] allGenericModuleTypes;
    private static String[] allApplicationElements;
    private static final String GENERIC_APP_TYPE = "generic";
    private final IConfigurationElement configElement;
    private final String[] moduleTypes;
    private final String[] applicationTypes;
    private final String[] genericModuleTypes;
    private final String[] applicationElements;
    private static final HashMap<String, String> applicationElementToTypeMap;
    private ServerExtension delegate;
    private ApplicationPublisher publishDelegate;
    private WebSphereServer server;
    private WebSphereServerBehaviour servBehaviour;
    private JMXConnection jmxConnection;

    public static ServerExtensionWrapper[] createServerExtensions() {
        if (Trace.ENABLED) {
            Trace.trace((byte)3, "->- Loading .serverExtensions extension point ->-");
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("com.ibm.ws.st.core", EXTENSION_POINT);
        ArrayList<ServerExtensionWrapper> list = new ArrayList<ServerExtensionWrapper>(cf.length);
        HashSet<String> appTypeList = new HashSet<String>();
        HashSet<String> genericTypeList = new HashSet<String>();
        HashSet<String> applicationElementList = new HashSet<String>();
        applicationElementList.add("application");
        for (IConfigurationElement ce : cf) {
            try {
                ServerExtensionWrapper sew = new ServerExtensionWrapper(ce);
                list.add(sew);
                for (String s : sew.applicationTypes) {
                    if (s == null) continue;
                    appTypeList.add(s);
                }
                for (String s : sew.applicationElements) {
                    if (s == null) continue;
                    applicationElementList.add(s);
                }
                for (String s : sew.genericModuleTypes) {
                    genericTypeList.add(s);
                }
                if (!Trace.ENABLED) continue;
                Trace.trace((byte)3, "  Loaded serverExtension: " + ce.getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.logError("Could not load serverExtension: " + ce.getAttribute("id"), t);
            }
        }
        if (allApplicationTypes == null) {
            allApplicationTypes = appTypeList.toArray(new String[appTypeList.size()]);
        }
        if (allApplicationElements == null) {
            allApplicationElements = applicationElementList.toArray(new String[applicationElementList.size()]);
        }
        if (allGenericModuleTypes == null) {
            allGenericModuleTypes = genericTypeList.toArray(new String[genericTypeList.size()]);
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)3, "-<- Done loading .serverExtensions extension point -<-");
        }
        return list.toArray(new ServerExtensionWrapper[list.size()]);
    }

    public static boolean isValidApplicationType(String appType) {
        if (appType == null) {
            return false;
        }
        for (String s : allApplicationTypes) {
            if (!s.equals(appType)) continue;
            return true;
        }
        return false;
    }

    public ServerExtensionWrapper(IConfigurationElement element) {
        this.configElement = element;
        IConfigurationElement[] ce = element.getChildren(MODULE);
        int size = ce.length;
        this.moduleTypes = new String[size];
        this.applicationTypes = new String[size];
        this.applicationElements = new String[size];
        ArrayList<String> genericModuleList = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            this.moduleTypes[i] = ce[i].getAttribute(TYPE);
            this.applicationTypes[i] = ce[i].getAttribute(APPLICATION_TYPE);
            if (this.applicationTypes[i] != null && this.applicationTypes[i].equals(GENERIC_APP_TYPE)) {
                genericModuleList.add(this.moduleTypes[i]);
            }
            this.applicationElements[i] = ce[i].getAttribute(APPLICATION_ELEMENT);
            if (this.applicationElements[i] == null) continue;
            applicationElementToTypeMap.put(this.applicationElements[i], this.applicationTypes[i]);
        }
        this.genericModuleTypes = new String[genericModuleList.size()];
        genericModuleList.toArray(this.genericModuleTypes);
    }

    public final boolean supportsApplicationType(IModuleType type) {
        if (type == null) {
            return false;
        }
        String typeId = type.getId();
        for (int i = 0; i < this.applicationTypes.length; ++i) {
            if (this.applicationTypes[i] == null || this.applicationTypes[i].isEmpty() || !typeId.equals(this.moduleTypes[i])) continue;
            return true;
        }
        return false;
    }

    public static final boolean isGenericApplicationType(IModuleType type) {
        if (type == null) {
            return false;
        }
        String id = type.getId();
        for (String s : allGenericModuleTypes) {
            if (!s.equals(id)) continue;
            return true;
        }
        return false;
    }

    protected String[] getRootModuleTypes() {
        int size = this.moduleTypes.length;
        int count = 0;
        for (int i = 0; i < size; ++i) {
            if (this.applicationTypes[i] == null) continue;
            ++count;
        }
        String[] roots = new String[count];
        count = 0;
        for (int i = 0; i < size; ++i) {
            if (this.applicationTypes[i] == null) continue;
            roots[count++] = this.moduleTypes[i];
        }
        return roots;
    }

    public final boolean supports(IModuleType type) {
        for (String s : this.moduleTypes) {
            if (!s.equals(type.getId())) continue;
            return true;
        }
        return false;
    }

    protected void initServer(WebSphereServer server) {
        this.server = server;
    }

    protected WebSphereServerInfo getWebSphereServerInfo() {
        return this.server.getServerInfo();
    }

    protected WebSphereServer getWebSphereServer() {
        return this.server;
    }

    protected void initServerBehaviour(WebSphereServerBehaviour servBehaviour) {
        this.servBehaviour = servBehaviour;
    }

    protected WebSphereServerBehaviour getWebSphereServerBehaviour() {
        return this.servBehaviour;
    }

    private ServerExtension getDelegate() {
        if (this.delegate == null) {
            try {
                this.delegate = (ServerExtension)this.configElement.createExecutableExtension("class");
                this.delegate.init(this);
            }
            catch (Throwable t) {
                Trace.logError("Could not create delegate", t);
                this.delegate = new ServerExtension(){

                    @Override
                    public IModule[] getRootModules(IModule module) throws CoreException {
                        return null;
                    }

                    @Override
                    public IModule[] getChildModules(IModule[] module) {
                        return null;
                    }
                };
            }
        }
        return this.delegate;
    }

    public ApplicationPublisher getPublishDelegate() {
        if (this.publishDelegate == null) {
            try {
                this.publishDelegate = (ApplicationPublisher)this.configElement.createExecutableExtension("publishClass");
                this.publishDelegate.init(this);
            }
            catch (Throwable t) {
                Trace.logError("Could not create delegate", t);
                this.publishDelegate = new ApplicationPublisher(){

                    @Override
                    public IStatus publishModule(int kind, PublishUnit module, IProgressMonitor monitor) {
                        return null;
                    }

                    @Override
                    protected String getModuleDeployName(IModule module) {
                        return null;
                    }
                };
                this.publishDelegate.init(this);
            }
        }
        return this.publishDelegate;
    }

    public boolean isPublishRequired(IModule[] modules, IResourceDelta delta) {
        try {
            return this.getDelegate().isPublishRequired(modules, delta);
        }
        catch (Throwable t) {
            Trace.logError("Error calling server extension", t);
            return true;
        }
    }

    public IModule[] getChildModules(IModule[] module) {
        try {
            return this.getDelegate().getChildModules(module);
        }
        catch (Throwable t) {
            Trace.logError("Error calling server extension", t);
            return null;
        }
    }

    public IModule[] getRootModules(IModule module) throws CoreException {
        try {
            return this.getDelegate().getRootModules(module);
        }
        catch (CoreException ce) {
            throw ce;
        }
        catch (Throwable t) {
            Trace.logError("Error calling server extension", t);
            return null;
        }
    }

    public IStatus canAddModule(IModule module) {
        try {
            return this.getDelegate().canAddModule(module);
        }
        catch (Throwable t) {
            Trace.logError("Error calling server extension", t);
            return new Status(4, "com.ibm.ws.st.core", null, t);
        }
    }

    public boolean modifyModules(IModule[] add, IModule[] remove, IProgressMonitor monitor) {
        try {
            return this.getDelegate().modifyModules(add, remove, monitor);
        }
        catch (Throwable t) {
            Trace.logError("Error calling server extension", t);
            return false;
        }
    }

    public URL getModuleRootURL(IModule module) {
        try {
            return this.getDelegate().getModuleRootURL(module);
        }
        catch (Throwable t) {
            Trace.logError("Error calling server extension", t);
            return null;
        }
    }

    public IStatus publishModule(int kind, PublishUnit module, IProgressMonitor monitor) {
        try {
            return this.getPublishDelegate().publishModule(kind, module, monitor);
        }
        catch (Throwable t) {
            Trace.logError("Error calling server extension", t);
            return new Status(4, "com.ibm.ws.st.core", Messages.internalErrorPublishing, t);
        }
    }

    public void prePublishApplication(int kind, PublishUnit unit, MultiStatus status, IProgressMonitor monitor) {
        try {
            this.getPublishDelegate().prePublishApplication(kind, unit, status, monitor);
        }
        catch (Throwable t) {
            Trace.logError("Error calling server extension", t);
            status.add((IStatus)new Status(4, "com.ibm.ws.st.core", Messages.internalErrorPublishing, t));
        }
    }

    public void postPublishApplication(int kind, PublishUnit unit, MultiStatus status, IProgressMonitor monitor) {
        try {
            this.getPublishDelegate().postPublishApplication(kind, unit, status, monitor);
        }
        catch (Throwable t) {
            Trace.logError("Error calling server extension", t);
            status.add((IStatus)new Status(4, "com.ibm.ws.st.core", Messages.internalErrorPublishing, t));
        }
    }

    public void publishModuleAndChildren(int kind, PublishUnit unit, MultiStatus status, IProgressMonitor monitor) {
        try {
            this.getPublishDelegate().publishModuleAndChildren(kind, unit, status, monitor);
        }
        catch (Throwable t) {
            Trace.logError("Error calling server extension", t);
            status.add((IStatus)new Status(4, "com.ibm.ws.st.core", Messages.internalErrorPublishing, t));
        }
    }

    public boolean needToActOnLooseConfigModeChange(PublishUnit pu) {
        try {
            return this.getPublishDelegate().needToActOnLooseConfigModeChange(pu);
        }
        catch (Throwable t) {
            Trace.logError("Error calling server extension", t);
            return false;
        }
    }

    public void setIsLooseConfig(boolean isLooseConfig) {
        try {
            this.getPublishDelegate().setIsLooseConfig(isLooseConfig);
        }
        catch (Throwable t) {
            Trace.logError("Error while trying to set loose config setting.", t);
        }
    }

    public void handleLooseConfigModeChange(int kind, PublishUnit unit, MultiStatus status, IProgressMonitor monitor) {
        try {
            this.getPublishDelegate().handleLooseConfigModeChange(kind, unit, status, monitor);
        }
        catch (Throwable t) {
            Trace.logError("Error calling server extension", t);
            status.add((IStatus)new Status(4, "com.ibm.ws.st.core", Messages.internalErrorPublishing, t));
        }
    }

    public boolean requireConsoleOutputBeforePublishComplete(int kind, PublishUnit unit, MultiStatus status, IProgressMonitor monitor) {
        try {
            return this.getPublishDelegate().requireConsoleOutputBeforePublishComplete(kind, unit, status, monitor);
        }
        catch (Throwable t) {
            Trace.logError("Error calling server extension", t);
            return false;
        }
    }

    public boolean canRestartModule(IModule[] module) {
        if (module == null || module.length == 0) {
            return false;
        }
        try {
            return this.getDelegate().canRestartModule(module);
        }
        catch (Throwable t) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Exception in canRestartModule() for " + module[0].getName(), t);
            }
            return false;
        }
    }

    public OutOfSyncModuleInfo checkModuleConfigOutOfSync(IModule module) {
        try {
            return this.getDelegate().checkModuleConfigOutOfSync(module);
        }
        catch (Throwable t) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Exception in checkModuleConfigOutOfSync() for " + module.getName(), t);
            }
            return null;
        }
    }

    public String toString() {
        return "ServerExtensionWrapper [" + this.getClass().toString() + "]";
    }

    public static String[] getAllApplicationElements() {
        if (allApplicationElements == null) {
            ServerExtensionWrapper.createServerExtensions();
        }
        String[] r = new String[allApplicationElements.length];
        System.arraycopy(allApplicationElements, 0, r, 0, allApplicationElements.length);
        return r;
    }

    public static String getAppTypeFromAppElement(String label) {
        return applicationElementToTypeMap.get(label);
    }

    public JMXConnection getJmxConnection() {
        return this.jmxConnection;
    }

    protected void setJmxConnection(JMXConnection jmxConnection) {
        this.jmxConnection = jmxConnection;
    }

    static {
        applicationElementToTypeMap = new HashMap(6);
    }
}

