/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.UtilityLaunchFactory;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;

public class LibertySSLCreateCertificationUtility {
    public ILaunch createSSLCertificate(WebSphereRuntime websphereRuntime, WebSphereServerInfo serverInfo, String password, String passwordEncoding, String passwordKey, int validity, String subject, String includeFileName, IProgressMonitor monitor) throws CoreException {
        IProgressMonitor monitor2 = monitor;
        if (monitor2 == null) {
            monitor2 = new NullProgressMonitor();
        }
        websphereRuntime.verifyServerExists(serverInfo);
        String serverName = serverInfo.getServerName();
        monitor2.beginTask(NLS.bind((String)Messages.taskCreateSSLCertificate, (Object)serverName), 200);
        WebSphereServer wsServer = WebSphereUtil.getWebSphereServer(serverInfo);
        if (wsServer == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Could not find server");
            }
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", Messages.errorPromptServerNotFound));
        }
        try {
            ILaunchConfiguration lc = null;
            if (wsServer.isLocalSetup()) {
                ArrayList<String> command = new ArrayList<String>();
                command.add("securityUtility");
                command.add("createSSLCertificate");
                command.add("--server=" + serverInfo.getServerName());
                command.add("--password=" + password);
                if (!websphereRuntime.getRuntimeVersion().startsWith("8.5.0")) {
                    if (passwordEncoding != null && !passwordEncoding.isEmpty()) {
                        command.add("--passwordEncoding=" + passwordEncoding);
                    }
                    if (passwordKey != null && !passwordKey.isEmpty()) {
                        command.add("--passwordKey=" + passwordKey);
                    }
                }
                if (WebSphereUtil.isGreaterOrEqualVersion("8.5.5.2", websphereRuntime.getRuntimeVersion()) && includeFileName != null) {
                    command.add("--createConfigFile=" + includeFileName);
                }
                if (validity >= 0) {
                    command.add("--validity=" + validity);
                }
                if (subject != null) {
                    command.add("--subject=" + subject);
                }
                lc = websphereRuntime.createUtilityLaunchConfig(UtilityLaunchFactory.getLaunchConfigurationType(wsServer.getServerType()), serverInfo, null, command.toArray(new String[command.size()]));
            } else {
                HashMap<String, String> commandVariables = new HashMap<String, String>();
                commandVariables.put("utilityType", "createSSLCertificate");
                commandVariables.put("--password=", password);
                if (!websphereRuntime.getRuntimeVersion().startsWith("8.5.0")) {
                    if (passwordEncoding != null && !passwordEncoding.isEmpty()) {
                        commandVariables.put("--passwordEncoding=", passwordEncoding);
                    }
                    if (passwordKey != null && !passwordKey.isEmpty()) {
                        commandVariables.put("--passwordKey=", passwordKey);
                    }
                }
                if (WebSphereUtil.isGreaterOrEqualVersion("8.5.5.2", websphereRuntime.getRuntimeVersion()) && includeFileName != null) {
                    commandVariables.put("--createConfigFile=", includeFileName);
                }
                if (validity >= 0) {
                    commandVariables.put("--validity=", Integer.toString(validity));
                }
                if (subject != null) {
                    commandVariables.put("--subject=", subject);
                }
                lc = websphereRuntime.createRemoteUtilityLaunchConfig(UtilityLaunchFactory.getLaunchConfigurationType(wsServer.getServerType()), serverInfo, commandVariables);
            }
            ILaunch iLaunch = lc.launch("run", monitor2);
            return iLaunch;
        }
        catch (Throwable t) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", NLS.bind((String)Messages.errorCreateSSLCertificate, (Object)t.getLocalizedMessage())));
        }
        finally {
            monitor2.done();
        }
    }
}

