/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.AbstractMonitorThread;
import com.ibm.ws.st.core.internal.ApplicationNotificationListener;
import com.ibm.ws.st.core.internal.LaunchUtil;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereServerBehaviour;
import com.ibm.ws.st.core.internal.jmx.JMXConnection;
import com.ibm.ws.st.core.internal.launch.ConsoleStreamsProxy;
import com.ibm.ws.st.core.internal.launch.ExternalProcess;
import com.ibm.ws.st.core.internal.launch.WebSphereLaunchConfigurationDelegate;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.openmbean.CompositeData;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServerWorkingCopy;

public class JMXMonitorThread
extends AbstractMonitorThread {
    private JMXConnection jmxConnection;
    private boolean resetJMXConnection = false;
    Map<ApplicationNotificationListener, Boolean> appListenersMap = new ConcurrentHashMap<ApplicationNotificationListener, Boolean>();

    public JMXMonitorThread(WebSphereServerBehaviour wsBehaviour, Object serverStateSyncObj, String name) {
        super(wsBehaviour, serverStateSyncObj, name);
        this.initRegistrations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRegistrations() {
        IModule[] modules = this.wsBehaviour.getServer().getModules();
        Map<ApplicationNotificationListener, Boolean> map = this.appListenersMap;
        synchronized (map) {
            for (IModule module : modules) {
                this.appListenersMap.put(new ApplicationNotificationListener(module.getName(), this.wsBehaviour), Boolean.FALSE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.stopMonitor) {
            int serverState3;
            Object object;
            if (this.resetJMXConnection) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)8, "Resetting JMX connection");
                }
                if (this.jmxConnection != null) {
                    try {
                        this.jmxConnection.disconnect();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.jmxConnection = null;
                this.resetJMXConnection = false;
            }
            if (this.jmxConnection == null) {
                try {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)8, "Creating JMX connection");
                    }
                    this.jmxConnection = this.wsServer.createJMXConnection();
                    this.resetRegistrations();
                }
                catch (Exception e) {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)8, "Could not create JMX Connection: " + e.getLocalizedMessage());
                    }
                    object = this.serverStateSyncObj;
                    synchronized (object) {
                        serverState3 = this.server.getServerState();
                        if (serverState3 != 4 && serverState3 != 1) {
                            if (Trace.ENABLED) {
                                Trace.trace((byte)8, "Changing server state to STOPPED");
                            }
                            this.stoppedServerCleanup();
                        }
                    }
                }
            }
            if (this.jmxConnection != null) {
                try {
                    try {
                        this.connectAndRegisterAppListeners();
                        if (Trace.ENABLED) {
                            Trace.trace((byte)8, "Reusing existing JMX connection");
                        }
                    }
                    catch (Exception e) {
                        this.wsBehaviour.clearRemoteConfigVarMap();
                        if (Trace.ENABLED) {
                            Trace.trace((byte)8, "Attempting reconnect");
                        }
                        this.unregisterAppListeners();
                        this.jmxConnection.disconnect();
                        this.jmxConnection.connect();
                    }
                    String launchMode = this.server.getMode();
                    int serverState2 = this.server.getServerState();
                    if (serverState2 != 3 && serverState2 != 2) {
                        Object serverState3 = this.serverStateSyncObj;
                        synchronized (serverState3) {
                            block51: {
                                if (Trace.ENABLED) {
                                    Trace.trace((byte)8, "Changing server state to STARTED");
                                }
                                this.wsBehaviour.setServerStateImpl(2);
                                if (!"run".equals(launchMode)) {
                                    this.wsBehaviour.setInternalMode("run");
                                }
                                try {
                                    IServerWorkingCopy serverWorkingCopy = this.server.createWorkingCopy();
                                    boolean stopOnShutDown = serverWorkingCopy.getAttribute("stopOnShutdown", true);
                                    if (stopOnShutDown) {
                                        serverWorkingCopy.setAttribute("stopOnShutdown", false);
                                        serverWorkingCopy.save(true, (IProgressMonitor)new NullProgressMonitor());
                                    }
                                }
                                catch (Exception e) {
                                    if (!Trace.ENABLED) break block51;
                                    Trace.trace((byte)8, "Attempting to change the state of the option to stop server on shutdown.", e);
                                }
                            }
                        }
                        JMXConnection jmx = this.wsServer.createJMXConnection();
                        CompositeData metadata = (CompositeData)jmx.getMetadata("${server.config.dir}", "a");
                        String serverConfigDir = (String)metadata.get("fileName");
                        serverConfigDir = serverConfigDir.replace("\\", "/");
                        String serverName = serverConfigDir.substring(serverConfigDir.lastIndexOf(47) + 1, serverConfigDir.length());
                        IPath remoteUsrMetadataPath = this.wsServer.getWebSphereRuntime().getRemoteUsrMetadataPath().append("servers").append(serverName);
                        ILaunch launch = this.server.getLaunch();
                        if (launch == null) {
                            if (Trace.ENABLED) {
                                Trace.trace((byte)8, "JMX MONITOR THREAD -> LAUNCHIT");
                            }
                            WebSphereLaunchConfigurationDelegate.launchIt(launchMode, this.wsBehaviour);
                        }
                        int timeout = 0;
                        int MAX = 20;
                        while (launch == null && timeout++ < MAX) {
                            if (Trace.ENABLED) {
                                Trace.trace((byte)8, "Waiting for launch");
                            }
                            launch = this.server.getLaunch();
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e2) {
                                timeout = MAX;
                            }
                        }
                        if (launch != null) {
                            IPath consoleLog = remoteUsrMetadataPath.append("logs").append("console.log");
                            boolean isUseConsoleLog = this.isUseConsoleLogToMonitor(jmx);
                            ConsoleStreamsProxy streamsProxy = new ConsoleStreamsProxy(consoleLog.toFile(), isUseConsoleLog, jmx);
                            ExternalProcess curProcess = new ExternalProcess(launch, this.server, streamsProxy);
                            curProcess.setAttribute(IProcess.ATTR_PROCESS_LABEL, LaunchUtil.getProcessLabelAttr(this.server.getName(), this.wsServer.getServerName()));
                            curProcess.setAttribute(IProcess.ATTR_PROCESS_TYPE, "java");
                            launch.addProcess((IProcess)curProcess);
                            DebugPlugin.getDefault().getLaunchManager().addLaunch(launch);
                            this.wsBehaviour.setLaunch(launch);
                        } else {
                            Trace.logError("Failed to create server launch.", null);
                        }
                    }
                    this.detectAndSetServerMode(this.jmxConnection);
                }
                catch (Exception e) {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)8, "Could not refresh JMX Connection: " + e);
                    }
                    object = this.serverStateSyncObj;
                    synchronized (object) {
                        serverState3 = this.server.getServerState();
                        String launchMode = this.server.getMode();
                        if (serverState3 != 1 && serverState3 != 4) {
                            if (Trace.ENABLED) {
                                Trace.trace((byte)8, "Changing server state to STOPPED");
                            }
                            this.stoppedServerCleanup();
                            if (launchMode != "run") {
                                this.wsBehaviour.setInternalMode("run");
                            }
                        }
                    }
                }
            } else if (Trace.ENABLED) {
                Trace.trace((byte)8, "JMX connection is NULL");
            }
            try {
                Thread.sleep(POLLING_DELAY);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void stoppedServerCleanup() {
        block3: {
            try {
                ILaunch launch = this.server.getLaunch();
                if (launch != null && launch.canTerminate()) {
                    launch.terminate();
                }
                this.wsBehaviour.stopImpl();
            }
            catch (Exception e) {
                if (!Trace.ENABLED) break block3;
                Trace.trace((byte)8, "Stopped server cleanup encountered problems: " + e.getLocalizedMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAppListenerOnPublish(String appName, WebSphereServerBehaviour wsBehaviour, IProgressMonitor monitor) {
        if (appName == null || monitor == null || monitor.isCanceled()) {
            return;
        }
        Map<ApplicationNotificationListener, Boolean> map = this.appListenersMap;
        synchronized (map) {
            boolean isRegistered;
            ApplicationNotificationListener listener;
            block15: {
                listener = new ApplicationNotificationListener(appName, wsBehaviour);
                isRegistered = false;
                if (this.jmxConnection != null) {
                    try {
                        while (!this.jmxConnection.getAllApplicationNames().contains(appName) && !monitor.isCanceled()) {
                            if (Trace.ENABLED) {
                                Trace.trace((byte)8, "Waiting for application MBean to be created...");
                            }
                            Thread.sleep(250L);
                        }
                        if (monitor.isCanceled()) break block15;
                        this.jmxConnection.addAppListener(listener);
                        isRegistered = true;
                        if (Trace.ENABLED) {
                            Trace.trace((byte)8, "Checking application state for " + listener.getAppName());
                        }
                        String state = this.jmxConnection.getAppState(listener.getAppName());
                        long timeout = System.currentTimeMillis() + 5000L;
                        while (System.currentTimeMillis() < timeout && (state == null || state.equals("STOPPED"))) {
                            if (Trace.ENABLED) {
                                Trace.trace((byte)8, "Waiting for application state update for " + listener.getAppName());
                            }
                            try {
                                Thread.sleep(500L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            state = this.jmxConnection.getAppState(listener.getAppName());
                        }
                        listener.handleState("STARTING", state != null ? state : "UNKNOWN");
                        if (Trace.ENABLED) {
                            Trace.trace((byte)8, "Registered listener for application: " + appName);
                        }
                    }
                    catch (Exception e) {
                        Trace.logError("Couldn't register application notification listener for application: " + listener.getAppName(), e);
                    }
                }
            }
            this.appListenersMap.put(listener, isRegistered);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAppListener(String appName) {
        if (appName == null) {
            return;
        }
        Map<ApplicationNotificationListener, Boolean> map = this.appListenersMap;
        synchronized (map) {
            boolean found = false;
            Set<ApplicationNotificationListener> listeners = this.appListenersMap.keySet();
            Iterator<ApplicationNotificationListener> itr = listeners.iterator();
            while (!found && itr.hasNext()) {
                ApplicationNotificationListener listener;
                block7: {
                    listener = itr.next();
                    if (!listener.getAppName().equals(appName)) continue;
                    found = true;
                    try {
                        this.jmxConnection.removeAppListener(listener);
                    }
                    catch (Exception e) {
                        if (!Trace.ENABLED) break block7;
                        Trace.trace((byte)1, "Couldn't unregister application notification listener for app: " + listener.getAppName() + ".  The application may have already been stopped by the runtime.", e);
                    }
                }
                this.appListenersMap.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectAndRegisterAppListeners() throws Exception {
        List<String> apps = this.jmxConnection.getAllApplicationNames();
        Map<ApplicationNotificationListener, Boolean> map = this.appListenersMap;
        synchronized (map) {
            for (ApplicationNotificationListener listener : this.appListenersMap.keySet()) {
                try {
                    if (!this.appListenersMap.get(listener).equals(Boolean.FALSE)) continue;
                    if (apps.contains(listener.getAppName())) {
                        this.jmxConnection.addAppListener(listener);
                        this.appListenersMap.put(listener, Boolean.TRUE);
                        String state = this.jmxConnection.getAppState(listener.getAppName());
                        if (state == null) continue;
                        listener.handleState("UNKNOWN", state);
                        continue;
                    }
                    if (!Trace.ENABLED) continue;
                    Trace.trace((byte)8, "Failed to register application listener because no ApplicationMBean instance found for app: " + listener.getAppName());
                }
                catch (Exception e) {
                    if (!Trace.ENABLED) continue;
                    Trace.trace((byte)8, "Failed to register application listener for app: " + listener.getAppName(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetRegistrations() {
        Map<ApplicationNotificationListener, Boolean> map = this.appListenersMap;
        synchronized (map) {
            for (ApplicationNotificationListener listener : this.appListenersMap.keySet()) {
                this.appListenersMap.put(listener, Boolean.FALSE);
            }
        }
    }

    private void unregisterAppListeners() {
        for (ApplicationNotificationListener listener : this.appListenersMap.keySet()) {
            try {
                this.jmxConnection.removeAppListener(listener);
            }
            catch (Exception e) {
                if (!Trace.ENABLED) continue;
                Trace.trace((byte)8, "Failed to unregister application listener for app: " + listener.getAppName());
            }
        }
        this.resetRegistrations();
    }

    public void resetJMX() {
        if (Trace.ENABLED) {
            Trace.trace((byte)8, "Reset JMX connection");
        }
        this.resetJMXConnection = true;
    }

    private boolean isUseConsoleLogToMonitor(JMXConnection jmxConnection) {
        if (jmxConnection == null) {
            return false;
        }
        try {
            CompositeData metadata = (CompositeData)jmxConnection.getMetadata("${com.ibm.ws.logging.log.directory}/console.log", "t");
            if (metadata == null) {
                return false;
            }
            Date consoleLastModified = (Date)metadata.get("lastModified");
            metadata = (CompositeData)jmxConnection.getMetadata("${server.output.dir}/workarea/.sLock", "t");
            Date sLockLastModified = (Date)metadata.get("lastModified");
            if (sLockLastModified.getTime() - consoleLastModified.getTime() < 3200L) {
                return true;
            }
        }
        catch (Exception e) {
            Trace.logError("Cannot determine log file status", e);
        }
        return false;
    }
}

