/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.common.core.ext.internal.Activator;
import com.ibm.ws.st.common.core.ext.internal.servertype.AbstractServerBehaviourExtension;
import com.ibm.ws.st.common.core.ext.internal.setuphandlers.PlatformHandlerFactory;
import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerBehaviour;
import com.ibm.ws.st.core.internal.jmx.JMXConnection;
import com.ibm.ws.st.core.internal.launch.ExternalProcess;
import com.ibm.ws.st.core.internal.launch.LibertyRemoteUtilityExecutionDelegate;
import com.ibm.ws.st.core.internal.launch.RemoteStopServer;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;

public class BaseLibertyBehaviourExtension
extends AbstractServerBehaviourExtension {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(ServerBehaviourDelegate behaviour, boolean force, IProgressMonitor monitor) {
        WebSphereServerBehaviour websphereBehaviour = (WebSphereServerBehaviour)((Object)behaviour.getServer().loadAdapter(WebSphereServerBehaviour.class, (IProgressMonitor)new NullProgressMonitor()));
        if (websphereBehaviour == null || websphereBehaviour.getServer().getServerState() == 4) {
            return;
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)0, "Stopping the server");
        }
        websphereBehaviour.setServerAndModuleState(3);
        boolean terminate = force;
        WebSphereServer wsServer = websphereBehaviour.getWebSphereServer();
        websphereBehaviour.terminateDebugTarget();
        if (wsServer.isLocalSetup()) {
            ILaunch launch;
            if (wsServer.isFeatureConfigured("localConnector-1.0")) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)0, "Use JMX to stop the server.");
                }
                JMXConnection jmxConnection = null;
                try {
                    jmxConnection = wsServer.createJMXConnection();
                    jmxConnection.stop();
                }
                catch (Exception e) {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)1, "Could not use JMX to stop the server", e);
                    }
                    terminate = !this.stopServerWithServerCmd(websphereBehaviour);
                }
                finally {
                    if (jmxConnection != null) {
                        jmxConnection.disconnect();
                    }
                }
            } else {
                boolean bl = terminate = !this.stopServerWithServerCmd(websphereBehaviour);
            }
            if (terminate) {
                websphereBehaviour.terminateProcess();
            }
            if ((launch = websphereBehaviour.getServer().getLaunch()) != null) {
                for (IProcess process : launch.getProcesses()) {
                    try {
                        if (!(process instanceof ExternalProcess)) continue;
                        ((ExternalProcess)process).closeStreams();
                    }
                    catch (Throwable t) {
                        if (!Trace.ENABLED) continue;
                        Trace.trace((byte)1, "The process terminate encountered a problem", t);
                    }
                }
            }
        } else {
            websphereBehaviour.stopMonitorThread();
            if (terminate && websphereBehaviour.getWebSphereServer().getIsRemoteServerStartEnabled()) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)0, "Stopping the remote server via Remote Execution Utility");
                }
                Object launch = websphereBehaviour.serverStateSyncObj;
                synchronized (launch) {
                    block34: {
                        try {
                            String launchMode = "run";
                            ILaunch launch2 = websphereBehaviour.getServer().getLaunch();
                            RemoteStopServer remoteLauncher = new RemoteStopServer(websphereBehaviour.getServer().getStopTimeout() * 1000, new LibertyRemoteUtilityExecutionDelegate());
                            remoteLauncher.execute(websphereBehaviour.getWebSphereServer(), launchMode, launch2, null);
                        }
                        catch (Exception e) {
                            if (!Trace.ENABLED) break block34;
                            Trace.logError("Problem encountered while stopping server", e);
                        }
                    }
                }
            }
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Stopping the remote server via JMX");
            }
            JMXConnection jmxConnection = null;
            try {
                jmxConnection = wsServer.createJMXConnection();
                jmxConnection.stop();
            }
            catch (Exception e) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)1, "Could not use JMX to stop the server", e);
                }
            }
            finally {
                if (jmxConnection != null) {
                    jmxConnection.disconnect();
                }
            }
            websphereBehaviour.startMonitorThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stopServerWithServerCmd(WebSphereServerBehaviour behaviour) {
        if (Trace.ENABLED) {
            Trace.trace((byte)0, "Use server command to stop the server.");
        }
        try {
            ProcessBuilder pb = behaviour.getWebSphereRuntime().createProcessBuilder("stop", behaviour.getWebSphereServerInfo(), new String[0]);
            Object object = behaviour.syncObj1;
            synchronized (object) {
                behaviour.serverCmdStopProcess = pb.start();
            }
        }
        catch (IOException ie) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Could not launch stop server: " + ie.getMessage());
            }
            return false;
        }
        return true;
    }

    public IStatus canStop(ServerBehaviourDelegate behaviour) {
        WebSphereServerBehaviour websphereBehaviour = (WebSphereServerBehaviour)((Object)behaviour.getServer().loadAdapter(WebSphereServerBehaviour.class, (IProgressMonitor)new NullProgressMonitor()));
        if (websphereBehaviour != null && !websphereBehaviour.getWebSphereServer().isLocalSetup()) {
            if (Activator.getPlatformProvider((String)PlatformHandlerFactory.PlatformType.SSH_KEYLESS.name()) == null) {
                return new Status(4, "com.ibm.ws.st.core", Messages.errorPromptRemoteServerActionsUnavailable);
            }
            if (!websphereBehaviour.getWebSphereServer().getIsRemoteServerStartEnabled()) {
                return new Status(4, "com.ibm.ws.st.core", Messages.errorPromptRemoteServerSettingsDisabled);
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus canRestart(ServerBehaviourDelegate behaviour) {
        WebSphereServerBehaviour websphereBehaviour = (WebSphereServerBehaviour)((Object)behaviour.getServer().loadAdapter(WebSphereServerBehaviour.class, (IProgressMonitor)new NullProgressMonitor()));
        if (websphereBehaviour != null && !websphereBehaviour.getWebSphereServer().isLocalSetup()) {
            if (Activator.getPlatformProvider((String)PlatformHandlerFactory.PlatformType.SSH_KEYLESS.name()) == null) {
                return new Status(4, "com.ibm.ws.st.core", Messages.errorPromptRemoteServerActionsUnavailable);
            }
            if (!websphereBehaviour.getWebSphereServer().getIsRemoteServerStartEnabled()) {
                return new Status(4, "com.ibm.ws.st.core", Messages.errorPromptRemoteServerSettingsDisabled);
            }
        }
        return Status.OK_STATUS;
    }
}

