/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.security;

import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.security.LibertyX509CertPathValidator;
import com.ibm.ws.st.core.internal.security.LibertyX509CertPathValidatorResult;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;

public class LibertyX509CertPathValidatorRegistry {
    private static LibertyX509CertPathValidatorRegistry instance_;
    private static final String XP_ID = "com.ibm.ws.st.core.libertyX509CertPathValidator";
    private static final String X_ATTR_CLASS = "class";
    private static final String X_ATTR_AUTONOMOUS = "autonomous";
    private List<Entry> autonomousValidators_ = null;
    private List<Entry> interactiveValidators_ = null;
    private int numberOfValidators = 0;

    private LibertyX509CertPathValidatorRegistry() {
    }

    public static LibertyX509CertPathValidatorRegistry instance() {
        if (instance_ == null) {
            instance_ = new LibertyX509CertPathValidatorRegistry();
        }
        return instance_;
    }

    public LibertyX509CertPathValidatorResult[] validate(CertPath certPath, int index, String message, Throwable cause) throws CertificateException {
        if (Trace.ENABLED) {
            Trace.trace((byte)9, "certPath=[" + certPath + "] index=[" + index + "] message=[" + message + "] cause=[" + cause + "]");
        }
        if (this.autonomousValidators_ == null) {
            IConfigurationElement[] configurationElements;
            this.autonomousValidators_ = new LinkedList<Entry>();
            this.interactiveValidators_ = new LinkedList<Entry>();
            for (IConfigurationElement configurationElement : configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(XP_ID)) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)9, "configurationElement class=[" + configurationElement.getAttribute(X_ATTR_CLASS) + "] autonomous=[" + configurationElement.getAttribute(X_ATTR_AUTONOMOUS) + "]");
                }
                Entry entry = new Entry();
                entry.element = configurationElement;
                String autonomous = configurationElement.getAttribute(X_ATTR_AUTONOMOUS);
                if (autonomous != null && "true".equals(autonomous)) {
                    this.autonomousValidators_.add(entry);
                } else {
                    this.interactiveValidators_.add(entry);
                }
                ++this.numberOfValidators;
            }
        }
        ArrayList<LibertyX509CertPathValidatorResult> results = new ArrayList<LibertyX509CertPathValidatorResult>(this.numberOfValidators);
        this.validate(this.autonomousValidators_, results, certPath, index, message, cause);
        if (results.size() == 0 || ((LibertyX509CertPathValidatorResult)results.get(results.size() - 1)).getStatus() == LibertyX509CertPathValidatorResult.Status.ABSTAINED) {
            this.validate(this.interactiveValidators_, results, certPath, index, message, cause);
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)9, "results=[" + results + "]");
        }
        return results.toArray(new LibertyX509CertPathValidatorResult[0]);
    }

    private void validate(List<Entry> validators, List<LibertyX509CertPathValidatorResult> results, CertPath certPath, int index, String message, Throwable cause) {
        for (Entry entry : validators) {
            String className = entry.element.getAttribute(X_ATTR_CLASS);
            if (className != null) {
                try {
                    Object c = entry.element.createExecutableExtension(X_ATTR_CLASS);
                    if (Trace.ENABLED) {
                        Trace.trace((byte)9, "configurationElement object class=[" + c.getClass().getName() + "]");
                    }
                    if (c instanceof LibertyX509CertPathValidator) {
                        entry.validator = (LibertyX509CertPathValidator)c;
                        LibertyX509CertPathValidatorResult result = entry.validator.validate(certPath, index, message, cause);
                        if (Trace.ENABLED) {
                            Trace.trace((byte)9, "result=[" + result + "]");
                        }
                        if (result == null) continue;
                        results.add(result);
                        if (result.getStatus() == LibertyX509CertPathValidatorResult.Status.ABSTAINED) continue;
                        return;
                    }
                    if (!Trace.ENABLED) continue;
                    Trace.trace((byte)9, NLS.bind((String)Messages.X509_EXTENSION_HAS_WRONG_CLASS, (Object[])new String[]{XP_ID, entry.element.getContributor().getName(), className, LibertyX509CertPathValidator.class.getName()}));
                }
                catch (CoreException e) {
                    Trace.logError(e.getMessage(), e);
                }
                continue;
            }
            if (!Trace.ENABLED) continue;
            Trace.trace((byte)9, NLS.bind((String)Messages.X509_EXTENSION_HAS_NO_CLASS, (Object[])new String[]{XP_ID, entry.element.getContributor().getName(), X_ATTR_CLASS}));
        }
    }

    private static class Entry {
        public IConfigurationElement element = null;
        public LibertyX509CertPathValidator validator = null;
    }
}

