/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.repository;

import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.repository.IRuntimeInfo;
import com.ibm.ws.st.core.internal.repository.ISource;
import com.ibm.ws.st.core.internal.repository.License;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public interface IProduct {
    public static final String PROP_NAME = "name";
    public static final String PROP_DESCRIPTION = "description";
    public static final String PROP_TYPE = "type";
    public static final String PROP_PRODUCT_ID = "productId";
    public static final String PROP_PRODUCT_VERSION = "productVersion";
    public static final String PROP_PRODUCT_INSTALL_TYPE = "productInstallType";
    public static final String PROP_PRODUCT_EDITION = "productEdition";
    public static final String PROP_PRODUCT_LICENSE_TYPE = "licenseType";
    public static final String PROP_APPLIES_TO = "appliesTo";
    public static final String PROP_ON_PREMISE = "onPremise";
    public static final String PROP_DISPLAY_TYPE = "displayType";

    public String getName();

    public String getDescription();

    public Type getType();

    public ProductType getProductType();

    public long getSize();

    public License getLicense(IProgressMonitor var1) throws IOException;

    public String getSiteName();

    public String getAttribute(String var1);

    public List<String> getProvideFeature();

    public List<String> getRequireFeature();

    public IRuntimeInfo getRuntimeInfo();

    public ISource getSource();

    public String getHashSHA256();

    public boolean isInstallOnlyFeature();

    public static enum ProductType {
        MASSIVE_TYPE,
        LOCAL_TYPE;

    }

    public static enum Type {
        INSTALL(Messages.productLabel),
        EXTENDED(Messages.extendedProductLabel),
        FEATURE(Messages.featureLabel),
        SAMPLE(Messages.sampleLabel),
        OPEN_SOURCE(Messages.openSourceLabel),
        CONFIG_SNIPPET(Messages.configSnippetLabel),
        IFIX(Messages.iFixLabel),
        UNKNOWN(null);

        private final String label;

        private Type(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

