/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.launch;

import com.ibm.ws.st.common.core.ext.internal.servertype.AbstractLaunchConfigurationExtension;
import com.ibm.ws.st.common.core.ext.internal.servertype.ServerTypeExtensionFactory;
import com.ibm.ws.st.core.internal.Activator;
import com.ibm.ws.st.core.internal.MissingKeystoreHandler;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerBehaviour;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.config.ConfigUtils;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.core.internal.config.FeatureList;
import com.ibm.ws.st.core.internal.launch.BaseLibertyLaunchConfiguration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerPreferences;
import org.eclipse.wst.server.core.internal.ServerWorkingCopy;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.w3c.dom.Element;

public class WebSphereLaunchConfigurationDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    public static final String INTERNAL_LAUNCH_JOB_FAMILY = "com.ibm.ws.st.core.internalLaunchJobFamily";
    public static final QualifiedName INTERNAL_LAUNCH_SERVER_PROPERTY = new QualifiedName("com.ibm.ws.st.core", "internalLaunchServerProperty");
    protected static final String VM_ERROR_PAGE = "-Dwas4d.error.page=localhost:";
    protected static AbstractLaunchConfigurationExtension defaultLaunchConfiguration = new BaseLibertyLaunchConfiguration();

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
        if (server == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Launch configuration could not find server");
            }
            return;
        }
        WebSphereServer websphereServer = (WebSphereServer)((Object)server.loadAdapter(WebSphereServer.class, null));
        AbstractLaunchConfigurationExtension delegate = ServerTypeExtensionFactory.getServerLaunchOperation((String)websphereServer.getServerType());
        if (delegate == null) {
            delegate = defaultLaunchConfiguration;
        }
        delegate.launch(configuration, mode, launch, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor progressMonitor) throws CoreException {
        boolean b;
        block40: {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)30);
            b = super.finalLaunchCheck(configuration, mode, (IProgressMonitor)monitor.newChild(5));
            try {
                Object jserver;
                IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
                if (server == null) {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)0, "Launch configuration could not find server");
                    }
                    boolean bl = b;
                    return bl;
                }
                if (!ServerPreferences.getInstance().isAutoPublishing()) break block40;
                IJobManager jobManager = Job.getJobManager();
                Job[] jobs = jobManager.find(ServerUtil.SERVER_JOB_FAMILY);
                boolean isInsideJob = false;
                for (Job job : jobs) {
                    if (job instanceof Server.StartJob) {
                        jserver = ((Server.StartJob)job).getServer();
                        if (!this.checkServer(server, (IServer)jserver)) continue;
                        isInsideJob = true;
                        break;
                    }
                    if (!(job instanceof Server.RestartJob) || !this.checkServer(server, (IServer)(jserver = ((Server.RestartJob)job).getServer()))) continue;
                    isInsideJob = true;
                    break;
                }
                if (!isInsideJob) {
                    for (Job job : jobs = jobManager.find((Object)INTERNAL_LAUNCH_JOB_FAMILY)) {
                        jserver = job.getProperty(INTERNAL_LAUNCH_SERVER_PROPERTY);
                        if (!(jserver instanceof IServer) || !this.checkServer(server, (IServer)jserver)) continue;
                        isInsideJob = true;
                        break;
                    }
                }
                if (monitor.isCanceled()) {
                    boolean bl = false;
                    return bl;
                }
                monitor.worked(5);
                final WebSphereServerBehaviour servB = (WebSphereServerBehaviour)((Object)server.getAdapter(WebSphereServerBehaviour.class));
                if (servB == null) {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)1, "finalLaunchCheck(.) behaviour is null");
                    }
                    int n = b ? 1 : 0;
                    return n != 0;
                }
                if (isInsideJob) {
                    if (servB.shouldShownFeaturePromptInLauncher()) {
                        SubMonitor publishMonitor = monitor.newChild(10);
                        Thread promptThread = new Thread((IProgressMonitor)publishMonitor){
                            final /* synthetic */ IProgressMonitor val$publishMonitor;
                            {
                                this.val$publishMonitor = iProgressMonitor;
                            }

                            @Override
                            public void run() {
                                servB.checkPublishedModules(this.val$publishMonitor);
                            }
                        };
                        promptThread.setDaemon(true);
                        promptThread.start();
                        promptThread.join();
                        servB.setShownFeaturePromptInLauncher(true);
                    } else {
                        monitor.worked(10);
                    }
                    if (monitor.isCanceled()) {
                        boolean publishMonitor = false;
                        return publishMonitor;
                    }
                    final WebSphereServerInfo serverInfo = servB.getWebSphereServerInfo();
                    if (serverInfo == null) {
                        boolean promptThread = b;
                        return promptThread;
                    }
                    final ConfigurationFile configFile = serverInfo.getConfigRoot();
                    List<String> allFeatures = configFile.getAllFeatures();
                    List<String> features = Arrays.asList("ssl-1.0", "appSecurity-1.0", "ejbRemote-3.2");
                    if (FeatureList.featuresEnabled(features, allFeatures, serverInfo.getWebSphereRuntime())) {
                        boolean hasNonDefaultSSL = false;
                        List<Element> elements = ConfigUtils.getResolvedElements(configFile.getDocument(), configFile.getURI(), serverInfo, configFile.getUserDirectory(), "sslDefault", null);
                        for (Element element : elements) {
                            String string = element.getAttribute("sslRef");
                            if (string == null || string.isEmpty() || string.equals("defaultSSLConfig")) continue;
                            hasNonDefaultSSL = true;
                            break;
                        }
                        if (!hasNonDefaultSSL) {
                            boolean hasNonDefaultKeystore = false;
                            elements = ConfigUtils.getResolvedElements(configFile.getDocument(), configFile.getURI(), serverInfo, configFile.getUserDirectory(), "ssl", "id");
                            for (Element element : elements) {
                                String keystoreRef;
                                String id = element.getAttribute("id");
                                if (!"defaultSSLConfig".equals(id) || (keystoreRef = element.getAttribute("keyStoreRef")) == null || keystoreRef.isEmpty() || keystoreRef.equals("defaultKeyStore")) continue;
                                hasNonDefaultKeystore = true;
                                break;
                            }
                            if (!hasNonDefaultKeystore) {
                                boolean bl;
                                boolean bl2 = false;
                                elements = ConfigUtils.getResolvedElements(configFile.getDocument(), configFile.getURI(), serverInfo, configFile.getUserDirectory(), "keyStore", "id");
                                for (Element elem : elements) {
                                    String id = elem.getAttribute("id");
                                    String password = elem.getAttribute("password");
                                    if (id != null && !id.isEmpty() && !id.equals("defaultKeyStore") || password == null || password.isEmpty()) continue;
                                    bl = true;
                                    break;
                                }
                                if (!bl) {
                                    SubMonitor subMonitor = monitor.newChild(9);
                                    Thread dialogThread = new Thread((IProgressMonitor)subMonitor){
                                        final /* synthetic */ IProgressMonitor val$configSaveMonitor;
                                        {
                                            this.val$configSaveMonitor = iProgressMonitor;
                                        }

                                        @Override
                                        public void run() {
                                            MissingKeystoreHandler missingKeystoreHandler = Activator.getMissingKeystoreHandler();
                                            if (missingKeystoreHandler != null && missingKeystoreHandler.handleMissingKeystore(serverInfo, true)) {
                                                try {
                                                    configFile.save(this.val$configSaveMonitor);
                                                }
                                                catch (IOException e) {
                                                    Trace.logError("Failed to save the configuration file changes to add missing security elements.", e);
                                                }
                                            }
                                        }
                                    };
                                    dialogThread.setDaemon(true);
                                    dialogThread.start();
                                    dialogThread.join();
                                }
                            }
                        }
                    }
                    monitor.setWorkRemaining(1);
                    monitor.worked(1);
                    boolean bl = b;
                    return bl;
                }
                if (monitor.isCanceled()) {
                    boolean serverInfo = false;
                    return serverInfo;
                }
                ISchedulingRule rule = this.getProjectPublishRule(server, (IProgressMonitor)monitor.newChild(5));
                if (monitor.isCanceled() || rule == null) {
                    boolean configFile = false;
                    return configFile;
                }
                jobManager.beginRule(rule, (IProgressMonitor)monitor.newChild(5));
                IStatus status = null;
                try {
                    status = server.publish(1, (IProgressMonitor)monitor.newChild(10));
                }
                finally {
                    jobManager.endRule(rule);
                }
                if (monitor.isCanceled() || Status.CANCEL_STATUS.equals(status) || status != null && status.getSeverity() == 4) {
                    boolean bl = false;
                    return bl;
                }
            }
            catch (Exception e) {
                Trace.logError("Error launching server", e);
            }
            finally {
                monitor.done();
            }
        }
        return b;
    }

    private boolean checkServer(IServer server, IServer jserver) {
        return jserver instanceof ServerWorkingCopy ? server == ((ServerWorkingCopy)jserver).getOriginal() : server == jserver;
    }

    private ISchedulingRule getProjectPublishRule(IServer server, IProgressMonitor monitor) {
        IModule[] modules = server.getModules();
        ArrayList<IProject> projectList = new ArrayList<IProject>();
        if (modules.length > 0) {
            for (IModule curModule : modules) {
                if (monitor.isCanceled()) {
                    return null;
                }
                this.collectModuleProjects(server, new IModule[]{curModule}, projectList, monitor);
            }
        }
        ISchedulingRule[] publishScheduleRules = new ISchedulingRule[projectList.size() + 1];
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        publishScheduleRules[0] = server;
        int i = 1;
        for (IProject curProj : projectList) {
            publishScheduleRules[i++] = ruleFactory.modifyRule((IResource)curProj);
        }
        ISchedulingRule publishRule = MultiRule.combine((ISchedulingRule[])publishScheduleRules);
        return publishRule;
    }

    private void collectModuleProjects(IServer server, IModule[] module, List<IProject> projectList, IProgressMonitor monitor) {
        IModule[] children;
        if (module == null || module.length == 0 || monitor.isCanceled()) {
            return;
        }
        IProject project = module[module.length - 1].getProject();
        if (project != null && !projectList.contains(project)) {
            projectList.add(project);
        }
        for (IModule m : children = server.getChildModules(module, monitor)) {
            IModule[] module2 = new IModule[module.length + 1];
            System.arraycopy(module, 0, module2, 0, module.length);
            module2[module.length] = m;
            this.collectModuleProjects(server, module2, projectList, monitor);
        }
    }

    public static void launchIt(String launchMode, WebSphereServerBehaviour websphereServerBehaviour) throws CoreException {
        if (websphereServerBehaviour != null) {
            WebSphereServer websphereServer = websphereServerBehaviour.getWebSphereServer();
            AbstractLaunchConfigurationExtension delegate = ServerTypeExtensionFactory.getServerLaunchOperation((String)websphereServer.getServerType());
            if (delegate == null) {
                delegate = defaultLaunchConfiguration;
            }
            delegate.launchStartedServer(launchMode, (ServerBehaviourDelegate)websphereServerBehaviour);
        }
    }
}

