/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.launch;

import com.ibm.ws.st.core.internal.LaunchUtil;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.launch.ConsoleStreamsProxy;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.wst.server.core.IServer;

public class ExternalProcess
extends PlatformObject
implements IProcess {
    private final Map<String, String> attributes = new HashMap<String, String>(3);
    private final ConsoleStreamsProxy streamsProxy;
    private final ILaunch launch;
    private final String name;
    private boolean terminated;
    private final IServer server;

    public ExternalProcess(ILaunch launch, IServer server, ConsoleStreamsProxy streamsProxy) {
        this.launch = launch;
        this.server = server;
        this.streamsProxy = streamsProxy;
        this.setAttribute(IProcess.ATTR_PROCESS_TYPE, "java");
        IPath runtimeLocation = server.getRuntime().getLocation();
        String batch = "server";
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            batch = batch + ".bat";
        }
        batch = runtimeLocation.append("bin").append(batch).toOSString();
        this.name = LaunchUtil.getProcessLabel(batch);
        this.fireCreationEvent();
    }

    private void fireCreationEvent() {
        this.fireEvent(new DebugEvent((Object)this, 4));
    }

    private void fireTerminateEvent() {
        this.fireEvent(new DebugEvent((Object)this, 8));
    }

    private void fireChangeEvent() {
        this.fireEvent(new DebugEvent((Object)this, 16));
    }

    private void fireEvent(DebugEvent event) {
        DebugPlugin manager = DebugPlugin.getDefault();
        if (manager != null) {
            manager.fireDebugEventSet(new DebugEvent[]{event});
        }
    }

    public void terminate() throws DebugException {
        if (this.terminated) {
            return;
        }
        int state = this.server.getServerState();
        WebSphereServer wsServer = (WebSphereServer)((Object)this.server.loadAdapter(WebSphereServer.class, null));
        if (state != 4 && state != 3 && wsServer != null && wsServer.isStopOnShutdown()) {
            this.server.stop(false);
            return;
        }
        this.terminated = true;
        this.closeStreams();
        this.fireTerminateEvent();
    }

    public void closeStreams() {
        this.streamsProxy.update();
        this.streamsProxy.close();
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public boolean canTerminate() {
        return !this.terminated;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IProcess.class)) {
            return this;
        }
        if (adapter.equals(IDebugTarget.class)) {
            ILaunch launch = this.getLaunch();
            IDebugTarget[] targets = launch.getDebugTargets();
            for (int i = 0; i < targets.length; ++i) {
                if (!((Object)((Object)this)).equals(targets[i].getProcess())) continue;
                return targets[i];
            }
            return null;
        }
        if (adapter.equals(ILaunch.class)) {
            return this.getLaunch();
        }
        if (adapter.equals(ILaunchConfiguration.class)) {
            return this.getLaunch().getLaunchConfiguration();
        }
        return super.getAdapter(adapter);
    }

    public void setAttribute(String key, String value) {
        String origVal = this.attributes.get(key);
        if (origVal != null && origVal.equals(value)) {
            return;
        }
        this.attributes.put(key, value);
        this.fireChangeEvent();
    }

    public IStreamsProxy getStreamsProxy() {
        return this.streamsProxy;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public String getLabel() {
        return this.name;
    }

    public int getExitValue() throws DebugException {
        if (!this.terminated) {
            throw new DebugException((IStatus)new Status(4, "com.ibm.ws.st.core", "Process not terminated"));
        }
        return 0;
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }
}

