/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.generation;

import com.ibm.ws.st.common.core.internal.Trace;
import com.ibm.ws.st.core.MetadataProvider;
import com.ibm.ws.st.core.internal.generation.Metadata;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class MetadataProviderManager {
    private static final String EXTENSION_ID = "com.ibm.ws.st.core.metadataProvider";
    private static final String PROVIDER_ELEMENT = "provider";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final MetadataProviderManager metadataProviderManager = new MetadataProviderManager();
    private final List<MetadataProvider> providers = new ArrayList<MetadataProvider>();

    public static URL getDefaultFeatureList() {
        for (MetadataProvider provider : MetadataProviderManager.getInstance().providers) {
            URL featureListURL = provider.getDefaultFeatureList();
            if (featureListURL == null) continue;
            return featureListURL;
        }
        return Metadata.getFallback("featureList.xml");
    }

    public static URL getDefaultSchema() {
        for (MetadataProvider provider : MetadataProviderManager.getInstance().providers) {
            URL schemaURL = provider.getDefaultSchema();
            if (schemaURL == null) continue;
            return schemaURL;
        }
        return Metadata.getFallback("server.xsd");
    }

    private static MetadataProviderManager getInstance() {
        return metadataProviderManager;
    }

    private MetadataProviderManager() {
        IConfigurationElement[] extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        for (int i = 0; i < extensions.length; ++i) {
            IConfigurationElement configurationElement = extensions[i];
            if (!PROVIDER_ELEMENT.equals(configurationElement.getName())) continue;
            try {
                Object object = configurationElement.createExecutableExtension(CLASS_ATTRIBUTE);
                this.providers.add((MetadataProvider)object);
                continue;
            }
            catch (Exception exception) {
                Trace.logError((String)"Error while creating metadata provider extension.", (Throwable)exception);
            }
        }
    }
}

