/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.generation;

import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.config.FeatureList;
import com.ibm.ws.st.core.internal.generation.Feature;
import com.ibm.ws.st.core.internal.generation.FeatureInfoHandler;
import com.ibm.ws.st.core.internal.generation.IMetadataGenerator;
import com.ibm.ws.st.core.internal.generation.Metadata;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public abstract class AbstractFeatureListMetadata
extends Metadata<HashMap<FeatureList.FeatureMapType, HashMap<String, Feature>>> {
    protected AbstractFeatureListMetadata(String target) {
        super(target);
    }

    public abstract HashMap<FeatureList.FeatureMapType, HashMap<String, Feature>> getFallbackPayload();

    public abstract String[] getCommandOptions();

    public HashMap<FeatureList.FeatureMapType, HashMap<String, Feature>> getFeatureListMaps(IMetadataGenerator metadataGen) {
        HashMap map;
        block4: {
            map = null;
            if (metadataGen != null) {
                try {
                    map = (HashMap)this.getGeneratedInfo(metadataGen);
                }
                catch (Throwable t) {
                    if (!Trace.ENABLED) break block4;
                    Trace.trace((byte)1, "Error occurred while getting feature list for " + metadataGen.getGeneratorId(), t);
                }
            }
        }
        if (map == null) {
            map = this.getFallbackPayload();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<FeatureList.FeatureMapType, HashMap<String, Feature>> getPayload(IMetadataGenerator metadataGen) {
        HashMap<FeatureList.FeatureMapType, HashMap<String, Feature>> map = null;
        InputStream is = null;
        try {
            File f = this.getTarget(metadataGen).toFile();
            if (f.exists()) {
                is = new FileInputStream(f);
                map = FeatureInfoHandler.parseFeatureListXML(is);
            } else if (Trace.ENABLED) {
                Trace.trace((byte)1, "Feature list file " + this.getTarget(metadataGen).toOSString() + " does not exist.", null);
            }
        }
        catch (Throwable e) {
            Trace.logError("Error occurred while parsing or retrieving feature list payload for generator: " + metadataGen.getGeneratorId(), e);
        }
        finally {
            block17: {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        if (!Trace.ENABLED) break block17;
                        Trace.trace((byte)1, "Error closing featurelist file", e);
                    }
                }
            }
        }
        if (map == null) {
            map = this.getFallbackPayload();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    HashMap<FeatureList.FeatureMapType, HashMap<String, Feature>> reloadPayload(File file) {
        HashMap<FeatureList.FeatureMapType, HashMap<String, Feature>> map = null;
        if (file.exists()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(file);
                map = FeatureInfoHandler.parseFeatureListXML(is);
            }
            catch (Throwable t) {
                Trace.logError("Error parsing featurelist file: " + file.getAbsolutePath(), t);
            }
            finally {
                block15: {
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException e) {
                            if (!Trace.ENABLED) break block15;
                            Trace.trace((byte)1, "Error closing featurelist file: " + file.getAbsolutePath(), e);
                        }
                    }
                }
            }
        }
        if (map == null) {
            map = this.getFallbackPayload();
        }
        return map;
    }
}

