/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.config;

import com.ibm.ws.st.core.internal.Trace;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ConfigurationSchema {
    protected URL url;

    public ConfigurationSchema(URL url) throws IOException {
        this.url = url;
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws IOException {
        InputStream in = null;
        long time = System.currentTimeMillis();
        try {
            File file = new File(this.url.toURI());
            in = new BufferedInputStream(new FileInputStream(file));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            parser.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException e) throws SAXException {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)1, "Warning while reading configuration schema", e);
                    }
                }

                @Override
                public void fatalError(SAXParseException e) throws SAXException {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)1, "Error while reading configuration schema", e);
                    }
                }

                @Override
                public void error(SAXParseException e) throws SAXException {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)1, "Error while reading configuration schema", e);
                    }
                }
            });
            parser.parse(new InputSource(in));
        }
        catch (IOException e) {
            Trace.logError("Could not load configuration schema from " + this.url, e);
            throw e;
        }
        catch (Exception e) {
            Trace.logError("Could not load configuration schema from " + this.url, e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            if (Trace.ENABLED) {
                Trace.tracePerf("Configuration schema load", time);
            }
        }
    }

    public String toString() {
        return "WAS Configuration Schema [" + this.url + "]";
    }
}

