/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.common.core.ext.internal.Trace;
import com.ibm.ws.st.core.internal.UtilityExtension;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class UtilityExtensionFactory {
    protected static final String UTILITY_EXT = "com.ibm.ws.st.core.utilityExtension";
    protected static final String UTILITY_ELEM = "utility";
    protected static final String TYPE_ATTR = "type";
    protected static final String CLASS_ATTR = "class";
    private static HashMap<String, IConfigurationElement> utilityExtMap = null;

    public static UtilityExtension getExtensionClass(String type) throws CoreException {
        if (utilityExtMap == null) {
            UtilityExtensionFactory.init();
        }
        UtilityExtension returnClass = null;
        IConfigurationElement configClass = utilityExtMap.get(type);
        if (configClass != null) {
            try {
                returnClass = (UtilityExtension)configClass.createExecutableExtension(CLASS_ATTR);
            }
            catch (CoreException e) {
                Trace.logError((String)("Failed to load utility extension class for type: " + type), (Throwable)e);
                throw e;
            }
        }
        return returnClass;
    }

    private static void init() {
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(UTILITY_EXT);
        utilityExtMap = new HashMap();
        for (IConfigurationElement elem : configElements) {
            String utilityType = elem.getAttribute(TYPE_ATTR);
            utilityExtMap.put(utilityType, elem);
        }
    }
}

