/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.Activator;
import com.ibm.ws.st.core.internal.IWebSphereServerListener;
import com.ibm.ws.st.core.internal.ServerListenerUtil;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.config.ConfigUtils;
import com.ibm.ws.st.core.internal.config.SchemaUtil;
import com.ibm.ws.st.core.internal.generation.SchemaMetadata;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.IExternalSchemaLocationProvider;
import org.osgi.framework.Bundle;

public class SchemaLocationProvider
implements IExternalSchemaLocationProvider,
IFacetedProjectListener {
    private static final int CACHE_SIZE = 10;
    private static WebSphereRuntime tempRuntime;
    private static final CacheEntry[] cache;
    private static int count;

    public SchemaLocationProvider() {
        ServerListenerUtil.getInstance().addServerListener(new IWebSphereServerListener(){

            @Override
            public void serverChanged(WebSphereServerInfo server) {
                SchemaLocationProvider.clearCache();
            }

            @Override
            public void runtimeChanged(IRuntime runtime) {
                SchemaLocationProvider.clearCache();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<?, ?> getExternalSchemaLocation(URI uri) {
        if (uri == null) {
            return null;
        }
        CacheEntry[] cacheEntryArray = cache;
        synchronized (cache) {
            GetExternalSchemaLocationImplReturnValue externalSchemaResult;
            for (int i = 0; i < 10; ++i) {
                if (cache[i] == null || !uri.equals(SchemaLocationProvider.cache[i].uri)) continue;
                if (SchemaLocationProvider.cache[i].configSchemaFile != null && !SchemaLocationProvider.cache[i].configSchemaFile.exists()) break;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return SchemaLocationProvider.cache[i].map;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            long time = System.currentTimeMillis();
            try {
                externalSchemaResult = SchemaLocationProvider.getExternalSchemaLocationImpl(uri);
            }
            finally {
                if (Trace.ENABLED) {
                    Trace.tracePerf("Resolve schema", time);
                }
            }
            if (externalSchemaResult != null) {
                CacheEntry ce = new CacheEntry();
                ce.uri = uri;
                ce.map = externalSchemaResult.map;
                ce.configSchemaFile = externalSchemaResult.schemaFile;
                CacheEntry[] cacheEntryArray2 = cache;
                synchronized (cache) {
                    SchemaLocationProvider.cache[SchemaLocationProvider.count] = ce;
                    if (++count == 10) {
                        count = 0;
                    }
                    // ** MonitorExit[var6_9] (shouldn't be in output)
                    return externalSchemaResult.map;
                }
            }
            return null;
        }
    }

    private static File convertLocalUrlToFile(URL url) {
        if (url == null) {
            return null;
        }
        try {
            URI uri = url.toURI();
            if (uri == null) {
                return null;
            }
            String uriPath = uri.getPath();
            if (uriPath == null) {
                return null;
            }
            return new File(uriPath);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private static GetExternalSchemaLocationImplReturnValue getExternalSchemaLocationImpl(URI uri) {
        URL schemaURL;
        IWorkspaceRoot workspaceRoot;
        IFile[] files;
        HashMap<String, String> map = new HashMap<String, String>(2);
        GetExternalSchemaLocationImplReturnValue result = new GetExternalSchemaLocationImplReturnValue();
        URI fileURI = uri;
        if (!URIUtil.isFileURI((URI)fileURI) && (files = (workspaceRoot = ResourcesPlugin.getWorkspace().getRoot()).findFilesForLocationURI(fileURI)).length > 0) {
            fileURI = files[0].getLocation().toFile().toURI();
        }
        if ((schemaURL = SchemaUtil.getSchemaURLNoFallback(fileURI)) != null) {
            map.put("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", schemaURL.toString());
            result.map = map;
            result.schemaFile = SchemaLocationProvider.convertLocalUrlToFile(schemaURL);
            return result;
        }
        if (tempRuntime != null && (schemaURL = tempRuntime.getConfigurationSchemaURL(fileURI)) != null) {
            map.put("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", schemaURL.toString());
            result.map = map;
            result.schemaFile = SchemaLocationProvider.convertLocalUrlToFile(schemaURL);
            return result;
        }
        if (fileURI.toASCIIString().contains("com.ibm.ws.st.core")) {
            try {
                URL url = FileLocator.find((Bundle)Activator.getInstance().getBundle(), (IPath)new Path("server.xsd"), null);
                schemaURL = FileLocator.resolve((URL)url);
            }
            catch (Exception e) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)1, "Could not find schema", e);
                }
                return null;
            }
            map.put("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", schemaURL.toString());
            result.map = map;
            result.schemaFile = SchemaLocationProvider.convertLocalUrlToFile(schemaURL);
            return result;
        }
        if (ConfigUtils.isServerConfigFile(fileURI)) {
            map.put("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", SchemaMetadata.getFallbackSchema().toString());
            result.map = map;
            result.schemaFile = SchemaLocationProvider.convertLocalUrlToFile(SchemaMetadata.getFallbackSchema());
            return result;
        }
        return result;
    }

    protected static void setTempRuntime(WebSphereRuntime runtime) {
        tempRuntime = runtime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        CacheEntry[] cacheEntryArray = cache;
        synchronized (cache) {
            for (int i = 0; i < 10; ++i) {
                SchemaLocationProvider.cache[i] = null;
            }
            count = 0;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public void handleEvent(IFacetedProjectEvent event) {
        if (event.getType() == IFacetedProjectEvent.Type.TARGETED_RUNTIMES_CHANGED) {
            SchemaLocationProvider.clearCache();
        }
    }

    static {
        cache = new CacheEntry[10];
        count = 0;
    }

    protected static class CacheEntry {
        File configSchemaFile;
        URI uri;
        Map<String, String> map;

        protected CacheEntry() {
        }
    }

    private static class GetExternalSchemaLocationImplReturnValue {
        protected Map<String, String> map = null;
        protected File schemaFile = null;

        protected GetExternalSchemaLocationImplReturnValue() {
        }
    }
}

