/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.utility;

import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Trace;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class UtilityMessageHelper {
    private static char[] convtBuf = new char[30];
    private static String[] messages;

    private static void loadMessages() {
        BufferedReader br = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            br = new BufferedReader(new InputStreamReader(((Object)((Object)Activator.getInstance())).getClass().getResourceAsStream("utility/utilityMessages.txt")));
            String s = br.readLine();
            while (s != null) {
                list.add(UtilityMessageHelper.convertUnicode(s));
                s = br.readLine();
            }
        }
        catch (Exception e) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Could not read utility message file", e);
            }
        }
        finally {
            block15: {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (Exception e) {
                    if (!Trace.ENABLED) break block15;
                    Trace.trace((byte)1, "Could not close stream", e);
                }
            }
        }
        messages = list.toArray(new String[list.size()]);
    }

    protected static int[] getPath(String message) {
        block4: {
            try {
                for (int i = 0; i < messages.length; i += 3) {
                    String start = messages[i];
                    String middle = messages[i + 1];
                    String end = messages[i + 2];
                    if (!message.startsWith(start) || !message.endsWith(end)) continue;
                    String s = message.substring(start.length(), message.length() - end.length());
                    if (middle != null && middle.length() > 0) {
                        int ind = s.indexOf(middle);
                        int st = start.length() + ind + middle.length();
                        return new int[]{st, st + s.length() - middle.length() - ind};
                    }
                    return null;
                }
            }
            catch (Exception e) {
                if (!Trace.ENABLED) break block4;
                Trace.trace((byte)1, "Could not determine path", e);
            }
        }
        return null;
    }

    private static String convertUnicode(String s) {
        int len = s.length();
        if (convtBuf.length < len) {
            int newLen = len * 2;
            if (newLen < 0) {
                newLen = Integer.MAX_VALUE;
            }
            convtBuf = new char[newLen];
        }
        char[] out = convtBuf;
        int outLen = 0;
        int off = 0;
        while (off < len) {
            char aChar;
            if ((aChar = s.charAt(off++)) == '\\' && off < len) {
                if ((aChar = s.charAt(off++)) == 'u') {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = s.charAt(off++);
                        switch (aChar) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    static {
        UtilityMessageHelper.loadMessages();
    }
}

