/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.utility;

import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.config.PasswordComponent;
import com.ibm.ws.st.ui.internal.utility.UtilityWizardPage;
import java.io.File;
import java.net.InetAddress;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SSLCertificateWizardPage
extends UtilityWizardPage {
    public static final String SSL_INCLUDE_FILE = "GeneratedSSLInclude.xml";
    protected PasswordComponent passwordComp;
    protected String validity;
    protected String subject;

    public SSLCertificateWizardPage(WebSphereServerInfo server) {
        super(server);
        this.setTitle(Messages.wizSSLCertificateTitle);
        this.setDescription(Messages.wizSSLCertificateDescription);
    }

    @Override
    public void createUtilityControl(Composite comp) {
        Text subjectText;
        Button subjectCheck;
        block2: {
            Map customEncryptionMap = this.wsRuntime != null ? this.wsRuntime.listCustomEncryption() : null;
            this.passwordComp = new PasswordComponent(comp, Messages.keystorePassword, 3, this.server.getWebSphereRuntime(), false, customEncryptionMap);
            this.passwordComp.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    SSLCertificateWizardPage.this.setPageComplete(SSLCertificateWizardPage.this.validate());
                }
            });
            final Button validityCheck = new Button(comp, 32);
            validityCheck.setText(Messages.wizSSLCertificateValidity);
            GridData data = new GridData(1, 0x1000000, false, false);
            data.verticalIndent = 8;
            data.horizontalSpan = 2;
            validityCheck.setLayoutData((Object)data);
            final Text validityText = new Text(comp, 2048);
            data = new GridData(4, 0x1000000, true, false);
            data.verticalIndent = 8;
            validityText.setLayoutData((Object)data);
            validityText.setText("365");
            validityText.setEnabled(false);
            validityText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    SSLCertificateWizardPage.this.validity = validityText.getText();
                    SSLCertificateWizardPage.this.setPageComplete(SSLCertificateWizardPage.this.validate());
                }
            });
            validityCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    validityText.setEnabled(validityCheck.getSelection());
                    SSLCertificateWizardPage.this.validity = validityCheck.getSelection() ? validityText.getText() : null;
                    SSLCertificateWizardPage.this.setPageComplete(SSLCertificateWizardPage.this.validate());
                }
            });
            subjectCheck = new Button(comp, 32);
            subjectCheck.setText(Messages.wizSSLCertificateSubject);
            data = new GridData(1, 0x1000000, false, false);
            data.verticalIndent = 8;
            data.horizontalSpan = 2;
            subjectCheck.setLayoutData((Object)data);
            subjectText = new Text(comp, 2048);
            data = new GridData(4, 0x1000000, true, false);
            data.verticalIndent = 8;
            subjectText.setLayoutData((Object)data);
            try {
                InetAddress addr = InetAddress.getLocalHost();
                String s = "CN=" + addr.getHostName() + ",OU=" + this.server.getServerName() + ",O=ibm,C=us";
                subjectText.setText(s);
            }
            catch (Exception e) {
                if (!Trace.ENABLED) break block2;
                Trace.trace((byte)1, "Could not determine host name", e);
            }
        }
        subjectText.setEnabled(false);
        subjectText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                SSLCertificateWizardPage.this.subject = subjectText.getText();
                SSLCertificateWizardPage.this.setPageComplete(SSLCertificateWizardPage.this.validate());
            }
        });
        subjectCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                subjectText.setEnabled(subjectCheck.getSelection());
                SSLCertificateWizardPage.this.subject = subjectCheck.getSelection() ? subjectText.getText() : null;
                SSLCertificateWizardPage.this.setPageComplete(SSLCertificateWizardPage.this.validate());
            }
        });
        this.passwordComp.setFocus();
    }

    @Override
    protected String getUserMessage() {
        return Messages.wizSSLCertificateMessage;
    }

    @Override
    protected boolean validate() {
        String password = this.passwordComp.getPassword();
        if (password != null && !password.isEmpty() && password.length() < 6) {
            this.setMessage(Messages.errorPassword, 3);
            return false;
        }
        if (this.validity != null && !this.validity.isEmpty()) {
            try {
                if (Integer.parseInt(this.validity) < 365) {
                    this.setMessage(Messages.errorSSLValidity, 3);
                    return false;
                }
            }
            catch (NumberFormatException e) {
                this.setMessage(Messages.errorSSLValidity, 3);
                return false;
            }
        }
        if (this.subject != null && !this.subject.isEmpty() && this.subject.length() < 4) {
            this.setMessage(Messages.errorSSLSubject, 3);
            return false;
        }
        if (password == null || password.isEmpty()) {
            this.setMessage(null, 3);
            return false;
        }
        if (this.validity != null && this.validity.isEmpty()) {
            this.setMessage(null, 3);
            return false;
        }
        if (this.subject != null && this.subject.isEmpty()) {
            this.setMessage(null, 3);
            return false;
        }
        return super.validate();
    }

    @Override
    public boolean preFinish() {
        if (!this.doInclude) {
            return true;
        }
        if (!this.notifyRemoteConfigOverwrite(Messages.wizSSLCertificateTitle)) {
            return false;
        }
        boolean overwrite = true;
        File keyFile = this.configDir.append("resources/security/key.jks").toFile();
        File configFile = this.configDir.append(SSL_INCLUDE_FILE).toFile();
        StringBuilder sb = new StringBuilder();
        if (keyFile.exists()) {
            sb.append(keyFile.getAbsolutePath() + "\n");
        }
        if (configFile.exists()) {
            sb.append(configFile.getAbsolutePath() + "\n");
        }
        if (sb.length() > 0) {
            String existingFiles = sb.toString();
            overwrite = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.wizSSLCertificateTitle, (String)NLS.bind((String)Messages.overwriteExistingFiles, (Object)existingFiles));
            if (this.wsServer != null && this.wsServer.isLocalSetup()) {
                if (!overwrite) {
                    return false;
                }
                if (keyFile.exists() && !keyFile.renameTo(new File(keyFile.getAbsolutePath() + ".tmp"))) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.wizSSLCertificateTitle, (String)NLS.bind((String)Messages.errorBackupFile, (Object)keyFile.getAbsolutePath()));
                    return false;
                }
                if (configFile.exists() && !configFile.renameTo(new File(configFile.getAbsolutePath() + ".tmp"))) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.wizSSLCertificateTitle, (String)NLS.bind((String)Messages.errorBackupFile, (Object)configFile.getAbsolutePath()));
                    return false;
                }
            } else if (!overwrite) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void finish(IProgressMonitor monitor) throws Exception {
        int validityInt = -1;
        File configFile = this.configDir.append(SSL_INCLUDE_FILE).toFile();
        try {
            validityInt = Integer.parseInt(this.validity);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String password = this.passwordComp.getPassword();
        String passwordEncoding = this.passwordComp.getPasswordEncoding();
        String passwordKey = this.passwordComp.getPasswordKey();
        String includeOption = this.doInclude ? SSL_INCLUDE_FILE : null;
        ILaunch launch = this.wsRuntime.createSSLCertificate(this.server, password, passwordEncoding, passwordKey, validityInt, this.subject, includeOption, monitor);
        if (launch == null || monitor.isCanceled()) {
            return;
        }
        if (this.wsServer != null && this.wsServer.isLocalSetup()) {
            while (!launch.isTerminated() && !monitor.isCanceled()) {
                Thread.sleep(500L);
            }
            if (monitor.isCanceled()) {
                return;
            }
            if (this.doInclude) {
                File keyFile = this.configDir.append("resources/security/key.jks").toFile();
                File tempConfig = new File(configFile.getAbsolutePath() + ".tmp");
                File tempKey = new File(keyFile.getAbsolutePath() + ".tmp");
                if (configFile.exists()) {
                    String featureName;
                    boolean includeExists = false;
                    for (ConfigurationFile config : this.serverConfig.getAllIncludedFiles()) {
                        if (!config.getPath().toOSString().equals(this.configDir.append(SSL_INCLUDE_FILE).toOSString())) continue;
                        includeExists = true;
                        break;
                    }
                    if (!includeExists) {
                        this.serverConfig.addInclude(false, SSL_INCLUDE_FILE);
                        this.serverConfig.save(monitor);
                    }
                    if (this.isCustomPasswordEncryption(passwordEncoding) && !this.isFeatureEnabled(featureName = this.getUserFeatureName(passwordEncoding))) {
                        this.enableFeature(Messages.keystorePassword, featureName, monitor);
                        if (this.isFeatureEnabled(featureName)) {
                            this.serverConfig.save(monitor);
                        }
                    }
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openInformation((Shell)SSLCertificateWizardPage.this.getShell(), (String)Messages.wizSSLCertificateTitle, (String)Messages.serverXMLUpdated);
                        }
                    });
                    if (tempKey.exists()) {
                        tempKey.delete();
                    }
                    if (tempConfig.exists()) {
                        tempConfig.delete();
                    }
                } else {
                    if (tempConfig.exists()) {
                        tempConfig.renameTo(configFile);
                    }
                    if (tempKey.exists()) {
                        tempKey.renameTo(keyFile);
                    }
                }
            }
        }
    }
}

