/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.security;

import com.ibm.ws.st.core.internal.Activator;
import com.ibm.ws.st.core.internal.PromptUtil;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.security.LibertyX509CertPathValidatorResult;
import com.ibm.ws.st.ui.internal.security.LibertyX509CertPathValidatorDialog;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class LibertyX509CertPathValidatorRunnable
implements Runnable {
    private final Display display_;
    private final CertPath certPath_;
    private final int index_;
    private final String causeMessage_;
    private final Throwable causeThrowable_;
    private LibertyX509CertPathValidatorResult result_;
    private static final int TRANSIENT = 0;
    private static final int PERSISTENT = 1;
    private static final String HEADLESS_MODE_AUTO_ACCEPT_CERT = "headless.auto.accept.cert";

    public LibertyX509CertPathValidatorRunnable(Display display, CertPath certPath, int index, String causeMessage, Throwable causeThrowable) {
        this.display_ = display;
        this.certPath_ = certPath;
        this.index_ = index;
        this.causeMessage_ = causeMessage;
        this.causeThrowable_ = causeThrowable;
    }

    @Override
    public void run() {
        try {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, (String)("display_=[" + this.display_ + "] certPath_=[" + this.certPath_ + "] index_=[" + this.index_ + "] causeMessage_=[" + this.causeMessage_ + "] causeThrowable_=[" + this.causeThrowable_ + "]"));
            }
            Shell shell = this.getShell();
            LibertyX509CertPathValidatorDialog dialog = new LibertyX509CertPathValidatorDialog(shell, this.certPath_, this.index_, this.causeMessage_, this.causeThrowable_);
            int index = -1;
            if (PromptUtil.isRunningGUIMode() && !LibertyX509CertPathValidatorDialog.isOpen) {
                index = dialog.open();
            } else if (Boolean.parseBoolean(Activator.getPreference((String)HEADLESS_MODE_AUTO_ACCEPT_CERT, (String)"false"))) {
                index = 0;
            }
            LibertyX509CertPathValidatorResult.Status status = LibertyX509CertPathValidatorResult.Status.REJECTED;
            switch (index) {
                case 0: {
                    status = LibertyX509CertPathValidatorResult.Status.VALID_FOR_SESSION;
                    break;
                }
                case 1: {
                    status = LibertyX509CertPathValidatorResult.Status.VALID_FOR_WORKSPACE;
                }
            }
            List<? extends Certificate> certificates = this.certPath_.getCertificates();
            int size = certificates.size();
            Certificate certificate = this.certPath_.getCertificates().get(this.index_ < 0 || this.index_ >= size ? size - 1 : this.index_);
            this.result_ = new LibertyX509CertPathValidatorResult(certificate, status);
        }
        catch (Throwable t) {
            Trace.logError((String)t.getMessage(), (Throwable)t);
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)0, (String)("result_=[" + this.result_ + "]"));
        }
    }

    public LibertyX509CertPathValidatorResult result() {
        return this.result_;
    }

    private Shell getShell() {
        Shell shell = this.display_.getActiveShell();
        if (shell == null) {
            Shell[] shells;
            for (Shell sh : shells = this.display_.getShells()) {
                if (sh == null) continue;
                return sh;
            }
        } else {
            return shell;
        }
        return new Shell(this.display_);
    }
}

