/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.marker;

import com.ibm.ws.st.core.internal.FeatureSet;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.core.internal.config.FeatureList;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.SWTUtil;
import com.ibm.ws.st.ui.internal.config.FeatureUI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class SupersedeFeatureDialog
extends TitleAreaDialog {
    protected WebSphereRuntime wsRuntime;
    protected WebSphereServerInfo serverInfo;
    protected String feature;
    protected List<String> replacements = new ArrayList<String>();
    protected Color gray;
    protected List<String> currentFeatures;
    protected Label enablesLabel2;
    protected Text enablesLabel;
    protected Text enabledByLabel;
    protected Text descriptionLabel;
    protected Table featureTable;
    private final ConfigurationFile configRoot;

    public SupersedeFeatureDialog(Shell parent, WebSphereRuntime wsRuntime, ConfigurationFile configRoot, String feature) {
        super(parent);
        this.feature = feature;
        this.wsRuntime = wsRuntime;
        this.configRoot = configRoot;
        this.setTitleImage(Activator.getImage("wizServer"));
    }

    public SupersedeFeatureDialog(Shell parent, WebSphereServerInfo serverInfo, String feature) {
        super(parent);
        this.feature = feature;
        this.wsRuntime = serverInfo.getWebSphereRuntime();
        this.configRoot = serverInfo.getConfigRoot();
        this.setTitleImage(Activator.getImage("wizServer"));
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.supersedeFeatureDialogTitle);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.supersedeFeatureDialogTitle);
        this.setMessage(NLS.bind((String)Messages.supersededFeatureQuickFix, (Object)this.feature));
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 11;
        layout.marginWidth = 9;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 7;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 450;
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        Label label = new Label(composite, 64);
        label.setText(NLS.bind((String)Messages.supersedeFeatureDialogMessage, (Object)this.feature));
        data = new GridData(1, 2, true, false);
        label.setLayoutData((Object)data);
        label = new Label(composite, 64);
        label.setText(NLS.bind((String)Messages.featureDisplayName, (Object)FeatureList.getFeatureDisplayName((String)this.feature, (WebSphereRuntime)this.wsRuntime)));
        data = new GridData(1, 2, true, false);
        data.horizontalIndent = 15;
        label.setLayoutData((Object)data);
        final ScrolledComposite descriptionScroll2 = new ScrolledComposite(composite, 512);
        final Label descriptionLabel2 = new Label((Composite)descriptionScroll2, 64);
        descriptionLabel2.setText(NLS.bind((String)Messages.featureDescription, (Object)FeatureList.getFeatureDescription((String)this.feature, (WebSphereRuntime)this.wsRuntime)));
        descriptionScroll2.setContent((Control)descriptionLabel2);
        int lineHeight = label.computeSize((int)-1, (int)-1).y;
        data = new GridData(4, 2, true, false);
        data.horizontalIndent = 15;
        data.heightHint = lineHeight * 5;
        descriptionScroll2.setLayoutData((Object)data);
        descriptionScroll2.getVerticalBar().setPageIncrement(lineHeight);
        descriptionScroll2.getVerticalBar().setIncrement(lineHeight);
        this.enablesLabel2 = new Label(composite, 64);
        data = new GridData(1, 2, true, false);
        data.horizontalIndent = 15;
        this.enablesLabel2.setLayoutData((Object)data);
        label = new Label(composite, 64);
        label.setText(NLS.bind((String)Messages.supersedeFeatureDialogMessage2, (Object)this.feature));
        data = new GridData(1, 2, true, false);
        data.verticalIndent = 7;
        label.setLayoutData((Object)data);
        this.featureTable = new Table(composite, 68128);
        data = new GridData(4, 4, true, true);
        data.heightHint = 100;
        this.featureTable.setLayoutData((Object)data);
        FeatureUI.createColumns(this.featureTable);
        final TableColumn infoColumn = new TableColumn(this.featureTable, 0);
        infoColumn.setText(Messages.supersedeFeatureDialogColumn);
        infoColumn.setWidth(125);
        infoColumn.setResizable(true);
        infoColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FeatureUI.sortTable(SupersedeFeatureDialog.this.featureTable, infoColumn);
            }
        });
        Set set = FeatureList.getFeatureSupersededBy((String)this.feature, (WebSphereRuntime)this.wsRuntime);
        ArrayList<String> featureList = new ArrayList<String>();
        FeatureSet installedFeatures = this.wsRuntime.getInstalledFeatures();
        if (set != null) {
            for (Iterator s : set) {
                String f = s;
                if (((String)((Object)s)).startsWith("[") && ((String)((Object)s)).endsWith("]")) {
                    f = ((String)((Object)s)).substring(1, ((String)((Object)s)).length() - 1);
                }
                if (!installedFeatures.supports(f)) continue;
                featureList.add(f);
            }
        }
        Collections.sort(featureList);
        List configuredFeatures = this.configRoot.getAllFeatures();
        configuredFeatures.remove(this.feature);
        this.currentFeatures = new ArrayList<String>();
        block1: for (String s : featureList) {
            if (configuredFeatures.contains(s)) {
                if (this.currentFeatures.contains(s)) continue;
                this.currentFeatures.add(s);
                continue;
            }
            for (String f : configuredFeatures) {
                if (!this.wsRuntime.isContainedBy(s, f)) continue;
                if (this.currentFeatures.contains(s)) continue block1;
                this.currentFeatures.add(s);
                continue block1;
            }
        }
        for (String s : featureList) {
            TableItem item = new TableItem(this.featureTable, 0);
            item.setText(0, s);
            String name = FeatureList.getFeatureDisplayName((String)s, (WebSphereRuntime)this.wsRuntime);
            if (name != null) {
                item.setText(1, name);
            }
            item.setImage(Activator.getImage("featureElement"));
            String status = null;
            if (this.currentFeatures.contains(s)) {
                if (this.gray == null) {
                    Color fg = item.getForeground();
                    Color bg = item.getBackground();
                    this.gray = new Color(fg.getDevice(), (fg.getRed() + bg.getRed()) / 2, (fg.getGreen() + bg.getGreen()) / 2, (fg.getBlue() + bg.getBlue()) / 2);
                }
                item.setForeground(this.gray);
                status = Messages.supersedeFeatureDialogExisting;
            } else if (set != null && set.contains(s)) {
                status = Messages.supersedeFeatureDialogRecommended;
                item.setChecked(true);
                this.replacements.add(s);
            } else {
                status = Messages.supersedeFeatureDialogOptional;
            }
            item.setText(2, status);
        }
        FeatureUI.resizeColumns(this.featureTable);
        ScrolledComposite descriptionScroll = new ScrolledComposite(composite, 512);
        this.descriptionLabel = new Text((Composite)descriptionScroll, 72);
        this.descriptionLabel.setText(NLS.bind((String)Messages.featureDescription, (Object)""));
        this.descriptionLabel.setBackground(parent.getBackground());
        descriptionScroll.setContent((Control)this.descriptionLabel);
        this.enablesLabel = new Text(composite, 8);
        this.enablesLabel.setText(NLS.bind((String)Messages.featureEnables, (Object)""));
        this.enablesLabel.setBackground(parent.getBackground());
        this.enablesLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        data = new GridData(4, 4, true, false);
        lineHeight = this.enablesLabel.computeSize((int)-1, (int)-1).y;
        data.heightHint = lineHeight * 4;
        this.descriptionLabel.setSize(300, lineHeight);
        this.descriptionLabel.setEnabled(false);
        descriptionScroll.setLayoutData((Object)data);
        descriptionScroll.getVerticalBar().setPageIncrement(lineHeight);
        descriptionScroll.getVerticalBar().setIncrement(lineHeight);
        this.enabledByLabel = new Text(composite, 8);
        this.enabledByLabel.setText(NLS.bind((String)Messages.featureEnabledBy, (Object)""));
        this.enabledByLabel.setBackground(parent.getBackground());
        this.enabledByLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        descriptionScroll2.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                int width = descriptionScroll2.getClientArea().width;
                Point p = descriptionLabel2.computeSize(width, -1);
                descriptionLabel2.setSize(p);
                if (p.y < descriptionScroll2.getClientArea().height) {
                    GridData data = (GridData)descriptionScroll2.getLayoutData();
                    data.heightHint = p.y;
                    descriptionScroll2.getParent().layout(true);
                } else {
                    int newWidth = descriptionLabel2.getParent().getClientArea().width;
                    if (newWidth != width) {
                        descriptionLabel2.setSize(newWidth, descriptionLabel2.computeSize((int)newWidth, (int)-1).y);
                    }
                }
                p = SupersedeFeatureDialog.this.descriptionLabel.computeSize(-1, -1);
                SupersedeFeatureDialog.this.descriptionLabel.setSize(p);
            }
        });
        this.featureTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SupersedeFeatureDialog.this.replacements.clear();
                for (TableItem ti : SupersedeFeatureDialog.this.featureTable.getItems()) {
                    String feature = ti.getText(0);
                    if (!ti.getChecked() || SupersedeFeatureDialog.this.currentFeatures.contains(feature)) continue;
                    SupersedeFeatureDialog.this.replacements.add(feature);
                }
                FeatureUI.updateInfo(SupersedeFeatureDialog.this.enablesLabel, SupersedeFeatureDialog.this.enabledByLabel, SupersedeFeatureDialog.this.descriptionLabel, SupersedeFeatureDialog.this.featureTable, null, SupersedeFeatureDialog.this.wsRuntime);
                SupersedeFeatureDialog.this.validate(SupersedeFeatureDialog.this.featureTable.getItems());
            }
        });
        this.featureTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                if (SupersedeFeatureDialog.this.gray != null) {
                    SupersedeFeatureDialog.this.gray.dispose();
                }
            }
        });
        return composite;
    }

    public void create() {
        super.create();
        String enables = FeatureUI.formatList(FeatureList.getFeatureChildren((String)this.feature, (WebSphereRuntime)this.wsRuntime));
        String text = NLS.bind((String)Messages.featureEnables, (Object)enables);
        String shortenedText = SWTUtil.shortenText((Control)this.enablesLabel2, text, Messages.featureEnables.length());
        this.enablesLabel2.setText(shortenedText);
        this.enablesLabel2.setToolTipText(enables);
        FeatureUI.updateInfo(this.enablesLabel, this.enabledByLabel, this.descriptionLabel, this.featureTable, null, this.wsRuntime);
    }

    protected void validate(TableItem[] tis) {
        Set set = FeatureList.getFeatureSupersededBy((String)this.feature, (WebSphereRuntime)this.wsRuntime);
        for (TableItem ti : tis) {
            String s = ti.getText(0);
            if (ti.getChecked() && this.currentFeatures.contains(s)) {
                this.setMessage(NLS.bind((String)Messages.supersedeFeatureDialogErrorExisting, (Object)s), 2);
                return;
            }
            if (ti.getChecked() || !set.contains(s) || this.currentFeatures.contains(s)) continue;
            this.setMessage(NLS.bind((String)Messages.supersedeFeatureDialogErrorRecommended, (Object)s), 3);
            return;
        }
        this.setMessage(NLS.bind((String)Messages.supersededFeatureQuickFix, (Object)this.feature));
    }

    public String[] getReplacementFeatures() {
        return this.replacements.toArray(new String[this.replacements.size()]);
    }
}

