/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.marker;

import com.ibm.ws.st.core.internal.Activator;
import com.ibm.ws.st.core.internal.FeatureConflictHandler;
import com.ibm.ws.st.core.internal.RuntimeFeatureResolver;
import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.marker.AbstractMarkerResolution;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.osgi.util.NLS;

public class QuickFixFeatureConflict
extends AbstractMarkerResolution {
    private final String feature;

    public QuickFixFeatureConflict(String feature) {
        this.feature = feature;
    }

    public String getLabel() {
        return NLS.bind((String)Messages.featureConflictQuickFix, (Object[])new String[]{this.feature});
    }

    public void run(IMarker marker) {
        IFile resource = this.getResource(marker);
        if (resource == null) {
            return;
        }
        ConfigurationFile configFile = this.getConfigFile((IResource)resource);
        if (configFile == null) {
            return;
        }
        WebSphereRuntime webSphereRuntime = null;
        WebSphereServerInfo wsInfo = configFile.getWebSphereServer();
        if (wsInfo != null) {
            webSphereRuntime = wsInfo.getWebSphereRuntime();
        } else {
            UserDirectory userDirectory = configFile.getUserDirectory();
            if (userDirectory != null) {
                webSphereRuntime = userDirectory.getWebSphereRuntime();
            }
        }
        if (webSphereRuntime == null) {
            return;
        }
        FeatureConflictHandler featureConflictHandler = Activator.getFeatureConflictHandler();
        if (featureConflictHandler == null) {
            return;
        }
        RuntimeFeatureResolver.ResolverResult result = RuntimeFeatureResolver.resolve((WebSphereRuntime)webSphereRuntime, (List)configFile.getAllFeatures());
        HashMap alwaysAdd = new HashMap();
        if (wsInfo != null ? !featureConflictHandler.handleFeatureConflicts(wsInfo, alwaysAdd, result.getFeatureConflicts(), true) : !featureConflictHandler.handleFeatureConflicts(webSphereRuntime, configFile, alwaysAdd, result.getFeatureConflicts(), true)) {
            return;
        }
        try {
            configFile.save(null);
        }
        catch (IOException e) {
            if (Trace.ENABLED) {
                Trace.trace((byte)6, "Feature conflicts quick fix failed. Error trying to update configuration: " + configFile.getURI(), e);
            }
            this.showErrorMessage();
        }
    }

    @Override
    protected String getErrorMessage() {
        return Messages.featureConflictFailedMessage;
    }
}

