/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.download;

import com.ibm.ws.st.core.internal.repository.IRuntimeInfo;
import com.ibm.ws.st.core.internal.repository.ISite;
import com.ibm.ws.st.ui.internal.download.AbstractSiteManager;
import com.ibm.ws.st.ui.internal.download.DefaultSiteManager;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class SiteHelper {
    private static final String EXTENSION_ID = "com.ibm.ws.st.ui.siteManager";
    private static final String MANAGER_ELEMENT = "manager";
    private static final String CLASS_ATTRIBUTE = "class";
    private static AbstractSiteManager siteManager;

    private static synchronized AbstractSiteManager getSiteManager() {
        if (siteManager == null) {
            IConfigurationElement[] extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
            for (int i = 0; i < extensions.length; ++i) {
                IConfigurationElement configurationElement = extensions[i];
                if (!MANAGER_ELEMENT.equals(configurationElement.getName())) continue;
                try {
                    Object object = configurationElement.createExecutableExtension(CLASS_ATTRIBUTE);
                    if (!(object instanceof AbstractSiteManager)) continue;
                    siteManager = (AbstractSiteManager)object;
                    break;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (siteManager == null) {
                siteManager = new DefaultSiteManager();
            }
        }
        return siteManager;
    }

    public static boolean downloadAndInstallSupported() {
        return SiteHelper.getSiteManager().downloadAndInstallSupported();
    }

    static ISite[] getPredefinedRuntimeSites() {
        return SiteHelper.getSiteManager().getPredefinedRuntimeRepositories();
    }

    static ISite[] getAvailableSites() {
        return SiteHelper.getSiteManager().getAvailableRepositories();
    }

    static SiteDelegate[] getConfigurableSites() {
        return SiteHelper.getSiteManager().getConfigurableRepositories();
    }

    static SiteDelegate[] getSelectedSites() {
        return SiteHelper.getSiteManager().getSelectedRepositories();
    }

    static ISite getDefaultAddOnSite() {
        return SiteHelper.getSiteManager().getDefaultAddOnRepository();
    }

    static SiteDelegate getDefaultSiteDelegate() {
        return SiteHelper.getSiteManager().getDefaultRepositoryDelegate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean isSocketAvailable(String host, int port) {
        if (host == null) {
            return false;
        }
        Socket s = null;
        try {
            s = new Socket();
            s.connect(new InetSocketAddress(host, port), 10000);
            if (s == null) return true;
        }
        catch (Throwable t) {
            try {
                boolean bl = false;
                return bl;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        try {
            s.close();
            return true;
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static boolean isProxyNeeded() {
        return SiteHelper.getSiteManager().isProxyEnabled();
    }

    public static boolean isRepoSupported(ISite site, IRuntimeInfo runtimeInfo) {
        return SiteHelper.getSiteManager().isRepoSupported(site, runtimeInfo);
    }

    public static boolean isZipRepoSupported(IRuntimeInfo runtimeInfo) {
        return SiteHelper.getSiteManager().isZipRepoSupported(runtimeInfo);
    }

    public static boolean isValidOnPremZipRepository(File file) {
        return SiteHelper.getSiteManager().isValidOnPremZipRepository(file);
    }

    public static String getRepoPropertiesURL() {
        return SiteHelper.getSiteManager().getRepoPropertiesURL();
    }

    static boolean applyConfigSiteChanges(List<SiteDelegate> allSites, List<SiteDelegate> selectedSites) {
        return SiteHelper.getSiteManager().applyConfigRepositoryChanges(allSites, selectedSites);
    }

    public static class SiteDelegate {
        private String name;
        private URL url;
        private String user;
        private String password;
        private boolean isDefault;
        private State state;

        public SiteDelegate(String name) {
            this.name = name;
            this.state = State.ORIGINAL;
        }

        public SiteDelegate(SiteDelegate original) {
            this.name = original.name;
            this.url = original.url;
            this.user = original.user;
            this.password = original.password;
            this.state = State.COPY;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public void setIsDefault(boolean isDefault) {
            this.isDefault = isDefault;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public URL getURL() {
            return this.url;
        }

        public void setURL(URL url) {
            this.url = url;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public State getState() {
            return this.state;
        }

        public void setState(State state) {
            this.state = state;
        }

        public static enum State {
            ORIGINAL,
            COPY,
            NEW;

        }
    }
}

