/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.config;

import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.config.ConfigUtils;
import com.ibm.ws.st.core.internal.config.DOMUtils;
import com.ibm.ws.st.core.internal.config.SchemaUtil;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.config.AddConfigElemDialog;
import com.ibm.ws.st.ui.internal.config.ConfigUIUtils;
import com.ibm.ws.st.ui.internal.config.EnableElementDialog;
import com.ibm.xwt.dde.customization.ICustomElementListSelectionDialog;
import com.ibm.xwt.dde.editor.DDEMultiPageEditorPart;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AddConfigElemCustomObject
implements ICustomElementListSelectionDialog {
    public void invoke(Element element) {
        Shell shell = Display.getCurrent().getActiveShell();
        AddConfigElemDialog dialog = new AddConfigElemDialog(shell, element);
        if (dialog.open() == 0) {
            Element child;
            IWorkbenchPage page;
            IEditorPart part = null;
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null && (page = window.getActivePage()) != null) {
                part = page.getActiveEditor();
            }
            CMElementDeclaration newItem = dialog.getNewItem();
            if ("server".equals(element.getNodeName()) && part != null) {
                URI uri = ConfigUIUtils.getURI(part.getEditorInput());
                WebSphereRuntime wsRuntime = ConfigUIUtils.getRuntime(part);
                if (uri != null && wsRuntime != null) {
                    Document doc = element.getOwnerDocument();
                    List<String> currentFeatures = ConfigUIUtils.getFeatures(part.getEditorInput(), doc);
                    List possibleFeatures = ConfigUtils.getFeaturesToEnable((String)newItem.getElementName(), currentFeatures, (WebSphereRuntime)wsRuntime);
                    if (possibleFeatures != null && !possibleFeatures.isEmpty()) {
                        Collections.sort(possibleFeatures);
                        EnableElementDialog enableDialog = new EnableElementDialog(shell, wsRuntime, newItem.getElementName(), possibleFeatures);
                        if (enableDialog.open() == 0) {
                            List<String> features = enableDialog.getSelectedFeatures();
                            for (String feature : features) {
                                CMElementDeclaration elemDecl;
                                Element featureElem = null;
                                Element featureManager = DOMUtils.getFirstChildElement((Node)doc.getDocumentElement(), (String)"featureManager");
                                if (featureManager == null && (elemDecl = SchemaUtil.getElement((Document)doc, (String[])new String[]{"server", "featureManager"}, (URI)uri)) != null) {
                                    featureManager = ConfigUtils.addElement((Element)doc.getDocumentElement(), (CMElementDeclaration)elemDecl);
                                }
                                if (featureManager != null && (elemDecl = SchemaUtil.getElement((Document)doc, (String[])new String[]{"server", "featureManager", "feature"}, (URI)uri)) != null) {
                                    featureElem = ConfigUtils.addElement((Element)featureManager, (CMElementDeclaration)elemDecl, (String)feature);
                                }
                                if (featureElem != null) continue;
                                Trace.logError("Failed to add feature: " + feature, null);
                            }
                        }
                    }
                }
            }
            if ((child = ConfigUtils.addElement((Element)element, (CMElementDeclaration)newItem)) == null) {
                Trace.logError("Failed to add child element: " + newItem.getNodeName(), null);
                return;
            }
            if (part != null && part instanceof DDEMultiPageEditorPart) {
                ((DDEMultiPageEditorPart)part).refresh();
                ((DDEMultiPageEditorPart)part).setSelection((Node)child);
            }
        }
    }
}

