/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.config;

import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.config.ConfigUtils;
import com.ibm.ws.st.core.internal.config.ConfigVars;
import com.ibm.ws.st.core.internal.config.ConfigVarsUtils;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.config.ConfigUIUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SearchPattern;
import org.w3c.dom.Document;

public abstract class AbstractBrowseDialog
extends TitleAreaDialog {
    protected static final String VAR_DATA = "varData";
    protected static final String SHAREDCONFIGVAR = ConfigVarsUtils.getVarRef((String)"shared.config.dir");
    protected static final String SHAREDAPPVAR = ConfigVarsUtils.getVarRef((String)"shared.app.dir");
    protected static final String SHAREDRESVAR = ConfigVarsUtils.getVarRef((String)"shared.resource.dir");
    protected static final int PATH_MIN_LEN = 10;
    protected Document document = null;
    protected URI documentURI = null;
    protected WebSphereServerInfo server = null;
    protected UserDirectory userDir = null;
    protected VariableEntry[] cachedVariables = null;
    protected VariableEntry selectedVar = null;
    protected Text entryText = null;
    protected Text locationText = null;
    protected Text pathText = null;
    protected String selectedPath = null;
    protected boolean isOK = false;
    protected boolean updating = false;
    protected String currentText = null;
    protected boolean directoriesOnly = false;
    protected ISharedImages sharedImages;
    protected FileComparator fileComparator = new FileComparator();
    protected SearchPattern pattern = new SearchPattern(35);
    protected ConfigVars configVars = null;

    public AbstractBrowseDialog(Shell parent, Document document, IEditorInput editorInput) {
        super(parent);
        this.document = document;
        this.documentURI = ConfigUIUtils.getURI(editorInput);
        WebSphereServerInfo server = ConfigUtils.getServerInfo((URI)this.documentURI);
        if (server != null) {
            this.server = server;
            this.userDir = server.getUserDirectory();
        } else {
            this.userDir = ConfigUtils.getUserDirectory((URI)this.documentURI);
        }
        this.sharedImages = PlatformUI.getWorkbench().getSharedImages();
    }

    public String getFullPath() {
        if (this.isOK) {
            return this.getCurrentPath();
        }
        return null;
    }

    public String getAbsolutePath() {
        if (this.isOK) {
            String path = this.getSelectedPath();
            StringBuilder builder = new StringBuilder();
            String basePath = this.selectedVar.getPath();
            if (basePath != null) {
                builder.append(basePath);
                if (path != null && !path.isEmpty()) {
                    builder.append('/');
                }
            }
            if (path != null) {
                builder.append(path);
            }
            return builder.toString();
        }
        return null;
    }

    public int open() {
        if (this.getVariables().length > 0) {
            return super.open();
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.title, (String)Messages.locationDialogNoRelPathsInfo);
        return 1;
    }

    protected VariableEntry[] getVariables() {
        if (this.cachedVariables == null) {
            this.cachedVariables = this.initVariables();
        }
        return this.cachedVariables;
    }

    protected String getCurrentPath() {
        String path = this.getSelectedPath();
        StringBuilder builder = new StringBuilder();
        String varPath = this.selectedVar.getVarPath();
        if (varPath != null) {
            builder.append(varPath);
            if (path != null && !path.isEmpty()) {
                builder.append('/');
            }
        }
        if (path != null) {
            builder.append(path);
        }
        return builder.toString();
    }

    protected String getSelectedPath() {
        String path = this.selectedPath;
        if (path == null) {
            path = this.currentText;
        }
        return path;
    }

    protected abstract String getDialogTitle();

    protected abstract String getDialogLabel();

    protected abstract String getDialogMessage();

    protected abstract String getEntryLabel();

    protected abstract VariableEntry[] initVariables();

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.getDialogTitle());
    }

    protected boolean isResizable() {
        return true;
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (buttonId == 0) {
            this.isOK = true;
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.getDialogLabel());
        this.setTitleImage(Activator.getImage("wizServer"));
        this.setMessage(this.getDialogMessage());
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 11;
        layout.marginWidth = 9;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 7;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        Composite leftComposite = new Composite(composite, 0);
        layout = new GridLayout();
        leftComposite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, false, true);
        leftComposite.setLayoutData((Object)data);
        Composite rightComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        rightComposite.setLayout((Layout)layout);
        data = new GridData(4, 4, true, true);
        rightComposite.setLayoutData((Object)data);
        final Text varFilter = new Text(leftComposite, 2048);
        data = new GridData(4, 4, false, false);
        varFilter.setLayoutData((Object)data);
        varFilter.setMessage(Messages.filterMessage);
        final Table varTable = new Table(leftComposite, 2820);
        data = new GridData(4, 4, false, true);
        varTable.setLayoutData((Object)data);
        this.initVarTable(varTable, null);
        Label label = new Label(rightComposite, 64);
        label.setText(Messages.selectedPath);
        data = new GridData(4, 2, false, false);
        label.setLayoutData((Object)data);
        this.pathText = new Text(rightComposite, 8);
        data = new GridData(4, 4, true, false);
        this.pathText.setLayoutData((Object)data);
        final Tree selectionTree = new Tree(rightComposite, 2820);
        data = new GridData(4, 4, true, true);
        data.widthHint = data.heightHint = 256;
        data.horizontalSpan = 2;
        selectionTree.setLayoutData((Object)data);
        Label entryLabel = new Label(rightComposite, 64);
        entryLabel.setText(this.getEntryLabel());
        data = new GridData(4, 1, true, false);
        data.horizontalSpan = 2;
        entryLabel.setLayoutData((Object)data);
        this.entryText = new Text(rightComposite, 2048);
        data = new GridData(4, 4, true, false);
        data.horizontalSpan = 2;
        this.entryText.setLayoutData((Object)data);
        Label locationLabel = new Label(leftComposite, 64);
        locationLabel.setText(Messages.selectedLocation);
        data = new GridData(3, 2, false, false);
        locationLabel.setLayoutData((Object)data);
        this.locationText = new Text(rightComposite, 8);
        data = new GridData(4, 4, true, false);
        data.horizontalSpan = 2;
        this.locationText.setLayoutData((Object)data);
        varFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String text = varFilter.getText();
                String filter = null;
                if (text != null) {
                    filter = text;
                }
                AbstractBrowseDialog.this.initVarTable(varTable, filter);
                varTable.setSelection(0);
                AbstractBrowseDialog.this.selectedVar = (VariableEntry)varTable.getItem(0).getData(AbstractBrowseDialog.VAR_DATA);
                AbstractBrowseDialog.this.updatePathText();
                AbstractBrowseDialog.this.initRootItems(selectionTree, AbstractBrowseDialog.this.selectedVar.getPath());
                AbstractBrowseDialog.this.entryText.clearSelection();
                AbstractBrowseDialog.this.entryText.setText("");
                AbstractBrowseDialog.this.updateLocation();
                varFilter.setFocus();
            }
        });
        varTable.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableItem[] selections = varTable.getSelection();
                if (selections.length == 0) {
                    return;
                }
                TableItem item = selections[0];
                AbstractBrowseDialog.this.selectedVar = (VariableEntry)item.getData(AbstractBrowseDialog.VAR_DATA);
                AbstractBrowseDialog.this.updatePathText();
                AbstractBrowseDialog.this.initRootItems(selectionTree, AbstractBrowseDialog.this.selectedVar.getPath());
                AbstractBrowseDialog.this.updateLocation();
                AbstractBrowseDialog.this.entryText.clearSelection();
                AbstractBrowseDialog.this.entryText.setText("");
                varTable.setFocus();
            }
        });
        selectionTree.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (AbstractBrowseDialog.this.updating) {
                    return;
                }
                AbstractBrowseDialog.this.updating = true;
                TreeItem item = (TreeItem)event.item;
                AbstractBrowseDialog.this.selectedPath = AbstractBrowseDialog.this.getPath(item);
                AbstractBrowseDialog.this.entryText.setText(AbstractBrowseDialog.this.selectedPath);
                AbstractBrowseDialog.this.updateLocation();
                AbstractBrowseDialog.this.updating = false;
            }
        });
        selectionTree.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                TreeItem item = (TreeItem)event.item;
                AbstractBrowseDialog.this.selectedPath = AbstractBrowseDialog.this.getPath(item);
                AbstractBrowseDialog.this.buttonPressed(0);
                AbstractBrowseDialog.this.close();
            }
        });
        selectionTree.addListener(17, new Listener(){

            public void handleEvent(Event event) {
                TreeItem item = (TreeItem)event.item;
                AbstractBrowseDialog.this.initChildren(item);
            }
        });
        this.entryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (AbstractBrowseDialog.this.updating) {
                    return;
                }
                AbstractBrowseDialog.this.updating = true;
                String text = AbstractBrowseDialog.this.entryText.getText();
                Path path = new Path(text = text.replace('\\', '/'));
                TreeItem item = AbstractBrowseDialog.this.getFirstMatch(selectionTree, path);
                if (item != null) {
                    File file = (File)item.getData();
                    if (file.isDirectory() && text.endsWith("/") && !item.getExpanded()) {
                        AbstractBrowseDialog.this.initChildren(item);
                        item.setExpanded(true);
                    }
                    selectionTree.setSelection(item);
                    AbstractBrowseDialog.this.selectedPath = AbstractBrowseDialog.this.getPath(item);
                } else {
                    selectionTree.deselectAll();
                    AbstractBrowseDialog.this.selectedPath = null;
                }
                AbstractBrowseDialog.this.currentText = AbstractBrowseDialog.this.entryText.getText();
                AbstractBrowseDialog.this.updateLocation();
                AbstractBrowseDialog.this.entryText.setFocus();
                AbstractBrowseDialog.this.updating = false;
            }
        });
        this.selectedVar = this.getVariables()[0];
        varTable.setSelection(new int[]{0});
        this.initRootItems(selectionTree, this.selectedVar.getPath());
        return composite;
    }

    public void create() {
        super.create();
        this.updatePathText();
        this.updateLocation();
        this.entryText.setFocus();
    }

    protected void updatePathText() {
        String pathString = this.selectedVar.getPath();
        if (pathString == null) {
            pathString = "";
        }
        this.pathText.setText(AbstractBrowseDialog.shortenText((String)pathString, (Control)this.pathText));
        this.pathText.setToolTipText(pathString);
    }

    protected void updateLocation() {
        String currentPath = this.getCurrentPath();
        if (currentPath.isEmpty()) {
            currentPath = Messages.emptyLocation;
            this.getButton(0).setEnabled(false);
        } else {
            this.getButton(0).setEnabled(true);
        }
        this.locationText.setText(currentPath);
        this.locationText.setToolTipText(currentPath);
    }

    protected void initVarTable(Table varTable, String filter) {
        varTable.removeAll();
        VariableEntry[] variables = this.getVariables();
        if (filter == null) {
            for (VariableEntry variable : variables) {
                this.addEntry(varTable, variable);
            }
        } else {
            this.pattern.setPattern("*" + filter + "*");
            for (VariableEntry variable : variables) {
                if (!variable.match(this.pattern)) continue;
                this.addEntry(varTable, variable);
            }
        }
    }

    protected void addEntry(Table varTable, VariableEntry variable) {
        TableItem item = new TableItem(varTable, 0);
        item.setText(variable.getName());
        item.setImage(variable.getImage());
        item.setData(VAR_DATA, (Object)variable);
    }

    protected void initRootItems(Tree tree, String path) {
        tree.removeAll();
        File[] files = null;
        boolean isRoot = false;
        if (path != null) {
            File file = new File(path);
            files = file.listFiles();
        } else {
            files = File.listRoots();
            if (files.length == 1) {
                files = files[0].listFiles();
            } else {
                isRoot = true;
            }
        }
        if (files == null) {
            return;
        }
        Arrays.sort(files, this.fileComparator);
        for (File child : files) {
            if (this.directoriesOnly && !child.isDirectory()) continue;
            TreeItem item = new TreeItem(tree, 0);
            item.setText(isRoot ? child.getPath() : child.getName());
            item.setData((Object)child);
            if (child.isDirectory()) {
                item.setItemCount(1);
                item.setImage(this.getDirImage());
                continue;
            }
            item.setImage(this.getFileImage());
        }
    }

    protected void initChildren(TreeItem parent) {
        parent.removeAll();
        File file = (File)parent.getData();
        if (file == null) {
            return;
        }
        File[] files = file.listFiles();
        if (files == null) {
            return;
        }
        Arrays.sort(files, this.fileComparator);
        for (File child : files) {
            if (this.directoriesOnly && !child.isDirectory()) break;
            TreeItem item = new TreeItem(parent, 0);
            item.setText(child.getName());
            item.setData((Object)child);
            if (child.isDirectory()) {
                item.setItemCount(1);
                item.setImage(this.getDirImage());
                continue;
            }
            item.setImage(this.getFileImage());
        }
    }

    protected String getPath(TreeItem item) {
        if (this.selectedVar.getAbsolute()) {
            File file = (File)item.getData();
            try {
                return file.getCanonicalPath();
            }
            catch (IOException e) {
                Trace.logError("Failed to get canonical path for: " + file.toString(), e);
                return file.getPath();
            }
        }
        TreeItem parent = item.getParentItem();
        if (parent != null) {
            return this.getPath(parent) + "/" + item.getText();
        }
        return item.getText();
    }

    protected TreeItem getFirstMatch(Tree tree, Path path) {
        TreeItem result = null;
        String[] segments = path.segments();
        if (segments.length > 0) {
            result = this.getFirstMatch(tree.getItems(), segments[0]);
            for (int i = 1; i < segments.length && result != null; ++i) {
                result = this.getFirstMatch(result.getItems(), segments[i]);
            }
        }
        return result;
    }

    protected TreeItem getFirstMatch(TreeItem[] items, String filter) {
        for (TreeItem item : items) {
            String name = item.getText();
            if (!name.startsWith(filter)) continue;
            return item;
        }
        return null;
    }

    protected TreeItem[] getComboList(Tree tree, String filter) {
        TreeItem[] items;
        ArrayList<TreeItem> list = new ArrayList<TreeItem>(20);
        for (TreeItem item : items = tree.getItems()) {
            String name = item.getText();
            if (filter != null && !name.startsWith(filter)) continue;
            list.add(item);
        }
        return list.toArray(new TreeItem[list.size()]);
    }

    protected TreeItem[] getComboList(TreeItem parent, String filter) {
        TreeItem[] items;
        ArrayList<TreeItem> list = new ArrayList<TreeItem>(20);
        for (TreeItem item : items = parent.getItems()) {
            String name = item.getText();
            if (filter != null && !name.startsWith(filter)) continue;
            list.add(item);
        }
        return list.toArray(new TreeItem[list.size()]);
    }

    protected String[] getTextList(TreeItem[] items) {
        String[] textList = new String[items.length];
        for (int i = 0; i < items.length; ++i) {
            textList[i] = items[i].getText();
        }
        return textList;
    }

    protected String getFilter(String path) {
        int index = Math.max(path.indexOf(47), path.indexOf(92));
        if (index < 1) {
            if (path.length() > 0) {
                return path;
            }
            return null;
        }
        String filter = path.substring(index);
        if (filter.length() == 0) {
            return null;
        }
        return filter;
    }

    protected TreeItem getCurrentSelection(Tree tree) {
        TreeItem[] selections = tree.getSelection();
        if (selections.length > 0) {
            return selections[0];
        }
        return null;
    }

    protected Image getFileImage() {
        return this.sharedImages.getImage("IMG_OBJ_FILE");
    }

    protected Image getDirImage() {
        return this.sharedImages.getImage("IMG_OBJ_FOLDER");
    }

    protected void addConfigVars(ArrayList<VariableEntry> list, String skip, boolean includeDocVars) {
        ConfigVars vars = this.getConfigVars();
        if (this.document != null && includeDocVars) {
            ConfigurationFile configFile = null;
            if (this.server != null && this.documentURI != null) {
                configFile = this.server.getConfigurationFileFromURI(this.documentURI);
            }
            ConfigUtils.getVariables((ConfigurationFile)configFile, (Document)this.document, (URI)this.documentURI, (WebSphereServerInfo)this.server, (UserDirectory)this.userDir, (ConfigVars)vars);
        }
        List names = vars.getSortedVars(ConfigVars.STRING_TYPES, false);
        for (String name : names) {
            String path;
            String value;
            File file;
            if (skip != null && name.equals(skip) || !(file = new File(value = vars.getValue(name))).exists() || this.directoriesOnly && !file.isDirectory()) continue;
            try {
                path = file.getCanonicalPath();
            }
            catch (IOException e) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)1, "Could not get canonical path for: " + value, e);
                }
                path = value;
            }
            list.add(new VariableEntry(name, path, ConfigVarsUtils.getVarRef((String)name), Activator.getImage("absolutePath")));
        }
    }

    protected ConfigVars getConfigVars() {
        if (this.configVars == null) {
            ConfigVars vars = new ConfigVars();
            if (this.server != null) {
                this.server.getVariables(vars, true);
            } else if (this.userDir != null) {
                this.userDir.getVariables(vars, true);
            }
            this.configVars = vars;
        }
        return this.configVars;
    }

    protected static class VariableEntry {
        protected final String varName;
        protected final String path;
        protected final String varPath;
        protected final Image image;
        protected boolean isAbsolute;

        public VariableEntry(String varName, String path, String varPath, Image image) {
            this.varName = varName;
            this.path = path;
            this.varPath = varPath;
            this.image = image;
        }

        public String getName() {
            return this.varName;
        }

        public String getPath() {
            return this.path;
        }

        public String getVarPath() {
            return this.varPath;
        }

        public Image getImage() {
            return this.image;
        }

        public void setAbsolute(boolean value) {
            this.isAbsolute = value;
        }

        public boolean getAbsolute() {
            return this.isAbsolute;
        }

        public boolean match(SearchPattern pattern) {
            return pattern.matches(this.varName);
        }

        public String toString() {
            return "Name: " + this.varName + ", Path: " + this.path;
        }
    }

    protected static class FileComparator
    implements Comparator<File>,
    Serializable {
        protected FileComparator() {
        }

        @Override
        public int compare(File file1, File file2) {
            if (file1.isDirectory() && !file2.isDirectory()) {
                return -1;
            }
            if (!file1.isDirectory() && file2.isDirectory()) {
                return 1;
            }
            String name1 = file1.getName();
            String name2 = file2.getName();
            return name1.compareToIgnoreCase(name2);
        }
    }
}

